#ifndef IMAGEPROPERTIESWINDOW_H
#define IMAGEPROPERTIESWINDOW_H

#include <string>

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/combobox.h>
#include <gtkmm/entry.h>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/label.h>
#include <gtkmm/liststore.h>
#include <gtkmm/frame.h>
#include <gtkmm/scale.h>
#include <gtkmm/window.h>

#include "../plot/colormap.h"

class ImagePropertiesWindow : public Gtk::Window {
 public:
  ImagePropertiesWindow(class PlotWidget& plotWidget, const std::string& title);
  ~ImagePropertiesWindow() {}

 private:
  void onApplyClicked();
  void onCloseClicked();
  void onExportClicked();
  void onExportDataClicked();

  void onScaleChanged() {
    _scaleMinEntry.set_sensitive(_specifiedScaleButton.get_active());
    _scaleMaxEntry.set_sensitive(_specifiedScaleButton.get_active());
  }

  void initColorMapButtons();
  void initScaleWidgets();
  void initOptionsWidgets();
  void initFilterWidgets();
  void initAxisWidgets();

  void updateMinMaxEntries();

  class PlotWidget& _plotWidget;
  class MaskedHeatMap* _maskedHeatMap;

  Gtk::Box _bottomButtonBox;
  Gtk::Box _topVBox{Gtk::Orientation::VERTICAL};
  Gtk::Box _framesHBox;

  void addColorMap(const Glib::ustring& name, ColorMap::Type map) {
    Gtk::TreeModel::Row row = (*_colorMapStore->append());
    row[_colorMapColumns.name] = name;
    row[_colorMapColumns.colorMap] = map;
  }
  struct ColorMapColumns : public Gtk::TreeModel::ColumnRecord {
    ColorMapColumns() {
      add(name);
      add(colorMap);
    }
    Gtk::TreeModelColumn<Glib::ustring> name;
    Gtk::TreeModelColumn<ColorMap::Type> colorMap;
  };

  ColorMapColumns _colorMapColumns;
  Gtk::Button _applyButton, _exportButton, _exportDataButton, _closeButton;
  Gtk::Frame _colorMapFrame;
  Gtk::Box _colorMapBox{Gtk::Orientation::VERTICAL};
  Gtk::ComboBox _colorMapCombo;
  Glib::RefPtr<Gtk::ListStore> _colorMapStore;

  Gtk::Frame _scaleFrame;
  Gtk::Box _scaleBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _minMaxScaleButton, _winsorizedScaleButton,
      _specifiedScaleButton;
  Gtk::Label _scaleMinLabel, _scaleMaxLabel;
  Gtk::Entry _scaleMinEntry, _scaleMaxEntry;

  Gtk::Box _filterAndOptionsBox{Gtk::Orientation::VERTICAL};

  Gtk::Frame _optionsFrame;
  Gtk::Box _optionsBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _normalOptionsButton, _logScaleButton;

  Gtk::Frame _filterFrame;
  Gtk::Box _filterBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _bestFilterButton, _nearestFilterButton;

  Gtk::Frame _axesFrame;
  Gtk::Box _axesHBox;
  Gtk::Box _axesGeneralBox{Gtk::Orientation::VERTICAL};
  Gtk::Box _axesVisibilityBox{Gtk::Orientation::VERTICAL};
  Gtk::CheckButton _showXYAxes, _showColorScale;
  Gtk::Box _titleBox, _xAxisBox, _yAxisBox, _zAxisBox;
  Gtk::CheckButton _showTitleButton, _showXAxisDescriptionButton,
      _showYAxisDescriptionButton, _showZAxisDescriptionButton;
  Gtk::CheckButton _manualXAxisDescription, _manualYAxisDescription,
      _manualZAxisDescription;
  Gtk::Entry _titleEntry, _xAxisDescriptionEntry, _yAxisDescriptionEntry,
      _zAxisDescriptionEntry;
  std::unique_ptr<Gtk::FileChooserDialog> dialog_;
};

#endif  // IMAGEPROPERTIESWINDOW_H
