/*---------------------------------------------------------------------------*\
** $Author: antanas $
** $Date: 2021-07-30 20:10:23 +0300 (Fri, 30 Jul 2021) $
** $Revision: 8841 $
** $URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.11.0/src/externals/cexceptions/allocx.h $
\*---------------------------------------------------------------------------*/

#ifndef __ALLOCX_H
#define __ALLOCX_H

/* memory allocation functions that use cexception handling */

#include <stdlib.h>
#include <cexceptions.h>

typedef enum {
    ALLOCX_OK = 0,
    ALLOCX_NO_MEMORY = 99,
    ALLOCX_last
} ALLOCX_ERROR;

extern void *allocx_subsystem;

void *mallocx( size_t size, cexception_t *ex );
void *callocx( size_t size, size_t nr, cexception_t *ex );
void *reallocx( void *buffer, size_t new_size, cexception_t *ex );
void *creallocx( void *buffer,
		 size_t old_element_nr,
		 size_t new_element_nr,
		 size_t element_size,
		 cexception_t *ex );
void freex( void* );

#endif
