#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/Tags/Print.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_MODULE} qw( print_single_tag_and_value )" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 16:42:43 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10064 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.11.0/tests/shtests/print_single_tag_and_value_008.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Print::print_single_tag_and_value()
#* subroutine. Tests the way CIF 2.0 data item values that are near the
#* max line length limit of 80 symbols are handled.
#**

use strict;
use warnings;

# use COD::CIF::Tags::Print qw( print_single_tag_and_value );

my $fold_long_fields = 0;
my $folding_width = 80;
my $cif_version = '2';

my $value_with_spaces    = 'Long value with white space symbols ++++++++';
my $value_without_spaces = '$Long-value-with-no-white-space-symbols-++++';

print "# Total line length: 79\n";
print_single_tag_and_value(
    "_test_case_1_a",
    $value_with_spaces,
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print_single_tag_and_value(
    "_test_case_1_b",
    $value_without_spaces,
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print "\n";

print "# Total line length: 80\n";
print_single_tag_and_value(
    "_test_case_2_a",
    "$value_with_spaces+",
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print_single_tag_and_value(
    "_test_case_2_b",
    "$value_without_spaces+",
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print "\n";

print "# Total line length: 81\n";
print_single_tag_and_value(
    "_test_case_2_a",
    "$value_with_spaces++",
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print_single_tag_and_value(
    "_test_case_2_b",
    "$value_without_spaces++",
    $fold_long_fields,
    $folding_width,
    $cif_version
);

print "\n";

END_SCRIPT
