/*
 * Copyright (C) 2020 ~ 2021, Deepin Technology Co., Ltd. <support@deepin.org>
 *
 * Author:     xiangxiaojun <xiangxiaoju@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/**
  *@file 这个文件是负责实现全屏展示进度控件相关
  */
#include "movie_progress_indicator.h"
#include "utils.h"

namespace dmr {
/**
 * @brief MovieProgressIndicator 构造函数
 * @param parent 父窗口
 */
MovieProgressIndicator::MovieProgressIndicator(QWidget *parent)
    : QFrame(parent)
{
    initMember();

    QFont font;
    //参考设计图
    font.setPixelSize(14);
    QFontMetrics fontMetrics(font);
    this->setFont(font);
    m_fixedSize = QSize(qMax(52, fontMetrics.width("999:99")), fontMetrics.height() + 10);
    this->setFixedSize(m_fixedSize);
}
/**
 * @brief paintEvent 重载绘制事件函数
 * @param pPaintEvent
 */
void MovieProgressIndicator::paintEvent(QPaintEvent *pPaintEvent)
{
    QString sTimeText = QTime::currentTime().toString("hh:mm");
    QPainter painter(this);
    painter.setFont(font());
    painter.setPen(QColor(255, 255, 255, static_cast<int>(255 * .4)));

    QFontMetrics fontMetrics(font());
    QRect fontRect = fontMetrics.boundingRect(sTimeText);
    fontRect.moveCenter(QPoint(rect().center().x(), fontRect.height() / 2));
    painter.drawText(fontRect, sTimeText);

    QPoint pos((m_fixedSize.width() - 48) / 2, rect().height() - 5);
    int pert = static_cast<int>(qMin(m_pert * 10, 10.0));
    for (int i = 0; i < 10; i++) {
        if (i >= pert) {
            painter.fillRect(QRect(pos, QSize(3, 3)), QColor(255, 255, 255, static_cast<int>(255 * .25)));
        } else {
            painter.fillRect(QRect(pos, QSize(3, 3)), QColor(255, 255, 255, static_cast<int>(255 * .5)));
        }
        pos.rx() += 5;
    }

    QFrame::paintEvent(pPaintEvent);
}
/**
 * @brief initMember 初始化成员变量
 */
void MovieProgressIndicator::initMember()
{
    m_nElapsed = 0;
    m_pert = 0;
    m_fixedSize = QSize(0, 0);
}
/**
 * @brief updateMovieProgress 更新电影进度控件
 * @param duration 总时长
 * @param pos 当前时长
 */
void MovieProgressIndicator::updateMovieProgress(qint64 duration, qint64 pos)
{
    m_nElapsed = pos;
    if (duration != 0)
        m_pert = static_cast<qreal>(((float)pos) / duration);
    update();
}

}
