! (C) Copyright 2001- ECMWF.
! (C) Copyright 2001- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
! 


MODULE ESET_RESOL_MOD
CONTAINS
SUBROUTINE ESET_RESOL(KRESOL)
USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK

USE TPM_GEN         ,ONLY : NOUT, MSETUP0, NCUR_RESOL, NMAX_RESOL
USE TPM_DIM         ,ONLY : R, DIM_RESOL
!USE TPM_TRANS
USE TPM_DISTR       ,ONLY : D, DISTR_RESOL
USE TPM_GEOMETRY    ,ONLY : G, GEOM_RESOL
USE TPM_FIELDS      ,ONLY : F, FIELDS_RESOL
#ifdef WITH_FFT992
USE TPM_FFT         ,ONLY : T, FFT_RESOL
#endif
USE TPM_FFTW        ,ONLY : TW, FFTW_RESOL

USE ABORT_TRANS_MOD ,ONLY : ABORT_TRANS

USE TPMALD_DIM      ,ONLY : RALD, ALDDIM_RESOL
USE TPMALD_DISTR    ,ONLY : DALD, ALDDISTR_RESOL
#ifdef WITH_FFT992
USE TPMALD_FFT      ,ONLY : TALD, ALDFFT_RESOL
#endif
USE TPMALD_FIELDS   ,ONLY : FALD, ALDFIELDS_RESOL
USE TPMALD_GEO      ,ONLY : GALD, ALDGEO_RESOL
!

IMPLICIT NONE

! Declaration of arguments

INTEGER(KIND=JPIM) ,OPTIONAL, INTENT(IN) :: KRESOL

! Local varaibles
INTEGER(KIND=JPIM) :: IRESOL
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

!     ------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('ESET_RESOL_MOD:ESET_RESOL',0,ZHOOK_HANDLE)
IF(MSETUP0 == 0) CALL ABORT_TRANS('ESET_RESOL:TRANS NOT SETUP')
IRESOL = 1
IF(PRESENT(KRESOL)) THEN
  IRESOL = KRESOL
 IF(KRESOL < 1 .OR. KRESOL > NMAX_RESOL) THEN
    WRITE(NOUT,*)'ESET_RESOL: UNKNOWN RESOLUTION ',KRESOL,NMAX_RESOL
    CALL ABORT_TRANS('ESET_RESOL:KRESOL < 1 .OR. KRESOL > NMAX_RESOL')
 ENDIF
ENDIF
IF(IRESOL /= NCUR_RESOL) THEN
  NCUR_RESOL = IRESOL
  R => DIM_RESOL(NCUR_RESOL)
  F => FIELDS_RESOL(NCUR_RESOL)
  G => GEOM_RESOL(NCUR_RESOL)
  D => DISTR_RESOL(NCUR_RESOL)
#ifdef WITH_FFT992
  T => FFT_RESOL(NCUR_RESOL)
#endif
  TW => FFTW_RESOL(NCUR_RESOL)

  RALD => ALDDIM_RESOL(NCUR_RESOL)
  DALD => ALDDISTR_RESOL(NCUR_RESOL)
#ifdef WITH_FFT992
  TALD => ALDFFT_RESOL(NCUR_RESOL)
#endif
  FALD => ALDFIELDS_RESOL(NCUR_RESOL)
  GALD => ALDGEO_RESOL(NCUR_RESOL)

ENDIF
IF (LHOOK) CALL DR_HOOK('ESET_RESOL_MOD:ESET_RESOL',1,ZHOOK_HANDLE)

END SUBROUTINE ESET_RESOL
END MODULE ESET_RESOL_MOD
