/* This file is auto-generated by aarch64-generate-json-tuning-routines.py.  */
/* Copyright The GNU Toolchain Authors.
   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

/* This file contains the auto-generated parser functions for JSON tuning parameters.  */


static const enum_mapping<tune_params::aarch64_autoprefetch_model>
  autoprefetcher_model_mappings[] = {
#define AARCH64_AUTOPREFETCH_MODE(NAME, ENUM_VALUE) {NAME, tune_params::ENUM_VALUE},
#include "aarch64-tuning-enums.def"
};

static const enum_mapping<aarch64_ldp_stp_policy> ldp_policy_model_mappings[] = {
#define AARCH64_LDP_STP_POLICY(NAME, ENUM_VALUE) {NAME, ENUM_VALUE},
#include "aarch64-tuning-enums.def"
};

static const enum_mapping<aarch64_ldp_stp_policy> stp_policy_model_mappings[] = {
#define AARCH64_LDP_STP_POLICY(NAME, ENUM_VALUE) {NAME, ENUM_VALUE},
#include "aarch64-tuning-enums.def"
};


template <typename T>
static void
parse_insn_extra_cost_alu (const json::object *jo, T &alu)
{
  PARSE_INTEGER_FIELD (jo, "arith", alu.arith);
  PARSE_INTEGER_FIELD (jo, "logical", alu.logical);
  PARSE_INTEGER_FIELD (jo, "shift", alu.shift);
  PARSE_INTEGER_FIELD (jo, "shift_reg", alu.shift_reg);
  PARSE_INTEGER_FIELD (jo, "arith_shift", alu.arith_shift);
  PARSE_INTEGER_FIELD (jo, "arith_shift_reg", alu.arith_shift_reg);
  PARSE_INTEGER_FIELD (jo, "log_shift", alu.log_shift);
  PARSE_INTEGER_FIELD (jo, "log_shift_reg", alu.log_shift_reg);
  PARSE_INTEGER_FIELD (jo, "extend", alu.extend);
  PARSE_INTEGER_FIELD (jo, "extend_arith", alu.extend_arith);
  PARSE_INTEGER_FIELD (jo, "bfi", alu.bfi);
  PARSE_INTEGER_FIELD (jo, "bfx", alu.bfx);
  PARSE_INTEGER_FIELD (jo, "clz", alu.clz);
  PARSE_INTEGER_FIELD (jo, "rev", alu.rev);
  PARSE_INTEGER_FIELD (jo, "non_exec", alu.non_exec);
  PARSE_BOOLEAN_FIELD (jo, "non_exec_costs_exec", alu.non_exec_costs_exec);
}

template <typename T>
static void
parse_insn_extra_cost_mult_element (const json::object *jo, T &mult_element)
{
  PARSE_INTEGER_FIELD (jo, "simple", mult_element.simple);
  PARSE_INTEGER_FIELD (jo, "flag_setting", mult_element.flag_setting);
  PARSE_INTEGER_FIELD (jo, "extend", mult_element.extend);
  PARSE_INTEGER_FIELD (jo, "add", mult_element.add);
  PARSE_INTEGER_FIELD (jo, "extend_add", mult_element.extend_add);
  PARSE_INTEGER_FIELD (jo, "idiv", mult_element.idiv);
}

template <typename T>
static void
parse_insn_extra_cost_ldst (const json::object *jo, T &ldst)
{
  PARSE_INTEGER_FIELD (jo, "load", ldst.load);
  PARSE_INTEGER_FIELD (jo, "load_sign_extend", ldst.load_sign_extend);
  PARSE_INTEGER_FIELD (jo, "ldrd", ldst.ldrd);
  PARSE_INTEGER_FIELD (jo, "ldm_1st", ldst.ldm_1st);
  PARSE_INTEGER_FIELD (jo, "ldm_regs_per_insn_1st", ldst.ldm_regs_per_insn_1st);
  PARSE_INTEGER_FIELD (jo, "ldm_regs_per_insn_subsequent", ldst.ldm_regs_per_insn_subsequent);
  PARSE_INTEGER_FIELD (jo, "loadf", ldst.loadf);
  PARSE_INTEGER_FIELD (jo, "loadd", ldst.loadd);
  PARSE_INTEGER_FIELD (jo, "load_unaligned", ldst.load_unaligned);
  PARSE_INTEGER_FIELD (jo, "store", ldst.store);
  PARSE_INTEGER_FIELD (jo, "strd", ldst.strd);
  PARSE_INTEGER_FIELD (jo, "stm_1st", ldst.stm_1st);
  PARSE_INTEGER_FIELD (jo, "stm_regs_per_insn_1st", ldst.stm_regs_per_insn_1st);
  PARSE_INTEGER_FIELD (jo, "stm_regs_per_insn_subsequent", ldst.stm_regs_per_insn_subsequent);
  PARSE_INTEGER_FIELD (jo, "storef", ldst.storef);
  PARSE_INTEGER_FIELD (jo, "stored", ldst.stored);
  PARSE_INTEGER_FIELD (jo, "store_unaligned", ldst.store_unaligned);
  PARSE_INTEGER_FIELD (jo, "loadv", ldst.loadv);
  PARSE_INTEGER_FIELD (jo, "storev", ldst.storev);
}

template <typename T>
static void
parse_insn_extra_cost_fp_element (const json::object *jo, T &fp_element)
{
  PARSE_INTEGER_FIELD (jo, "div", fp_element.div);
  PARSE_INTEGER_FIELD (jo, "mult", fp_element.mult);
  PARSE_INTEGER_FIELD (jo, "mult_addsub", fp_element.mult_addsub);
  PARSE_INTEGER_FIELD (jo, "fma", fp_element.fma);
  PARSE_INTEGER_FIELD (jo, "addsub", fp_element.addsub);
  PARSE_INTEGER_FIELD (jo, "fpconst", fp_element.fpconst);
  PARSE_INTEGER_FIELD (jo, "neg", fp_element.neg);
  PARSE_INTEGER_FIELD (jo, "compare", fp_element.compare);
  PARSE_INTEGER_FIELD (jo, "widen", fp_element.widen);
  PARSE_INTEGER_FIELD (jo, "narrow", fp_element.narrow);
  PARSE_INTEGER_FIELD (jo, "toint", fp_element.toint);
  PARSE_INTEGER_FIELD (jo, "fromint", fp_element.fromint);
  PARSE_INTEGER_FIELD (jo, "roundint", fp_element.roundint);
}

template <typename T>
static void
parse_insn_extra_cost_vect (const json::object *jo, T &vect)
{
  PARSE_INTEGER_FIELD (jo, "alu", vect.alu);
  PARSE_INTEGER_FIELD (jo, "mult", vect.mult);
  PARSE_INTEGER_FIELD (jo, "movi", vect.movi);
  PARSE_INTEGER_FIELD (jo, "dup", vect.dup);
  PARSE_INTEGER_FIELD (jo, "extract", vect.extract);
}

template <typename T>
static void
parse_addr_cost_addr_scale_costs (const json::object *jo, T &addr_scale_costs)
{
  PARSE_INTEGER_FIELD (jo, "hi", addr_scale_costs.hi);
  PARSE_INTEGER_FIELD (jo, "si", addr_scale_costs.si);
  PARSE_INTEGER_FIELD (jo, "di", addr_scale_costs.di);
  PARSE_INTEGER_FIELD (jo, "ti", addr_scale_costs.ti);
}

template <typename T>
static void
parse_regmove_cost (const json::object *jo, T &regmove_cost)
{
  PARSE_INTEGER_FIELD (jo, "GP2GP", regmove_cost.GP2GP);
  PARSE_INTEGER_FIELD (jo, "GP2FP", regmove_cost.GP2FP);
  PARSE_INTEGER_FIELD (jo, "FP2GP", regmove_cost.FP2GP);
  PARSE_INTEGER_FIELD (jo, "FP2FP", regmove_cost.FP2FP);
}

template <typename T>
static void
parse_vec_costs_advsimd (const json::object *jo, T &advsimd)
{
  PARSE_INTEGER_FIELD (jo, "int_stmt_cost", advsimd.int_stmt_cost);
  PARSE_INTEGER_FIELD (jo, "fp_stmt_cost", advsimd.fp_stmt_cost);
  PARSE_INTEGER_FIELD (jo, "ld2_st2_permute_cost", advsimd.ld2_st2_permute_cost);
  PARSE_INTEGER_FIELD (jo, "ld3_st3_permute_cost", advsimd.ld3_st3_permute_cost);
  PARSE_INTEGER_FIELD (jo, "ld4_st4_permute_cost", advsimd.ld4_st4_permute_cost);
  PARSE_INTEGER_FIELD (jo, "permute_cost", advsimd.permute_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_i8_cost", advsimd.reduc_i8_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_i16_cost", advsimd.reduc_i16_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_i32_cost", advsimd.reduc_i32_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_i64_cost", advsimd.reduc_i64_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_f16_cost", advsimd.reduc_f16_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_f32_cost", advsimd.reduc_f32_cost);
  PARSE_INTEGER_FIELD (jo, "reduc_f64_cost", advsimd.reduc_f64_cost);
  PARSE_INTEGER_FIELD (jo, "store_elt_extra_cost", advsimd.store_elt_extra_cost);
  PARSE_INTEGER_FIELD (jo, "vec_to_scalar_cost", advsimd.vec_to_scalar_cost);
  PARSE_INTEGER_FIELD (jo, "scalar_to_vec_cost", advsimd.scalar_to_vec_cost);
  PARSE_INTEGER_FIELD (jo, "align_load_cost", advsimd.align_load_cost);
  PARSE_INTEGER_FIELD (jo, "unalign_load_cost", advsimd.unalign_load_cost);
  PARSE_INTEGER_FIELD (jo, "unalign_store_cost", advsimd.unalign_store_cost);
  PARSE_INTEGER_FIELD (jo, "store_cost", advsimd.store_cost);
}

template <typename T>
static void
parse_vec_costs_sve (const json::object *jo, T &sve)
{
  PARSE_INTEGER_FIELD (jo, "clast_cost", sve.clast_cost);
  PARSE_INTEGER_FIELD (jo, "fadda_f16_cost", sve.fadda_f16_cost);
  PARSE_INTEGER_FIELD (jo, "fadda_f32_cost", sve.fadda_f32_cost);
  PARSE_INTEGER_FIELD (jo, "fadda_f64_cost", sve.fadda_f64_cost);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "gather_load_x32_cost", sve.gather_load_x32_cost);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "gather_load_x64_cost", sve.gather_load_x64_cost);
  PARSE_INTEGER_FIELD (jo, "gather_load_x32_init_cost", sve.gather_load_x32_init_cost);
  PARSE_INTEGER_FIELD (jo, "gather_load_x64_init_cost", sve.gather_load_x64_init_cost);
  PARSE_INTEGER_FIELD (jo, "scatter_store_elt_cost", sve.scatter_store_elt_cost);
}

template <typename T>
static void
parse_vec_costs_issue_info_scalar (const json::object *jo, T &scalar)
{
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "loads_stores_per_cycle", scalar.loads_stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "stores_per_cycle", scalar.stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "general_ops_per_cycle", scalar.general_ops_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_load_general_ops", scalar.fp_simd_load_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_store_general_ops", scalar.fp_simd_store_general_ops);
}

template <typename T>
static void
parse_vec_costs_issue_info_advsimd (const json::object *jo, T &advsimd)
{
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "loads_stores_per_cycle", advsimd.loads_stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "stores_per_cycle", advsimd.stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "general_ops_per_cycle", advsimd.general_ops_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_load_general_ops", advsimd.fp_simd_load_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_store_general_ops", advsimd.fp_simd_store_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld2_st2_general_ops", advsimd.ld2_st2_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld3_st3_general_ops", advsimd.ld3_st3_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld4_st4_general_ops", advsimd.ld4_st4_general_ops);
}

template <typename T>
static void
parse_vec_costs_issue_info_sve (const json::object *jo, T &sve)
{
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "loads_stores_per_cycle", sve.loads_stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "stores_per_cycle", sve.stores_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "general_ops_per_cycle", sve.general_ops_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_load_general_ops", sve.fp_simd_load_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_simd_store_general_ops", sve.fp_simd_store_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld2_st2_general_ops", sve.ld2_st2_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld3_st3_general_ops", sve.ld3_st3_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "ld4_st4_general_ops", sve.ld4_st4_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "pred_ops_per_cycle", sve.pred_ops_per_cycle);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "while_pred_ops", sve.while_pred_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "int_cmp_pred_ops", sve.int_cmp_pred_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fp_cmp_pred_ops", sve.fp_cmp_pred_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "gather_scatter_pair_general_ops", sve.gather_scatter_pair_general_ops);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "gather_scatter_pair_pred_ops", sve.gather_scatter_pair_pred_ops);
}

template <typename T>
static void
parse_branch_costs (const json::object *jo, T &branch_costs)
{
  PARSE_INTEGER_FIELD (jo, "predictable", branch_costs.predictable);
  PARSE_INTEGER_FIELD (jo, "unpredictable", branch_costs.unpredictable);
}

template <typename T>
static void
parse_approx_modes (const json::object *jo, T &approx_modes)
{
  PARSE_INTEGER_FIELD (jo, "division", approx_modes.division);
  PARSE_INTEGER_FIELD (jo, "sqrt", approx_modes.sqrt);
  PARSE_INTEGER_FIELD (jo, "recip_sqrt", approx_modes.recip_sqrt);
}

template <typename T>
static void
parse_memmov_cost (const json::object *jo, T &memmov_cost)
{
  PARSE_INTEGER_FIELD (jo, "load_int", memmov_cost.load_int);
  PARSE_INTEGER_FIELD (jo, "store_int", memmov_cost.store_int);
  PARSE_INTEGER_FIELD (jo, "load_fp", memmov_cost.load_fp);
  PARSE_INTEGER_FIELD (jo, "store_fp", memmov_cost.store_fp);
  PARSE_INTEGER_FIELD (jo, "load_pred", memmov_cost.load_pred);
  PARSE_INTEGER_FIELD (jo, "store_pred", memmov_cost.store_pred);
}

template <typename T>
static void
parse_prefetch (const json::object *jo, T &prefetch)
{
  PARSE_INTEGER_FIELD (jo, "num_slots", prefetch.num_slots);
  PARSE_INTEGER_FIELD (jo, "l1_cache_size", prefetch.l1_cache_size);
  PARSE_INTEGER_FIELD (jo, "l1_cache_line_size", prefetch.l1_cache_line_size);
  PARSE_INTEGER_FIELD (jo, "l2_cache_size", prefetch.l2_cache_size);
  PARSE_BOOLEAN_FIELD (jo, "prefetch_dynamic_strides", prefetch.prefetch_dynamic_strides);
  PARSE_INTEGER_FIELD (jo, "minimum_stride", prefetch.minimum_stride);
  PARSE_INTEGER_FIELD (jo, "default_opt_level", prefetch.default_opt_level);
}

template <typename T>
static void
parse_insn_extra_cost (const json::object *jo, T &insn_extra_cost)
{
  PARSE_OBJECT (jo, "alu", insn_extra_cost.alu, parse_insn_extra_cost_alu);
  PARSE_ARRAY_FIELD (jo, "mult", insn_extra_cost.mult, parse_insn_extra_cost_mult_element);
  PARSE_OBJECT (jo, "ldst", insn_extra_cost.ldst, parse_insn_extra_cost_ldst);
  PARSE_ARRAY_FIELD (jo, "fp", insn_extra_cost.fp, parse_insn_extra_cost_fp_element);
  PARSE_OBJECT (jo, "vect", insn_extra_cost.vect, parse_insn_extra_cost_vect);
}

template <typename T>
static void
parse_addr_cost (const json::object *jo, T &addr_cost)
{
  PARSE_OBJECT (jo, "addr_scale_costs", addr_cost.addr_scale_costs, parse_addr_cost_addr_scale_costs);
  PARSE_INTEGER_FIELD (jo, "pre_modify", addr_cost.pre_modify);
  PARSE_INTEGER_FIELD (jo, "post_modify", addr_cost.post_modify);
  PARSE_INTEGER_FIELD (jo, "post_modify_ld3_st3", addr_cost.post_modify_ld3_st3);
  PARSE_INTEGER_FIELD (jo, "post_modify_ld4_st4", addr_cost.post_modify_ld4_st4);
  PARSE_INTEGER_FIELD (jo, "register_offset", addr_cost.register_offset);
  PARSE_INTEGER_FIELD (jo, "register_sextend", addr_cost.register_sextend);
  PARSE_INTEGER_FIELD (jo, "register_zextend", addr_cost.register_zextend);
  PARSE_INTEGER_FIELD (jo, "imm_offset", addr_cost.imm_offset);
}

template <typename T>
static void
parse_vec_costs_issue_info (const json::object *jo, T &issue_info)
{
  PARSE_OBJECT (jo, "scalar", issue_info.scalar, parse_vec_costs_issue_info_scalar);
  PARSE_OBJECT (jo, "advsimd", issue_info.advsimd, parse_vec_costs_issue_info_advsimd);
  PARSE_OBJECT (jo, "sve", issue_info.sve, parse_vec_costs_issue_info_sve);
}

template <typename T>
static void
parse_vec_costs (const json::object *jo, T &vec_costs)
{
  PARSE_INTEGER_FIELD (jo, "scalar_int_stmt_cost", vec_costs.scalar_int_stmt_cost);
  PARSE_INTEGER_FIELD (jo, "scalar_fp_stmt_cost", vec_costs.scalar_fp_stmt_cost);
  PARSE_INTEGER_FIELD (jo, "scalar_load_cost", vec_costs.scalar_load_cost);
  PARSE_INTEGER_FIELD (jo, "scalar_store_cost", vec_costs.scalar_store_cost);
  PARSE_INTEGER_FIELD (jo, "cond_taken_branch_cost", vec_costs.cond_taken_branch_cost);
  PARSE_INTEGER_FIELD (jo, "cond_not_taken_branch_cost", vec_costs.cond_not_taken_branch_cost);
  PARSE_OBJECT (jo, "advsimd", vec_costs.advsimd, parse_vec_costs_advsimd);
  PARSE_OBJECT (jo, "sve", vec_costs.sve, parse_vec_costs_sve);
  PARSE_OBJECT (jo, "issue_info", vec_costs.issue_info, parse_vec_costs_issue_info);
}

template <typename T>
static void
parse_tunings (const json::object *jo, T &tunings)
{
  PARSE_OBJECT (jo, "insn_extra_cost", tunings.insn_extra_cost, parse_insn_extra_cost);
  PARSE_OBJECT (jo, "addr_cost", tunings.addr_cost, parse_addr_cost);
  PARSE_OBJECT (jo, "regmove_cost", tunings.regmove_cost, parse_regmove_cost);
  PARSE_OBJECT (jo, "vec_costs", tunings.vec_costs, parse_vec_costs);
  PARSE_OBJECT (jo, "branch_costs", tunings.branch_costs, parse_branch_costs);
  PARSE_OBJECT (jo, "approx_modes", tunings.approx_modes, parse_approx_modes);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "sve_width", tunings.sve_width);
  PARSE_OBJECT (jo, "memmov_cost", tunings.memmov_cost, parse_memmov_cost);
  PARSE_INTEGER_FIELD (jo, "issue_rate", tunings.issue_rate);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "fusible_ops", tunings.fusible_ops);
  PARSE_STRING_FIELD (jo, "function_align", tunings.function_align);
  PARSE_STRING_FIELD (jo, "jump_align", tunings.jump_align);
  PARSE_STRING_FIELD (jo, "loop_align", tunings.loop_align);
  PARSE_INTEGER_FIELD (jo, "int_reassoc_width", tunings.int_reassoc_width);
  PARSE_INTEGER_FIELD (jo, "fp_reassoc_width", tunings.fp_reassoc_width);
  PARSE_INTEGER_FIELD (jo, "fma_reassoc_width", tunings.fma_reassoc_width);
  PARSE_INTEGER_FIELD (jo, "vec_reassoc_width", tunings.vec_reassoc_width);
  PARSE_INTEGER_FIELD (jo, "min_div_recip_mul_sf", tunings.min_div_recip_mul_sf);
  PARSE_INTEGER_FIELD (jo, "min_div_recip_mul_df", tunings.min_div_recip_mul_df);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "max_case_values", tunings.max_case_values);
  PARSE_ENUM_FIELD (jo, "autoprefetcher_model", tunings.autoprefetcher_model, autoprefetcher_model_mappings);
  PARSE_UNSIGNED_INTEGER_FIELD (jo, "extra_tuning_flags", tunings.extra_tuning_flags);
  PARSE_OBJECT (jo, "prefetch", tunings.prefetch, parse_prefetch);
  PARSE_ENUM_FIELD (jo, "ldp_policy_model", tunings.ldp_policy_model, ldp_policy_model_mappings);
  PARSE_ENUM_FIELD (jo, "stp_policy_model", tunings.stp_policy_model, stp_policy_model_mappings);
}