/* c-isr library stuff of Andes NDS32 cpu for GNU compiler
   Copyright (C) 2012-2026 Free Software Foundation, Inc.
   Contributed by Andes Technology Corporation.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   Under Section 7 of GPL version 3, you are granted additional
   permissions described in the GCC Runtime Library Exception, version
   3.1, as published by the Free Software Foundation.

   You should have received a copy of the GNU General Public License and
   a copy of the GCC Runtime Library Exception along with this program;
   see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
   <http://www.gnu.org/licenses/>.  */

#if __NDS32_ISR_VECTOR_SIZE_4__

/* If vector size is 4-byte, we have to save registers
   in the macro implementation.  */
.macro SAVE_PARTIAL
#if __NDS32_REDUCED_REGS__ || __NDS32_REDUCE_REGS
	smw.adm $r15, [$sp], $r15, #0x2
#else
	smw.adm $r15, [$sp], $r27, #0x2
#endif
	smw.adm $r0, [$sp], $r5, #0x0
  SAVE_USR_REGS
  SAVE_MAC_REGS
  SAVE_FPU_REGS
#if defined(NDS32_NESTED) || defined(NDS32_NESTED_READY)
       mfsr    $r1, $IPC       /* Get IPC.  */
       mfsr    $r2, $IPSW      /* Get IPSW.  */
       smw.adm $r1, [$sp], $r2, #0x0   /* Push IPC, IPSW.  */
#endif
	mfsr	$r0, $ITYPE	/* Get VID to $r0.  */
	srli	$r0, $r0, #5
	andi	$r0, $r0, #127
.endm

#else /* not __NDS32_ISR_VECTOR_SIZE_4__ */

/* If vector size is 16-byte, some works can be done in
   the vector section generated by compiler, so that we
   can implement less in the macro.  */

.macro SAVE_PARTIAL
  SAVE_USR_REGS
  SAVE_MAC_REGS
  SAVE_FPU_REGS
#if defined(NDS32_NESTED) || defined(NDS32_NESTED_READY)
       mfsr    $r1, $IPC       /* Get IPC.  */
       mfsr    $r2, $IPSW      /* Get IPSW.  */
       smw.adm $r1, [$sp], $r2, #0x0   /* Push IPC, IPSW.  */
#endif
.endm

#endif /* not __NDS32_ISR_VECTOR_SIZE_4__ */
