// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the Device Defender audits that have been performed during a given time
// period. Requires permission to access the ListAuditTasks (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
func (c *Client) ListAuditTasks(ctx context.Context, params *ListAuditTasksInput, optFns ...func(*Options)) (*ListAuditTasksOutput, error) {
	if params == nil {
		params = &ListAuditTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAuditTasks", params, optFns, c.addOperationListAuditTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAuditTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAuditTasksInput struct {

	// The end of the time period.
	//
	// This member is required.
	EndTime *time.Time

	// The beginning of the time period. Audit information is retained for a limited
	// time (90 days). Requesting a start time prior to what is retained results in an
	// "InvalidRequestException".
	//
	// This member is required.
	StartTime *time.Time

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int32

	// The token for the next set of results.
	NextToken *string

	// A filter to limit the output to audits with the specified completion status:
	// can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
	TaskStatus types.AuditTaskStatus

	// A filter to limit the output to the specified type of audit: can be one of
	// "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".
	TaskType types.AuditTaskType

	noSmithyDocumentSerde
}

type ListAuditTasksOutput struct {

	// A token that can be used to retrieve the next set of results, or null if there
	// are no additional results.
	NextToken *string

	// The audits that were performed during the specified time period.
	Tasks []types.AuditTaskMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAuditTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAuditTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAuditTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAuditTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAuditTasksValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAuditTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAuditTasksAPIClient is a client that implements the ListAuditTasks
// operation.
type ListAuditTasksAPIClient interface {
	ListAuditTasks(context.Context, *ListAuditTasksInput, ...func(*Options)) (*ListAuditTasksOutput, error)
}

var _ ListAuditTasksAPIClient = (*Client)(nil)

// ListAuditTasksPaginatorOptions is the paginator options for ListAuditTasks
type ListAuditTasksPaginatorOptions struct {
	// The maximum number of results to return at one time. The default is 25.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAuditTasksPaginator is a paginator for ListAuditTasks
type ListAuditTasksPaginator struct {
	options   ListAuditTasksPaginatorOptions
	client    ListAuditTasksAPIClient
	params    *ListAuditTasksInput
	nextToken *string
	firstPage bool
}

// NewListAuditTasksPaginator returns a new ListAuditTasksPaginator
func NewListAuditTasksPaginator(client ListAuditTasksAPIClient, params *ListAuditTasksInput, optFns ...func(*ListAuditTasksPaginatorOptions)) *ListAuditTasksPaginator {
	if params == nil {
		params = &ListAuditTasksInput{}
	}

	options := ListAuditTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAuditTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAuditTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAuditTasks page.
func (p *ListAuditTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAuditTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAuditTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAuditTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAuditTasks",
	}
}
