//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ScheduledActionsServer is a fake server for instances of the armcostmanagement.ScheduledActionsClient type.
type ScheduledActionsServer struct {
	// CheckNameAvailability is the fake for method ScheduledActionsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, checkNameAvailabilityRequest armcostmanagement.CheckNameAvailabilityRequest, options *armcostmanagement.ScheduledActionsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// CheckNameAvailabilityByScope is the fake for method ScheduledActionsClient.CheckNameAvailabilityByScope
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailabilityByScope func(ctx context.Context, scope string, checkNameAvailabilityRequest armcostmanagement.CheckNameAvailabilityRequest, options *armcostmanagement.ScheduledActionsClientCheckNameAvailabilityByScopeOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientCheckNameAvailabilityByScopeResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method ScheduledActionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, name string, scheduledAction armcostmanagement.ScheduledAction, options *armcostmanagement.ScheduledActionsClientCreateOrUpdateOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateByScope is the fake for method ScheduledActionsClient.CreateOrUpdateByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateByScope func(ctx context.Context, scope string, name string, scheduledAction armcostmanagement.ScheduledAction, options *armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ScheduledActionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, name string, options *armcostmanagement.ScheduledActionsClientDeleteOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteByScope is the fake for method ScheduledActionsClient.DeleteByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByScope func(ctx context.Context, scope string, name string, options *armcostmanagement.ScheduledActionsClientDeleteByScopeOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientDeleteByScopeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ScheduledActionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, name string, options *armcostmanagement.ScheduledActionsClientGetOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByScope is the fake for method ScheduledActionsClient.GetByScope
	// HTTP status codes to indicate success: http.StatusOK
	GetByScope func(ctx context.Context, scope string, name string, options *armcostmanagement.ScheduledActionsClientGetByScopeOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientGetByScopeResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ScheduledActionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcostmanagement.ScheduledActionsClientListOptions) (resp azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListResponse])

	// NewListByScopePager is the fake for method ScheduledActionsClient.NewListByScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByScopePager func(scope string, options *armcostmanagement.ScheduledActionsClientListByScopeOptions) (resp azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListByScopeResponse])

	// Run is the fake for method ScheduledActionsClient.Run
	// HTTP status codes to indicate success: http.StatusOK
	Run func(ctx context.Context, name string, options *armcostmanagement.ScheduledActionsClientRunOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientRunResponse], errResp azfake.ErrorResponder)

	// RunByScope is the fake for method ScheduledActionsClient.RunByScope
	// HTTP status codes to indicate success: http.StatusOK
	RunByScope func(ctx context.Context, scope string, name string, options *armcostmanagement.ScheduledActionsClientRunByScopeOptions) (resp azfake.Responder[armcostmanagement.ScheduledActionsClientRunByScopeResponse], errResp azfake.ErrorResponder)
}

// NewScheduledActionsServerTransport creates a new instance of ScheduledActionsServerTransport with the provided implementation.
// The returned ScheduledActionsServerTransport instance is connected to an instance of armcostmanagement.ScheduledActionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScheduledActionsServerTransport(srv *ScheduledActionsServer) *ScheduledActionsServerTransport {
	return &ScheduledActionsServerTransport{
		srv:                 srv,
		newListPager:        newTracker[azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListResponse]](),
		newListByScopePager: newTracker[azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListByScopeResponse]](),
	}
}

// ScheduledActionsServerTransport connects instances of armcostmanagement.ScheduledActionsClient to instances of ScheduledActionsServer.
// Don't use this type directly, use NewScheduledActionsServerTransport instead.
type ScheduledActionsServerTransport struct {
	srv                 *ScheduledActionsServer
	newListPager        *tracker[azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListResponse]]
	newListByScopePager *tracker[azfake.PagerResponder[armcostmanagement.ScheduledActionsClientListByScopeResponse]]
}

// Do implements the policy.Transporter interface for ScheduledActionsServerTransport.
func (s *ScheduledActionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScheduledActionsClient.CheckNameAvailability":
		resp, err = s.dispatchCheckNameAvailability(req)
	case "ScheduledActionsClient.CheckNameAvailabilityByScope":
		resp, err = s.dispatchCheckNameAvailabilityByScope(req)
	case "ScheduledActionsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "ScheduledActionsClient.CreateOrUpdateByScope":
		resp, err = s.dispatchCreateOrUpdateByScope(req)
	case "ScheduledActionsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ScheduledActionsClient.DeleteByScope":
		resp, err = s.dispatchDeleteByScope(req)
	case "ScheduledActionsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ScheduledActionsClient.GetByScope":
		resp, err = s.dispatchGetByScope(req)
	case "ScheduledActionsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "ScheduledActionsClient.NewListByScopePager":
		resp, err = s.dispatchNewListByScopePager(req)
	case "ScheduledActionsClient.Run":
		resp, err = s.dispatchRun(req)
	case "ScheduledActionsClient.RunByScope":
		resp, err = s.dispatchRunByScope(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if s.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchCheckNameAvailabilityByScope(req *http.Request) (*http.Response, error) {
	if s.srv.CheckNameAvailabilityByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailabilityByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CheckNameAvailabilityByScope(req.Context(), scopeParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.ScheduledAction](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armcostmanagement.ScheduledActionsClientCreateOrUpdateOptions
	if ifMatchParam != nil {
		options = &armcostmanagement.ScheduledActionsClientCreateOrUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), nameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScheduledAction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchCreateOrUpdateByScope(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.ScheduledAction](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeOptions
	if ifMatchParam != nil {
		options = &armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := s.srv.CreateOrUpdateByScope(req.Context(), scopeParam, nameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScheduledAction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchDeleteByScope(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteByScope(req.Context(), scopeParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScheduledAction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchGetByScope(req *http.Request) (*http.Response, error) {
	if s.srv.GetByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetByScope(req.Context(), scopeParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScheduledAction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armcostmanagement.ScheduledActionsClientListOptions
		if filterParam != nil {
			options = &armcostmanagement.ScheduledActionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListPager(options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcostmanagement.ScheduledActionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchNewListByScopePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByScopePager not implemented")}
	}
	newListByScopePager := s.newListByScopePager.get(req)
	if newListByScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/scheduledActions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armcostmanagement.ScheduledActionsClientListByScopeOptions
		if filterParam != nil {
			options = &armcostmanagement.ScheduledActionsClientListByScopeOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListByScopePager(scopeParam, options)
		newListByScopePager = &resp
		s.newListByScopePager.add(req, newListByScopePager)
		server.PagerResponderInjectNextLinks(newListByScopePager, req, func(page *armcostmanagement.ScheduledActionsClientListByScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByScopePager) {
		s.newListByScopePager.remove(req)
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchRun(req *http.Request) (*http.Response, error) {
	if s.srv.Run == nil {
		return nil, &nonRetriableError{errors.New("fake for method Run not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Run(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScheduledActionsServerTransport) dispatchRunByScope(req *http.Request) (*http.Response, error) {
	if s.srv.RunByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method RunByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/scheduledActions/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/execute`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RunByScope(req.Context(), scopeParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
