//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkcloud_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/AgentPools_ListByKubernetesCluster.json
func ExampleAgentPoolsClient_NewListByKubernetesClusterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAgentPoolsClient().NewListByKubernetesClusterPager("resourceGroupName", "kubernetesClusterName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AgentPoolList = armnetworkcloud.AgentPoolList{
		// 	Value: []*armnetworkcloud.AgentPool{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.NetworkCloud/kubernetesClusters/agentPools"),
		// 			ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/kubernetesClusters/kubernetesClusterName/agentPools/agentPoolName"),
		// 			SystemData: &armnetworkcloud.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
		// 				CreatedBy: to.Ptr("identityA"),
		// 				CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("identityB"),
		// 				LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("location"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("myvalue1"),
		// 				"key2": to.Ptr("myvalue2"),
		// 			},
		// 			ExtendedLocation: &armnetworkcloud.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
		// 				Type: to.Ptr("CustomLocation"),
		// 			},
		// 			Properties: &armnetworkcloud.AgentPoolProperties{
		// 				AdministratorConfiguration: &armnetworkcloud.AdministratorConfiguration{
		// 					AdminUsername: to.Ptr("azure"),
		// 					SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
		// 						{
		// 							KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
		// 					}},
		// 				},
		// 				AgentOptions: &armnetworkcloud.AgentOptions{
		// 					HugepagesCount: to.Ptr[int64](96),
		// 					HugepagesSize: to.Ptr(armnetworkcloud.HugepagesSizeOneG),
		// 				},
		// 				AttachedNetworkConfiguration: &armnetworkcloud.AttachedNetworkConfiguration{
		// 					L2Networks: []*armnetworkcloud.L2NetworkAttachmentConfiguration{
		// 						{
		// 							NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
		// 							PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeDPDK),
		// 					}},
		// 					L3Networks: []*armnetworkcloud.L3NetworkAttachmentConfiguration{
		// 						{
		// 							IpamEnabled: to.Ptr(armnetworkcloud.L3NetworkConfigurationIpamEnabledFalse),
		// 							NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
		// 							PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeSRIOV),
		// 					}},
		// 					TrunkedNetworks: []*armnetworkcloud.TrunkedNetworkAttachmentConfiguration{
		// 						{
		// 							NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
		// 							PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeMACVLAN),
		// 					}},
		// 				},
		// 				AvailabilityZones: []*string{
		// 					to.Ptr("1"),
		// 					to.Ptr("2"),
		// 					to.Ptr("3")},
		// 					Count: to.Ptr[int64](3),
		// 					DetailedStatus: to.Ptr(armnetworkcloud.AgentPoolDetailedStatusAvailable),
		// 					DetailedStatusMessage: to.Ptr("Agent pool is available"),
		// 					KubernetesVersion: to.Ptr("1.24.3-1"),
		// 					Labels: []*armnetworkcloud.KubernetesLabel{
		// 						{
		// 							Key: to.Ptr("kubernetes.label"),
		// 							Value: to.Ptr("true"),
		// 					}},
		// 					Mode: to.Ptr(armnetworkcloud.AgentPoolModeSystem),
		// 					ProvisioningState: to.Ptr(armnetworkcloud.AgentPoolProvisioningStateSucceeded),
		// 					Taints: []*armnetworkcloud.KubernetesLabel{
		// 						{
		// 							Key: to.Ptr("kubernetes.taint"),
		// 							Value: to.Ptr("true"),
		// 					}},
		// 					UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
		// 						MaxSurge: to.Ptr("1"),
		// 					},
		// 					VMSKUName: to.Ptr("NC_M16_v1"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/AgentPools_Get.json
func ExampleAgentPoolsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAgentPoolsClient().Get(ctx, "resourceGroupName", "kubernetesClusterName", "agentPoolName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AgentPool = armnetworkcloud.AgentPool{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/kubernetesClusters/agentPools"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/kubernetesClusters/kubernetesClusterName/agentPools/agentPoolName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.AgentPoolProperties{
	// 		AdministratorConfiguration: &armnetworkcloud.AdministratorConfiguration{
	// 			AdminUsername: to.Ptr("azure"),
	// 			SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 				{
	// 					KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 			}},
	// 		},
	// 		AgentOptions: &armnetworkcloud.AgentOptions{
	// 			HugepagesCount: to.Ptr[int64](96),
	// 			HugepagesSize: to.Ptr(armnetworkcloud.HugepagesSizeOneG),
	// 		},
	// 		AttachedNetworkConfiguration: &armnetworkcloud.AttachedNetworkConfiguration{
	// 			L2Networks: []*armnetworkcloud.L2NetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeDPDK),
	// 			}},
	// 			L3Networks: []*armnetworkcloud.L3NetworkAttachmentConfiguration{
	// 				{
	// 					IpamEnabled: to.Ptr(armnetworkcloud.L3NetworkConfigurationIpamEnabledFalse),
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeSRIOV),
	// 			}},
	// 			TrunkedNetworks: []*armnetworkcloud.TrunkedNetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeMACVLAN),
	// 			}},
	// 		},
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1"),
	// 			to.Ptr("2"),
	// 			to.Ptr("3")},
	// 			Count: to.Ptr[int64](3),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.AgentPoolDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("Agent pool is available"),
	// 			KubernetesVersion: to.Ptr("1.24.3-1"),
	// 			Labels: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.label"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			Mode: to.Ptr(armnetworkcloud.AgentPoolModeSystem),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.AgentPoolProvisioningStateSucceeded),
	// 			Taints: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.taint"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
	// 				MaxSurge: to.Ptr("1"),
	// 			},
	// 			VMSKUName: to.Ptr("NC_M16_v1"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/AgentPools_Create.json
func ExampleAgentPoolsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAgentPoolsClient().BeginCreateOrUpdate(ctx, "resourceGroupName", "kubernetesClusterName", "agentPoolName", armnetworkcloud.AgentPool{
		Location: to.Ptr("location"),
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
		ExtendedLocation: &armnetworkcloud.ExtendedLocation{
			Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
			Type: to.Ptr("CustomLocation"),
		},
		Properties: &armnetworkcloud.AgentPoolProperties{
			AdministratorConfiguration: &armnetworkcloud.AdministratorConfiguration{
				AdminUsername: to.Ptr("azure"),
				SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
					{
						KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
					}},
			},
			AgentOptions: &armnetworkcloud.AgentOptions{
				HugepagesCount: to.Ptr[int64](96),
				HugepagesSize:  to.Ptr(armnetworkcloud.HugepagesSizeOneG),
			},
			AttachedNetworkConfiguration: &armnetworkcloud.AttachedNetworkConfiguration{
				L2Networks: []*armnetworkcloud.L2NetworkAttachmentConfiguration{
					{
						NetworkID:  to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
						PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeDPDK),
					}},
				L3Networks: []*armnetworkcloud.L3NetworkAttachmentConfiguration{
					{
						IpamEnabled: to.Ptr(armnetworkcloud.L3NetworkConfigurationIpamEnabledFalse),
						NetworkID:   to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
						PluginType:  to.Ptr(armnetworkcloud.KubernetesPluginTypeSRIOV),
					}},
				TrunkedNetworks: []*armnetworkcloud.TrunkedNetworkAttachmentConfiguration{
					{
						NetworkID:  to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
						PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeMACVLAN),
					}},
			},
			AvailabilityZones: []*string{
				to.Ptr("1"),
				to.Ptr("2"),
				to.Ptr("3")},
			Count: to.Ptr[int64](3),
			Labels: []*armnetworkcloud.KubernetesLabel{
				{
					Key:   to.Ptr("kubernetes.label"),
					Value: to.Ptr("true"),
				}},
			Mode: to.Ptr(armnetworkcloud.AgentPoolModeSystem),
			Taints: []*armnetworkcloud.KubernetesLabel{
				{
					Key:   to.Ptr("kubernetes.taint"),
					Value: to.Ptr("true"),
				}},
			UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
				MaxSurge: to.Ptr("1"),
			},
			VMSKUName: to.Ptr("NC_M16_v1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AgentPool = armnetworkcloud.AgentPool{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/kubernetesClusters/agentPools"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/kubernetesClusters/kubernetesClusterName/agentPools/agentPoolName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.AgentPoolProperties{
	// 		AdministratorConfiguration: &armnetworkcloud.AdministratorConfiguration{
	// 			AdminUsername: to.Ptr("azure"),
	// 			SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 				{
	// 					KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 			}},
	// 		},
	// 		AgentOptions: &armnetworkcloud.AgentOptions{
	// 			HugepagesCount: to.Ptr[int64](96),
	// 			HugepagesSize: to.Ptr(armnetworkcloud.HugepagesSizeOneG),
	// 		},
	// 		AttachedNetworkConfiguration: &armnetworkcloud.AttachedNetworkConfiguration{
	// 			L2Networks: []*armnetworkcloud.L2NetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeDPDK),
	// 			}},
	// 			L3Networks: []*armnetworkcloud.L3NetworkAttachmentConfiguration{
	// 				{
	// 					IpamEnabled: to.Ptr(armnetworkcloud.L3NetworkConfigurationIpamEnabledFalse),
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeSRIOV),
	// 			}},
	// 			TrunkedNetworks: []*armnetworkcloud.TrunkedNetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeMACVLAN),
	// 			}},
	// 		},
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1"),
	// 			to.Ptr("2"),
	// 			to.Ptr("3")},
	// 			Count: to.Ptr[int64](3),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.AgentPoolDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("Agent pool is available"),
	// 			KubernetesVersion: to.Ptr("1.24.3-1"),
	// 			Labels: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.label"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			Mode: to.Ptr(armnetworkcloud.AgentPoolModeSystem),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.AgentPoolProvisioningStateSucceeded),
	// 			Taints: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.taint"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
	// 				MaxSurge: to.Ptr("1"),
	// 			},
	// 			VMSKUName: to.Ptr("NC_M16_v1"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/AgentPools_Delete.json
func ExampleAgentPoolsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAgentPoolsClient().BeginDelete(ctx, "resourceGroupName", "kubernetesClusterName", "agentPoolName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/AgentPools_Patch.json
func ExampleAgentPoolsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAgentPoolsClient().BeginUpdate(ctx, "resourceGroupName", "kubernetesClusterName", "agentPoolName", armnetworkcloud.AgentPoolPatchParameters{
		Properties: &armnetworkcloud.AgentPoolPatchProperties{
			Count: to.Ptr[int64](3),
			UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
				MaxSurge: to.Ptr("1"),
			},
		},
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AgentPool = armnetworkcloud.AgentPool{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/kubernetesClusters/agentPools"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/kubernetesClusters/kubernetesClusterName/agentPools/agentPoolName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.AgentPoolProperties{
	// 		AdministratorConfiguration: &armnetworkcloud.AdministratorConfiguration{
	// 			AdminUsername: to.Ptr("azure"),
	// 			SSHPublicKeys: []*armnetworkcloud.SSHPublicKey{
	// 				{
	// 					KeyData: to.Ptr("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
	// 			}},
	// 		},
	// 		AgentOptions: &armnetworkcloud.AgentOptions{
	// 			HugepagesCount: to.Ptr[int64](96),
	// 			HugepagesSize: to.Ptr(armnetworkcloud.HugepagesSizeOneG),
	// 		},
	// 		AttachedNetworkConfiguration: &armnetworkcloud.AttachedNetworkConfiguration{
	// 			L2Networks: []*armnetworkcloud.L2NetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeDPDK),
	// 			}},
	// 			L3Networks: []*armnetworkcloud.L3NetworkAttachmentConfiguration{
	// 				{
	// 					IpamEnabled: to.Ptr(armnetworkcloud.L3NetworkConfigurationIpamEnabledFalse),
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeSRIOV),
	// 			}},
	// 			TrunkedNetworks: []*armnetworkcloud.TrunkedNetworkAttachmentConfiguration{
	// 				{
	// 					NetworkID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
	// 					PluginType: to.Ptr(armnetworkcloud.KubernetesPluginTypeMACVLAN),
	// 			}},
	// 		},
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1"),
	// 			to.Ptr("2"),
	// 			to.Ptr("3")},
	// 			Count: to.Ptr[int64](3),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.AgentPoolDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("Agent pool is available"),
	// 			KubernetesVersion: to.Ptr("1.24.3-1"),
	// 			Labels: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.label"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			Mode: to.Ptr(armnetworkcloud.AgentPoolModeSystem),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.AgentPoolProvisioningStateSucceeded),
	// 			Taints: []*armnetworkcloud.KubernetesLabel{
	// 				{
	// 					Key: to.Ptr("kubernetes.taint"),
	// 					Value: to.Ptr("true"),
	// 			}},
	// 			UpgradeSettings: &armnetworkcloud.AgentPoolUpgradeSettings{
	// 				MaxSurge: to.Ptr("1"),
	// 			},
	// 			VMSKUName: to.Ptr("NC_M16_v1"),
	// 		},
	// 	}
}
