//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkcloud

import "time"

// AADConfiguration - AadConfiguration represents the Azure Active Directory Integration properties.
type AADConfiguration struct {
	// REQUIRED; The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
	AdminGroupObjectIDs []*string
}

// AdministrativeCredentials represents the admin credentials for the device requiring password-based authentication.
type AdministrativeCredentials struct {
	// REQUIRED; The password of the administrator of the device used during initialization.
	Password *string

	// REQUIRED; The username of the administrator of the device used during initialization.
	Username *string
}

// AdministratorConfiguration represents the administrative credentials that will be applied to the control plane and agent
// pool nodes in Kubernetes clusters.
type AdministratorConfiguration struct {
	// The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied,
	// a user name will be chosen by the service.
	AdminUsername *string

	// The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification
	// of public keys may be required to produce a working environment.
	SSHPublicKeys []*SSHPublicKey
}

// AgentOptions are configurations that will be applied to each agent in an agent pool.
type AgentOptions struct {
	// REQUIRED; The number of hugepages to allocate.
	HugepagesCount *int64

	// The size of the hugepages to allocate.
	HugepagesSize *HugepagesSize
}

// AgentPool represents the agent pool of Kubernetes cluster.
type AgentPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *AgentPoolProperties

	// The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AgentPoolList represents a list of Kubernetes cluster agent pools.
type AgentPoolList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of agent pools.
	Value []*AgentPool
}

// AgentPoolPatchParameters represents the body of the request to patch the Kubernetes cluster agent pool.
type AgentPoolPatchParameters struct {
	// The list of the resource properties.
	Properties *AgentPoolPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// AgentPoolPatchProperties represents the properties of an agent pool that can be modified.
type AgentPoolPatchProperties struct {
	// The number of virtual machines that use this configuration.
	Count *int64

	// The configuration of the agent pool.
	UpgradeSettings *AgentPoolUpgradeSettings
}

// AgentPoolProperties represents the properties of the Kubernetes cluster agent pool.
type AgentPoolProperties struct {
	// REQUIRED; The number of virtual machines that use this configuration.
	Count *int64

	// REQUIRED; The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the
	// features and critical services for the Kubernetes Cluster, while user pools are dedicated
	// to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
	Mode *AgentPoolMode

	// REQUIRED; The name of the VM SKU that determines the size of resources allocated for node VMs.
	VMSKUName *string

	// The administrator credentials to be used for the nodes in this agent pool.
	AdministratorConfiguration *AdministratorConfiguration

	// The configurations that will be applied to each agent in this agent pool.
	AgentOptions *AgentOptions

	// The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
	AttachedNetworkConfiguration *AttachedNetworkConfiguration

	// The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not
	// specified, all availability zones will be used.
	AvailabilityZones []*string

	// The labels applied to the nodes in this agent pool.
	Labels []*KubernetesLabel

	// The taints applied to the nodes in this agent pool.
	Taints []*KubernetesLabel

	// The configuration of the agent pool.
	UpgradeSettings *AgentPoolUpgradeSettings

	// READ-ONLY; The current status of the agent pool.
	DetailedStatus *AgentPoolDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The Kubernetes version running in this agent pool.
	KubernetesVersion *string

	// READ-ONLY; The provisioning state of the agent pool.
	ProvisioningState *AgentPoolProvisioningState
}

// AgentPoolUpgradeSettings specifies the upgrade settings for an agent pool.
type AgentPoolUpgradeSettings struct {
	// The maximum number or percentage of nodes that are surged during upgrade. This can either be set to an integer (e.g. '5')
	// or a percentage (e.g. '50%'). If a percentage is specified, it is the
	// percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If
	// not specified, the default is 1.
	MaxSurge *string
}

// AttachedNetworkConfiguration represents the set of workload networks to attach to a resource.
type AttachedNetworkConfiguration struct {
	// The list of Layer 2 Networks and related configuration for attachment.
	L2Networks []*L2NetworkAttachmentConfiguration

	// The list of Layer 3 Networks and related configuration for attachment.
	L3Networks []*L3NetworkAttachmentConfiguration

	// The list of Trunked Networks and related configuration for attachment.
	TrunkedNetworks []*TrunkedNetworkAttachmentConfiguration
}

// AvailableUpgrade represents an upgrade available for a Kubernetes cluster.
type AvailableUpgrade struct {
	// READ-ONLY; The version lifecycle indicator.
	AvailabilityLifecycle *AvailabilityLifecycle

	// READ-ONLY; The version available for upgrading.
	Version *string
}

// BareMetalMachine represents the physical machine in the rack.
type BareMetalMachine struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *BareMetalMachineProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BareMetalMachineCommandSpecification represents the command and optional arguments to exercise against the bare metal machine.
type BareMetalMachineCommandSpecification struct {
	// REQUIRED; The command to execute against the bare metal machine.
	Command *string

	// The list of string arguments that will be passed to the script in order as separate arguments.
	Arguments []*string
}

// BareMetalMachineConfigurationData represents configuration for the bare metal machine.
type BareMetalMachineConfigurationData struct {
	// REQUIRED; The credentials of the baseboard management controller on this bare metal machine.
	BmcCredentials *AdministrativeCredentials

	// REQUIRED; The MAC address of the BMC for this machine.
	BmcMacAddress *string

	// REQUIRED; The MAC address associated with the PXE NIC card.
	BootMacAddress *string

	// REQUIRED; The slot the physical machine is in the rack based on the BOM configuration.
	RackSlot *int64

	// REQUIRED; The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
	SerialNumber *string

	// The free-form additional information about the machine, e.g. an asset tag.
	MachineDetails *string

	// The user-provided name for the bare metal machine created from this specification. If not provided, the machine name will
	// be generated programmatically.
	MachineName *string

	// READ-ONLY; The connection string for the baseboard management controller including IP address and protocol.
	BmcConnectionString *string
}

// BareMetalMachineCordonParameters represents the body of the request to evacuate workloads from node on a bare metal machine.
type BareMetalMachineCordonParameters struct {
	// The indicator of whether to evacuate the node workload when the bare metal machine is cordoned.
	Evacuate *BareMetalMachineEvacuate
}

// BareMetalMachineKeySet represents the bare metal machine key set.
type BareMetalMachineKeySet struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *BareMetalMachineKeySetProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BareMetalMachineKeySetList represents a list of bare metal machine key sets.
type BareMetalMachineKeySetList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of bare metal machine key sets.
	Value []*BareMetalMachineKeySet
}

// BareMetalMachineKeySetPatchParameters represents the body of the request to patch the bare metal machine key set.
type BareMetalMachineKeySetPatchParameters struct {
	// The list of the resource properties.
	Properties *BareMetalMachineKeySetPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// BareMetalMachineKeySetPatchProperties represents the properties of bare metal machine key set that can be patched.
type BareMetalMachineKeySetPatchProperties struct {
	// The date and time after which the users in this key set will be removed from the bare metal machines.
	Expiration *time.Time

	// The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
	JumpHostsAllowed []*string

	// The unique list of permitted users.
	UserList []*KeySetUser
}

// BareMetalMachineKeySetProperties represents the properties of bare metal machine key set.
type BareMetalMachineKeySetProperties struct {
	// REQUIRED; The object ID of Azure Active Directory group that all users in the list must be in for access to be granted.
	// Users that are not in the group will not have access.
	AzureGroupID *string

	// REQUIRED; The date and time after which the users in this key set will be removed from the bare metal machines.
	Expiration *time.Time

	// REQUIRED; The list of IP addresses of jump hosts with management network access from which a login will be allowed for
	// the users.
	JumpHostsAllowed []*string

	// REQUIRED; The access level allowed for the users in this key set.
	PrivilegeLevel *BareMetalMachineKeySetPrivilegeLevel

	// REQUIRED; The unique list of permitted users.
	UserList []*KeySetUser

	// The name of the group that users will be assigned to on the operating system of the machines.
	OSGroupName *string

	// READ-ONLY; The more detailed status of the key set.
	DetailedStatus *BareMetalMachineKeySetDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The last time this key set was validated.
	LastValidation *time.Time

	// READ-ONLY; The provisioning state of the bare metal machine key set.
	ProvisioningState *BareMetalMachineKeySetProvisioningState

	// READ-ONLY; The status evaluation of each user.
	UserListStatus []*KeySetUserStatus
}

// BareMetalMachineList represents a list of bare metal machines.
type BareMetalMachineList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of bare metal machines.
	Value []*BareMetalMachine
}

// BareMetalMachinePatchParameters represents the body of the request to patch bare metal machine properties.
type BareMetalMachinePatchParameters struct {
	// The list of the resource properties.
	Properties *BareMetalMachinePatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// BareMetalMachinePatchProperties represents the properties of the bare metal machine that can be patched.
type BareMetalMachinePatchProperties struct {
	// The details provided by the customer during the creation of rack manifests that allows for custom data to be associated
	// with this machine.
	MachineDetails *string
}

// BareMetalMachinePowerOffParameters represents the body of the request to power off bare metal machine.
type BareMetalMachinePowerOffParameters struct {
	// The indicator of whether to skip the graceful OS shutdown and power off the bare metal machine immediately.
	SkipShutdown *BareMetalMachineSkipShutdown
}

// BareMetalMachineProperties represents the properties of a bare metal machine.
type BareMetalMachineProperties struct {
	// REQUIRED; The connection string for the baseboard management controller including IP address and protocol.
	BmcConnectionString *string

	// REQUIRED; The credentials of the baseboard management controller on this bare metal machine.
	BmcCredentials *AdministrativeCredentials

	// REQUIRED; The MAC address of the BMC device.
	BmcMacAddress *string

	// REQUIRED; The MAC address of a NIC connected to the PXE network.
	BootMacAddress *string

	// REQUIRED; The custom details provided by the customer.
	MachineDetails *string

	// REQUIRED; The OS-level hostname assigned to this machine.
	MachineName *string

	// REQUIRED; The unique internal identifier of the bare metal machine SKU.
	MachineSKUID *string

	// REQUIRED; The resource ID of the rack where this bare metal machine resides.
	RackID *string

	// REQUIRED; The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is
	// 1.
	RackSlot *int64

	// REQUIRED; The serial number of the bare metal machine.
	SerialNumber *string

	// READ-ONLY; The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
	AssociatedResourceIDs []*string

	// READ-ONLY; The resource ID of the cluster this bare metal machine is associated with.
	ClusterID *string

	// READ-ONLY; The cordon status of the bare metal machine.
	CordonStatus *BareMetalMachineCordonStatus

	// READ-ONLY; The more detailed status of the bare metal machine.
	DetailedStatus *BareMetalMachineDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The hardware inventory, including information acquired from the model/sku information and from the ironic inspector.
	HardwareInventory *HardwareInventory

	// READ-ONLY; The details of the latest hardware validation performed for this bare metal machine.
	HardwareValidationStatus *HardwareValidationStatus

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the HybridAksClusters
	// that have nodes hosted on this bare metal machine.
	HybridAksClustersAssociatedIDs []*string

	// READ-ONLY; The name of this machine represented by the host object in the Cluster's Kubernetes control plane.
	KubernetesNodeName *string

	// READ-ONLY; The version of Kubernetes running on this machine.
	KubernetesVersion *string

	// READ-ONLY; The image that is currently provisioned to the OS disk.
	OSImage *string

	// READ-ONLY; The IPv4 address that is assigned to the bare metal machine during the cluster deployment.
	OamIPv4Address *string

	// READ-ONLY; The IPv6 address that is assigned to the bare metal machine during the cluster deployment.
	OamIPv6Address *string

	// READ-ONLY; The power state derived from the baseboard management controller.
	PowerState *BareMetalMachinePowerState

	// READ-ONLY; The provisioning state of the bare metal machine.
	ProvisioningState *BareMetalMachineProvisioningState

	// READ-ONLY; The indicator of whether the bare metal machine is ready to receive workloads.
	ReadyState *BareMetalMachineReadyState

	// READ-ONLY; The discovered value of the machine's service tag.
	ServiceTag *string

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the VirtualMachines that
	// are hosted on this bare metal machine.
	VirtualMachinesAssociatedIDs []*string
}

// BareMetalMachineReplaceParameters represents the body of the request to physically swap a bare metal machine for another.
type BareMetalMachineReplaceParameters struct {
	// The credentials of the baseboard management controller on this bare metal machine.
	BmcCredentials *AdministrativeCredentials

	// The MAC address of the BMC device.
	BmcMacAddress *string

	// The MAC address of a NIC connected to the PXE network.
	BootMacAddress *string

	// The OS-level hostname assigned to this machine.
	MachineName *string

	// The serial number of the bare metal machine.
	SerialNumber *string
}

// BareMetalMachineRunCommandParameters represents the body of the request to execute a script on the bare metal machine.
type BareMetalMachineRunCommandParameters struct {
	// REQUIRED; The maximum time the script is allowed to run. If the execution time exceeds the maximum, the script will be
	// stopped, any output produced until then will be captured, and the exit code matching a
	// timeout will be returned (252).
	LimitTimeSeconds *int64

	// REQUIRED; The base64 encoded script to execute on the bare metal machine.
	Script *string

	// The list of string arguments that will be passed to the script in order as separate arguments.
	Arguments []*string
}

// BareMetalMachineRunDataExtractsParameters represents the body of request containing list of curated data extraction commands
// to run on the bare metal machine.
type BareMetalMachineRunDataExtractsParameters struct {
	// REQUIRED; The list of curated data extraction commands to be executed directly against the target machine.
	Commands []*BareMetalMachineCommandSpecification

	// REQUIRED; The maximum time the commands are allowed to run. If the execution time exceeds the maximum, the script will
	// be stopped, any output produced until then will be captured, and the exit code matching a
	// timeout will be returned (252).
	LimitTimeSeconds *int64
}

// BareMetalMachineRunReadCommandsParameters represents the body of request containing list of read-only commands to run on
// the bare metal machine.
type BareMetalMachineRunReadCommandsParameters struct {
	// REQUIRED; The list of read-only commands to be executed directly against the target machine.
	Commands []*BareMetalMachineCommandSpecification

	// REQUIRED; The maximum time the commands are allowed to run. If the execution time exceeds the maximum, the script will
	// be stopped, any output produced until then will be captured, and the exit code matching a
	// timeout will be returned (252).
	LimitTimeSeconds *int64
}

// BgpAdvertisement represents the association of IP address pools to the communities and peers.
type BgpAdvertisement struct {
	// REQUIRED; The names of the IP address pools associated with this announcement.
	IPAddressPools []*string

	// The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This
	// field is ignored if fabricPeeringEnabled is set to False.
	AdvertiseToFabric *AdvertiseToFabric

	// The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234
	// format.
	Communities []*string

	// The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this
	// advertisement.
	Peers []*string
}

// BgpServiceLoadBalancerConfiguration represents the configuration of a BGP service load balancer.
type BgpServiceLoadBalancerConfiguration struct {
	// The association of IP address pools to the communities and peers, allowing for announcement of IPs.
	BgpAdvertisements []*BgpAdvertisement

	// The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
	BgpPeers []*ServiceLoadBalancerBgpPeer

	// The indicator to specify if the load balancer peers with the network fabric.
	FabricPeeringEnabled *FabricPeeringEnabled

	// The list of pools of IP addresses that can be allocated to Load Balancer services.
	IPAddressPools []*IPAddressPool
}

// BmcKeySet represents the baseboard management controller key set.
type BmcKeySet struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *BmcKeySetProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BmcKeySetList represents a list of baseboard management controller key sets.
type BmcKeySetList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of baseboard management controller key sets.
	Value []*BmcKeySet
}

// BmcKeySetPatchParameters represents the body of the request to patch the baseboard management controller key set.
type BmcKeySetPatchParameters struct {
	// The list of the resource properties.
	Properties *BmcKeySetPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// BmcKeySetPatchProperties represents the properties of baseboard management controller key set that are patchable.
type BmcKeySetPatchProperties struct {
	// The date and time after which the users in this key set will be removed from the baseboard management controllers.
	Expiration *time.Time

	// The unique list of permitted users.
	UserList []*KeySetUser
}

// BmcKeySetProperties represents the properties of baseboard management controller key set.
type BmcKeySetProperties struct {
	// REQUIRED; The object ID of Azure Active Directory group that all users in the list must be in for access to be granted.
	// Users that are not in the group will not have access.
	AzureGroupID *string

	// REQUIRED; The date and time after which the users in this key set will be removed from the baseboard management controllers.
	Expiration *time.Time

	// REQUIRED; The access level allowed for the users in this key set.
	PrivilegeLevel *BmcKeySetPrivilegeLevel

	// REQUIRED; The unique list of permitted users.
	UserList []*KeySetUser

	// READ-ONLY; The more detailed status of the key set.
	DetailedStatus *BmcKeySetDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The last time this key set was validated.
	LastValidation *time.Time

	// READ-ONLY; The provisioning state of the baseboard management controller key set.
	ProvisioningState *BmcKeySetProvisioningState

	// READ-ONLY; The status evaluation of each user.
	UserListStatus []*KeySetUserStatus
}

// CloudServicesNetwork - Upon creation, the additional services that are provided by the platform will be allocated and represented
// in the status of this resource. All resources associated with this cloud services network
// will be part of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused
// across many virtual machines and/or Hybrid AKS clusters.
type CloudServicesNetwork struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The list of the resource properties.
	Properties *CloudServicesNetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CloudServicesNetworkList represents a list of cloud services networks.
type CloudServicesNetworkList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of cloud services networks.
	Value []*CloudServicesNetwork
}

// CloudServicesNetworkPatchParameters represents the body of the request to patch the cloud services network.
type CloudServicesNetworkPatchParameters struct {
	// The list of the resource properties.
	Properties *CloudServicesNetworkPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// CloudServicesNetworkPatchProperties represents the properties of the cloud services network that can be updated using a
// patch request.
type CloudServicesNetworkPatchProperties struct {
	// The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
	AdditionalEgressEndpoints []*EgressEndpoint

	// The indicator of whether the platform default endpoints are allowed for the egress traffic.
	EnableDefaultEgressEndpoints *CloudServicesNetworkEnableDefaultEgressEndpoints
}

// CloudServicesNetworkProperties represents properties of the cloud services network.
type CloudServicesNetworkProperties struct {
	// The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
	AdditionalEgressEndpoints []*EgressEndpoint

	// The indicator of whether the platform default endpoints are allowed for the egress traffic.
	EnableDefaultEgressEndpoints *CloudServicesNetworkEnableDefaultEgressEndpoints

	// READ-ONLY; The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
	AssociatedResourceIDs []*string

	// READ-ONLY; The resource ID of the Network Cloud cluster this cloud services network is associated with.
	ClusterID *string

	// READ-ONLY; The more detailed status of the cloud services network.
	DetailedStatus *CloudServicesNetworkDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The full list of additional and default egress endpoints that are currently enabled.
	EnabledEgressEndpoints []*EgressEndpoint

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated
	// with this cloud services network.
	HybridAksClustersAssociatedIDs []*string

	// READ-ONLY; The name of the interface that will be present in the virtual machine to represent this network.
	InterfaceName *string

	// READ-ONLY; The provisioning state of the cloud services network.
	ProvisioningState *CloudServicesNetworkProvisioningState

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any
	// Hybrid AKS virtual machines, that are currently using this cloud services network.
	VirtualMachinesAssociatedIDs []*string
}

// Cluster represents the on-premises Network Cloud cluster.
type Cluster struct {
	// REQUIRED; The extended location of the cluster manager associated with the cluster.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *ClusterProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterAvailableUpgradeVersion represents the various cluster upgrade parameters.
type ClusterAvailableUpgradeVersion struct {
	// READ-ONLY; The indicator of whether the control plane will be impacted during the upgrade.
	ControlImpact *ControlImpact

	// READ-ONLY; The expected duration needed for this upgrade.
	ExpectedDuration *string

	// READ-ONLY; The impact description including the specific details and release notes.
	ImpactDescription *string

	// READ-ONLY; The last date the version of the platform is supported.
	SupportExpiryDate *string

	// READ-ONLY; The target version this cluster will be upgraded to.
	TargetClusterVersion *string

	// READ-ONLY; The indicator of whether the workload will be impacted during the upgrade.
	WorkloadImpact *WorkloadImpact
}

// ClusterAvailableVersion represents the cluster version that the cluster manager can be asked to create and manage.
type ClusterAvailableVersion struct {
	// READ-ONLY; The last date the version of the platform is supported.
	SupportExpiryDate *string

	// READ-ONLY; The version of the cluster to be deployed.
	TargetClusterVersion *string
}

// ClusterCapacity represents various details regarding compute capacity.
type ClusterCapacity struct {
	// The remaining appliance-based storage in GB available for workload use.
	AvailableApplianceStorageGB *int64

	// The remaining number of cores that are available in this cluster for workload use.
	AvailableCoreCount *int64

	// The remaining machine or host-based storage in GB available for workload use.
	AvailableHostStorageGB *int64

	// The remaining memory in GB that are available in this cluster for workload use.
	AvailableMemoryGB *int64

	// The total appliance-based storage in GB supported by this cluster for workload use.
	TotalApplianceStorageGB *int64

	// The total number of cores that are supported by this cluster for workload use.
	TotalCoreCount *int64

	// The total machine or host-based storage in GB supported by this cluster for workload use.
	TotalHostStorageGB *int64

	// The total memory supported by this cluster for workload use.
	TotalMemoryGB *int64
}

// ClusterDeployParameters represents the body of the request to deploy cluster.
type ClusterDeployParameters struct {
	// The names of bare metal machines in the cluster that should be skipped during environment validation.
	SkipValidationsForMachines []*string
}

// ClusterList represents a list of clusters.
type ClusterList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of clusters.
	Value []*Cluster
}

// ClusterManager represents a control-plane to manage one or more on-premises clusters.
type ClusterManager struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *ClusterManagerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterManagerList represents a list of cluster manager objects.
type ClusterManagerList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of cluster managers.
	Value []*ClusterManager
}

// ClusterManagerPatchParameters represents the body of the request to patch the cluster properties.
type ClusterManagerPatchParameters struct {
	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// ClusterManagerProperties represents the properties of a cluster manager.
type ClusterManagerProperties struct {
	// REQUIRED; The resource ID of the fabric controller that has one to one mapping with the cluster manager.
	FabricControllerID *string

	// The resource ID of the Log Analytics workspace that is used for the logs collection.
	AnalyticsWorkspaceID *string

	// Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future
	// version. The Azure availability zones within the region that will be used
	// to support the cluster manager resource.
	AvailabilityZones []*string

	// The configuration of the managed resource group associated with the resource.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future
	// version. The size of the Azure virtual machines to use for hosting the
	// cluster manager resource.
	VMSize *string

	// READ-ONLY; The list of the cluster versions the manager supports. It is used as input in clusterVersion property of a cluster
	// resource.
	ClusterVersions []*ClusterAvailableVersion

	// READ-ONLY; The detailed status that provides additional information about the cluster manager.
	DetailedStatus *ClusterManagerDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The extended location (custom location) that represents the cluster manager's control plane location. This extended
	// location is used when creating cluster and rack manifest resources.
	ManagerExtendedLocation *ExtendedLocation

	// READ-ONLY; The provisioning state of the cluster manager.
	ProvisioningState *ClusterManagerProvisioningState
}

// ClusterMetricsConfiguration represents the metrics configuration of an on-premises Network Cloud cluster.
type ClusterMetricsConfiguration struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *ClusterMetricsConfigurationProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterMetricsConfigurationList represents a list of metrics configuration of the cluster.
type ClusterMetricsConfigurationList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of metrics configurations.
	Value []*ClusterMetricsConfiguration
}

// ClusterMetricsConfigurationPatchParameters represents the body of the request to patch the metrics configuration of cluster.
type ClusterMetricsConfigurationPatchParameters struct {
	// The list of the resource properties.
	Properties *ClusterMetricsConfigurationPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// ClusterMetricsConfigurationPatchProperties represents the properties of metrics configuration for the cluster for patching.
type ClusterMetricsConfigurationPatchProperties struct {
	// The interval in minutes by which metrics will be collected.
	CollectionInterval *int64

	// The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
	EnabledMetrics []*string
}

// ClusterMetricsConfigurationProperties represents the properties of metrics configuration for the cluster.
type ClusterMetricsConfigurationProperties struct {
	// REQUIRED; The interval in minutes by which metrics will be collected.
	CollectionInterval *int64

	// The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
	EnabledMetrics []*string

	// READ-ONLY; The more detailed status of the metrics configuration.
	DetailedStatus *ClusterMetricsConfigurationDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The list of metrics that are available for the cluster but disabled at the moment.
	DisabledMetrics []*string

	// READ-ONLY; The provisioning state of the metrics configuration.
	ProvisioningState *ClusterMetricsConfigurationProvisioningState
}

// ClusterPatchParameters represents the body of the request to patch the cluster properties.
type ClusterPatchParameters struct {
	// The list of the resource properties.
	Properties *ClusterPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// ClusterPatchProperties represents the properties of the cluster for patching.
type ClusterPatchProperties struct {
	// The rack definition that is intended to reflect only a single rack in a single rack cluster, or an aggregator rack in a
	// multi-rack cluster.
	AggregatorOrSingleRackDefinition *RackDefinition

	// The customer-provided location information to identify where the cluster resides.
	ClusterLocation *string

	// The service principal to be used by the cluster during Arc Appliance installation.
	ClusterServicePrincipal *ServicePrincipalInformation

	// The validation threshold indicating the allowable failures of compute machines during environment validation and deployment.
	ComputeDeploymentThreshold *ValidationThreshold

	// The list of rack definitions for the compute racks in a multi-rack cluster, or an empty list in a single-rack cluster.
	ComputeRackDefinitions []*RackDefinition
}

// ClusterProperties represents the properties of a cluster.
type ClusterProperties struct {
	// REQUIRED; The rack definition that is intended to reflect only a single rack in a single rack cluster, or an aggregator
	// rack in a multi-rack cluster.
	AggregatorOrSingleRackDefinition *RackDefinition

	// REQUIRED; The type of rack configuration for the cluster.
	ClusterType *ClusterType

	// REQUIRED; The current runtime version of the cluster.
	ClusterVersion *string

	// REQUIRED; The resource ID of the Network Fabric associated with the cluster.
	NetworkFabricID *string

	// The resource ID of the Log Analytics Workspace that will be used for storing relevant logs.
	AnalyticsWorkspaceID *string

	// The customer-provided location information to identify where the cluster resides.
	ClusterLocation *string

	// The service principal to be used by the cluster during Arc Appliance installation.
	ClusterServicePrincipal *ServicePrincipalInformation

	// The validation threshold indicating the allowable failures of compute machines during environment validation and deployment.
	ComputeDeploymentThreshold *ValidationThreshold

	// The list of rack definitions for the compute racks in a multi-rack cluster, or an empty list in a single-rack cluster.
	ComputeRackDefinitions []*RackDefinition

	// The configuration of the managed resource group associated with the resource.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// READ-ONLY; The list of cluster runtime version upgrades available for this cluster.
	AvailableUpgradeVersions []*ClusterAvailableUpgradeVersion

	// READ-ONLY; The capacity supported by this cluster.
	ClusterCapacity *ClusterCapacity

	// READ-ONLY; The latest heartbeat status between the cluster manager and the cluster.
	ClusterConnectionStatus *ClusterConnectionStatus

	// READ-ONLY; The extended location (custom location) that represents the cluster's control plane location. This extended
	// location is used to route the requests of child objects of the cluster that are handled by
	// the platform operator.
	ClusterExtendedLocation *ExtendedLocation

	// READ-ONLY; The latest connectivity status between cluster manager and the cluster.
	ClusterManagerConnectionStatus *ClusterManagerConnectionStatus

	// READ-ONLY; The resource ID of the cluster manager that manages this cluster. This is set by the Cluster Manager when the
	// cluster is created.
	ClusterManagerID *string

	// READ-ONLY; The current detailed status of the cluster.
	DetailedStatus *ClusterDetailedStatus

	// READ-ONLY; The descriptive message about the detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; Field Deprecated. This field will not be populated in an upcoming version. The extended location (custom location)
	// that represents the Hybrid AKS control plane location. This extended location is used
	// when creating provisioned clusters (Hybrid AKS clusters).
	HybridAksExtendedLocation *ExtendedLocation

	// READ-ONLY; The count of Manual Action Taken (MAT) events that have not been validated.
	ManualActionCount *int64

	// READ-ONLY; The provisioning state of the cluster.
	ProvisioningState *ClusterProvisioningState

	// READ-ONLY; The support end date of the runtime version of the cluster.
	SupportExpiryDate *string

	// READ-ONLY; The list of workload resource IDs that are hosted within this cluster.
	WorkloadResourceIDs []*string
}

// ClusterUpdateVersionParameters represents the body of the request to update cluster version.
type ClusterUpdateVersionParameters struct {
	// REQUIRED; The version to be applied to the cluster during update.
	TargetClusterVersion *string
}

// Console represents the console of an on-premises Network Cloud virtual machine.
type Console struct {
	// REQUIRED; The extended location of the cluster manager associated with the cluster this virtual machine is created on.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *ConsoleProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConsoleList represents a list of virtual machine consoles.
type ConsoleList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of virtual machine consoles.
	Value []*Console
}

// ConsolePatchParameters represents the body of the request to patch the virtual machine console.
type ConsolePatchParameters struct {
	// The list of the resource properties.
	Properties *ConsolePatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// ConsolePatchProperties represents the properties of the virtual machine console that can be patched.
type ConsolePatchProperties struct {
	// The credentials used to login to the image repository that has access to the specified image.
	Enabled *ConsoleEnabled

	// The date and time after which the key will be disallowed access.
	Expiration *time.Time

	// The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private
	// key for logging in.
	SSHPublicKey *SSHPublicKey
}

// ConsoleProperties represents the properties of the virtual machine console.
type ConsoleProperties struct {
	// REQUIRED; The indicator of whether the console access is enabled.
	Enabled *ConsoleEnabled

	// REQUIRED; The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH
	// private key for logging in.
	SSHPublicKey *SSHPublicKey

	// The date and time after which the key will be disallowed access.
	Expiration *time.Time

	// READ-ONLY; The more detailed status of the console.
	DetailedStatus *ConsoleDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The resource ID of the private link service that is used to provide virtual machine console access.
	PrivateLinkServiceID *string

	// READ-ONLY; The provisioning state of the virtual machine console.
	ProvisioningState *ConsoleProvisioningState

	// READ-ONLY; The unique identifier for the virtual machine that is used to access the console.
	VirtualMachineAccessID *string
}

// ControlPlaneNodeConfiguration represents the selection of virtual machines and size of the control plane for a Kubernetes
// cluster.
type ControlPlaneNodeConfiguration struct {
	// REQUIRED; The number of virtual machines that use this configuration.
	Count *int64

	// REQUIRED; The name of the VM SKU supplied during creation.
	VMSKUName *string

	// The administrator credentials to be used for the nodes in the control plane.
	AdministratorConfiguration *AdministratorConfiguration

	// The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane.
	// If not specified, all availability zones will be used.
	AvailabilityZones []*string
}

// ControlPlaneNodePatchConfiguration represents the properties of the control plane that can be patched for this Kubernetes
// cluster.
type ControlPlaneNodePatchConfiguration struct {
	// The number of virtual machines that use this configuration.
	Count *int64
}

// EgressEndpoint represents the connection from a cloud services network to the specified endpoint for a common purpose.
type EgressEndpoint struct {
	// REQUIRED; The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management,
	// API server, etc. The platform egress endpoints provided by default will use the
	// category 'default'.
	Category *string

	// REQUIRED; The list of endpoint dependencies.
	Endpoints []*EndpointDependency
}

// EndpointDependency represents the definition of an endpoint, including the domain and details.
type EndpointDependency struct {
	// REQUIRED; The domain name of the dependency.
	DomainName *string

	// The port of this endpoint.
	Port *int64
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExtendedLocation represents the Azure custom location where the resource will be created.
type ExtendedLocation struct {
	// REQUIRED; The resource ID of the extended location on which the resource will be created.
	Name *string

	// REQUIRED; The extended location type, for example, CustomLocation.
	Type *string
}

// FeatureStatus contains information regarding a Kubernetes cluster feature.
type FeatureStatus struct {
	// READ-ONLY; The status representing the state of this feature.
	DetailedStatus *FeatureDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The name of the feature.
	Name *string

	// READ-ONLY; The version of the feature.
	Version *string
}

// HardwareInventory represents the hardware configuration of this machine as exposed to the customer, including information
// acquired from the model/sku information and from the ironic inspector.
type HardwareInventory struct {
	// READ-ONLY; Freeform data extracted from the environment about this machine. This information varies depending on the specific
	// hardware and configuration.
	AdditionalHostInformation *string

	// READ-ONLY; The list of network interfaces and associated details for the bare metal machine.
	Interfaces []*HardwareInventoryNetworkInterface

	// READ-ONLY; Field Deprecated. Will be removed in an upcoming version. The list of network interface cards and associated
	// details for the bare metal machine.
	Nics []*Nic
}

// HardwareInventoryNetworkInterface represents the network interface details as part of a hardware inventory.
type HardwareInventoryNetworkInterface struct {
	// READ-ONLY; The current status of the link.
	LinkStatus *string

	// READ-ONLY; The MAC address associated with this interface.
	MacAddress *string

	// READ-ONLY; The name of the interface.
	Name *string

	// READ-ONLY; The resource ID of the network interface for the port on the switch that this machine's interface is connected
	// to.
	NetworkInterfaceID *string
}

// HardwareValidationStatus represents the latest hardware validation details performed for this bare metal machine.
type HardwareValidationStatus struct {
	// READ-ONLY; The timestamp of the hardware validation execution.
	LastValidationTime *time.Time

	// READ-ONLY; The outcome of the hardware validation.
	Result *BareMetalMachineHardwareValidationResult
}

// IPAddressPool - IpAddressPool represents a pool of IP addresses that can be allocated to a service.
type IPAddressPool struct {
	// REQUIRED; The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range
	// of IP addresses.
	Addresses []*string

	// REQUIRED; The name used to identify this IP address pool for association with a BGP advertisement.
	Name *string

	// The indicator to determine if automatic allocation from the pool should occur.
	AutoAssign *BfdEnabled

	// The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only
	// use IP addresses between .1 and .254 inclusive.
	OnlyUseHostIPs *BfdEnabled
}

// ImageRepositoryCredentials represents the credentials used to login to the image repository.
type ImageRepositoryCredentials struct {
	// REQUIRED; The password or token used to access an image in the target repository.
	Password *string

	// REQUIRED; The URL of the authentication server used to validate the repository credentials.
	RegistryURL *string

	// REQUIRED; The username used to access an image in the target repository.
	Username *string
}

// InitialAgentPoolConfiguration specifies the configuration of a pool of virtual machines that are initially defined with
// a Kubernetes cluster.
type InitialAgentPoolConfiguration struct {
	// REQUIRED; The number of virtual machines that use this configuration.
	Count *int64

	// REQUIRED; The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the
	// features and critical services for the Kubernetes Cluster, while user pools are dedicated
	// to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
	Mode *AgentPoolMode

	// REQUIRED; The name that will be used for the agent pool resource representing this agent pool.
	Name *string

	// REQUIRED; The name of the VM SKU that determines the size of resources allocated for node VMs.
	VMSKUName *string

	// The administrator credentials to be used for the nodes in this agent pool.
	AdministratorConfiguration *AdministratorConfiguration

	// The configurations that will be applied to each agent in this agent pool.
	AgentOptions *AgentOptions

	// The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
	AttachedNetworkConfiguration *AttachedNetworkConfiguration

	// The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not
	// specified, all availability zones will be used.
	AvailabilityZones []*string

	// The labels applied to the nodes in this agent pool.
	Labels []*KubernetesLabel

	// The taints applied to the nodes in this agent pool.
	Taints []*KubernetesLabel

	// The configuration of the agent pool.
	UpgradeSettings *AgentPoolUpgradeSettings
}

// KeySetUser represents the properties of the user in the key set.
type KeySetUser struct {
	// REQUIRED; The user name that will be used for access.
	AzureUserName *string

	// REQUIRED; The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH
	// private key for logging in.
	SSHPublicKey *SSHPublicKey

	// The free-form description for this user.
	Description *string
}

// KeySetUserStatus represents the status of the key set user.
type KeySetUserStatus struct {
	// READ-ONLY; The user name that will be used for access.
	AzureUserName *string

	// READ-ONLY; The indicator of whether the user is currently deployed for access.
	Status *BareMetalMachineKeySetUserSetupStatus

	// READ-ONLY; The additional information describing the current status of this user, if any available.
	StatusMessage *string
}

// KubernetesCluster represents the Kubernetes cluster hosted on Network Cloud.
type KubernetesCluster struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *KubernetesClusterProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// KubernetesClusterList represents a list of Kubernetes clusters.
type KubernetesClusterList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of additional details related to Kubernetes clusters.
	Value []*KubernetesCluster
}

// KubernetesClusterNode represents the details of a node in a Kubernetes cluster.
type KubernetesClusterNode struct {
	// READ-ONLY; The resource ID of the agent pool that this node belongs to. This value is not represented on control plane
	// nodes.
	AgentPoolID *string

	// READ-ONLY; The availability zone this node is running within.
	AvailabilityZone *string

	// READ-ONLY; The resource ID of the bare metal machine that hosts this node.
	BareMetalMachineID *string

	// READ-ONLY; The number of CPU cores configured for this node, derived from the VM SKU specified.
	CPUCores *int64

	// READ-ONLY; The detailed state of this node.
	DetailedStatus *KubernetesClusterNodeDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The size of the disk configured for this node.
	DiskSizeGB *int64

	// READ-ONLY; The machine image used to deploy this node.
	Image *string

	// READ-ONLY; The currently running version of Kubernetes and bundled features running on this node.
	KubernetesVersion *string

	// READ-ONLY; The list of labels on this node that have been assigned to the agent pool containing this node.
	Labels []*KubernetesLabel

	// READ-ONLY; The amount of memory configured for this node, derived from the vm SKU specified.
	MemorySizeGB *int64

	// READ-ONLY; The mode of the agent pool containing this node. Not applicable for control plane nodes.
	Mode *AgentPoolMode

	// READ-ONLY; The name of this node, as realized in the Kubernetes cluster.
	Name *string

	// READ-ONLY; The NetworkAttachments made to this node.
	NetworkAttachments []*NetworkAttachment

	// READ-ONLY; The power state of this node.
	PowerState *KubernetesNodePowerState

	// READ-ONLY; The role of this node in the cluster.
	Role *KubernetesNodeRole

	// READ-ONLY; The list of taints that have been assigned to the agent pool containing this node.
	Taints []*KubernetesLabel

	// READ-ONLY; The VM SKU name that was used to create this cluster node.
	VMSKUName *string
}

// KubernetesClusterPatchParameters represents the body of the request to patch the Hybrid AKS cluster.
type KubernetesClusterPatchParameters struct {
	// The list of the resource properties.
	Properties *KubernetesClusterPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// KubernetesClusterPatchProperties represents the properties of the Kubernetes cluster that can be patched.
type KubernetesClusterPatchProperties struct {
	// The defining characteristics of the control plane that can be patched for this Kubernetes cluster.
	ControlPlaneNodeConfiguration *ControlPlaneNodePatchConfiguration

	// The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved
	// into this field after creation or update.
	KubernetesVersion *string
}

// KubernetesClusterProperties represents the properties of Kubernetes cluster resource.
type KubernetesClusterProperties struct {
	// REQUIRED; The defining characteristics of the control plane for this Kubernetes Cluster.
	ControlPlaneNodeConfiguration *ControlPlaneNodeConfiguration

	// REQUIRED; The agent pools that are created with this Kubernetes cluster for running critical system services and workloads.
	// This data in this field is only used during creation, and the field will be empty
	// following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools
	// sub-resource.
	InitialAgentPoolConfigurations []*InitialAgentPoolConfiguration

	// REQUIRED; The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used
	// will be resolved into this field after creation or update.
	KubernetesVersion *string

	// REQUIRED; The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
	NetworkConfiguration *NetworkConfiguration

	// The Azure Active Directory Integration properties.
	AADConfiguration *AADConfiguration

	// The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their
	// own values.
	AdministratorConfiguration *AdministratorConfiguration

	// The configuration of the managed resource group associated with the resource.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// READ-ONLY; The full list of network resource IDs that are attached to this cluster, including those attached only to specific
	// agent pools.
	AttachedNetworkIDs []*string

	// READ-ONLY; The list of versions that this Kubernetes cluster can be upgraded to.
	AvailableUpgrades []*AvailableUpgrade

	// READ-ONLY; The resource ID of the Network Cloud cluster.
	ClusterID *string

	// READ-ONLY; The resource ID of the connected cluster set up when this Kubernetes cluster is created.
	ConnectedClusterID *string

	// READ-ONLY; The current running version of Kubernetes on the control plane.
	ControlPlaneKubernetesVersion *string

	// READ-ONLY; The current status of the Kubernetes cluster.
	DetailedStatus *KubernetesClusterDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The current feature settings.
	FeatureStatuses []*FeatureStatus

	// READ-ONLY; The details of the nodes in this cluster.
	Nodes []*KubernetesClusterNode

	// READ-ONLY; The provisioning state of the Kubernetes cluster resource.
	ProvisioningState *KubernetesClusterProvisioningState
}

// KubernetesClusterRestartNodeParameters represents the body of the request to restart the node of a Kubernetes cluster.
type KubernetesClusterRestartNodeParameters struct {
	// REQUIRED; The name of the node to restart.
	NodeName *string
}

// KubernetesLabel represents a single entry for a Kubernetes label or taint such as those used on a node or pod.
type KubernetesLabel struct {
	// REQUIRED; The name of the label or taint.
	Key *string

	// REQUIRED; The value of the label or taint.
	Value *string
}

// L2Network represents a network that utilizes a single isolation domain set up for layer-2 resources.
type L2Network struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *L2NetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// L2NetworkAttachmentConfiguration represents the configuration of the attachment of a Layer 2 network.
type L2NetworkAttachmentConfiguration struct {
	// REQUIRED; The resource ID of the network that is being configured for attachment.
	NetworkID *string

	// The indicator of how this network will be utilized by the Kubernetes cluster.
	PluginType *KubernetesPluginType
}

// L2NetworkList represents a list of L2 networks.
type L2NetworkList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of L2 networks.
	Value []*L2Network
}

// L2NetworkPatchParameters represents the body of the request to patch the L2 network.
type L2NetworkPatchParameters struct {
	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// L2NetworkProperties represents properties of the L2 network.
type L2NetworkProperties struct {
	// REQUIRED; The resource ID of the Network Fabric l2IsolationDomain.
	L2IsolationDomainID *string

	// Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network
	// plugin type for Hybrid AKS.
	HybridAksPluginType *HybridAksPluginType

	// The default interface name for this L2 network in the virtual machine. This name can be overridden by the name supplied
	// in the network attachment configuration of that virtual machine.
	InterfaceName *string

	// READ-ONLY; The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
	AssociatedResourceIDs []*string

	// READ-ONLY; The resource ID of the Network Cloud cluster this L2 network is associated with.
	ClusterID *string

	// READ-ONLY; The more detailed status of the L2 network.
	DetailedStatus *L2NetworkDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource ID(s) that are
	// associated with this L2 network.
	HybridAksClustersAssociatedIDs []*string

	// READ-ONLY; The provisioning state of the L2 network.
	ProvisioningState *L2NetworkProvisioningState

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource ID(s), excluding
	// any Hybrid AKS virtual machines, that are currently using this L2 network.
	VirtualMachinesAssociatedIDs []*string
}

// L3Network represents a network that utilizes a single isolation domain set up for layer-3 resources.
type L3Network struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *L3NetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// L3NetworkAttachmentConfiguration represents the configuration of the attachment of a Layer 3 network.
type L3NetworkAttachmentConfiguration struct {
	// REQUIRED; The resource ID of the network that is being configured for attachment.
	NetworkID *string

	// The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached.
	IpamEnabled *L3NetworkConfigurationIpamEnabled

	// The indicator of how this network will be utilized by the Kubernetes cluster.
	PluginType *KubernetesPluginType
}

// L3NetworkList represents a list of L3 networks.
type L3NetworkList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of L3 networks.
	Value []*L3Network
}

// L3NetworkPatchParameters represents the body of the request to patch the cloud services network.
type L3NetworkPatchParameters struct {
	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// L3NetworkProperties represents properties of the L3 network.
type L3NetworkProperties struct {
	// REQUIRED; The resource ID of the Network Fabric l3IsolationDomain.
	L3IsolationDomainID *string

	// REQUIRED; The VLAN from the l3IsolationDomain that is used for this network.
	Vlan *int64

	// Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator
	// of whether or not to disable IPAM allocation on the network attachment
	// definition injected into the Hybrid AKS Cluster.
	HybridAksIpamEnabled *HybridAksIpamEnabled

	// Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network
	// plugin type for Hybrid AKS.
	HybridAksPluginType *HybridAksPluginType

	// The type of the IP address allocation, defaulted to "DualStack".
	IPAllocationType *IPAllocationType

	// The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type is IPV4 or DualStack.
	IPv4ConnectedPrefix *string

	// The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type is IPV6 or DualStack.
	IPv6ConnectedPrefix *string

	// The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied
	// in the network attachment configuration of that virtual machine.
	InterfaceName *string

	// READ-ONLY; The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
	AssociatedResourceIDs []*string

	// READ-ONLY; The resource ID of the Network Cloud cluster this L3 network is associated with.
	ClusterID *string

	// READ-ONLY; The more detailed status of the L3 network.
	DetailedStatus *L3NetworkDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated
	// with this L3 network.
	HybridAksClustersAssociatedIDs []*string

	// READ-ONLY; The provisioning state of the L3 network.
	ProvisioningState *L3NetworkProvisioningState

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any
	// Hybrid AKS virtual machines, that are currently using this L3 network.
	VirtualMachinesAssociatedIDs []*string
}

// LldpNeighbor - Type Deprecated. Will be removed in an upcoming version. LldpNeighbor represents the details about the device
// connected to the NIC.
type LldpNeighbor struct {
	// READ-ONLY; The descriptive information about the port on the connected device.
	PortDescription *string

	// READ-ONLY; The system-assigned name of the port on the connected device.
	PortName *string

	// READ-ONLY; The descriptive information about the connected device.
	SystemDescription *string

	// READ-ONLY; The system-assigned name of the connected device.
	SystemName *string
}

// MachineDisk - Disk represents the properties of the disk.
type MachineDisk struct {
	// READ-ONLY; The maximum amount of storage in GB.
	CapacityGB *int64

	// READ-ONLY; The connection type of the rack SKU resource.
	Connection *MachineSKUDiskConnectionType

	// READ-ONLY; The disk type of rack SKU resource.
	Type *DiskType
}

// MachineSKUProperties - MachineSkuProperties represents the properties of the machine SKU.
type MachineSKUProperties struct {
	// READ-ONLY; The type of bootstrap protocol used.
	BootstrapProtocol *BootstrapProtocol

	// READ-ONLY; The count of CPU cores for this machine.
	CPUCores *int64

	// READ-ONLY; The count of CPU sockets for this machine.
	CPUSockets *int64

	// READ-ONLY; The list of disks.
	Disks []*MachineDisk

	// READ-ONLY; The generation of the architecture.
	Generation *string

	// READ-ONLY; The hardware version of the machine.
	HardwareVersion *string

	// READ-ONLY; The maximum amount of memory in GB.
	MemoryCapacityGB *int64

	// READ-ONLY; The model of the machine.
	Model *string

	// READ-ONLY; The list of network interfaces.
	NetworkInterfaces []*NetworkInterface

	// READ-ONLY; The count of SMT and physical core threads for this machine.
	TotalThreads *int64

	// READ-ONLY; The make of the machine.
	Vendor *string
}

// MachineSKUSlot - MachineSkuSlot represents a single SKU and rack slot associated with the machine.
type MachineSKUSlot struct {
	// The list of the resource properties.
	Properties *MachineSKUProperties

	// READ-ONLY; The position in the rack for the machine.
	RackSlot *int64
}

// ManagedResourceGroupConfiguration represents the configuration of the resource group managed by Azure.
type ManagedResourceGroupConfiguration struct {
	// The location of the managed resource group. If not specified, the location of the parent resource is chosen.
	Location *string

	// The name for the managed resource group. If not specified, the unique name is automatically generated.
	Name *string
}

// NetworkAttachment represents the single network attachment.
type NetworkAttachment struct {
	// REQUIRED; The resource ID of the associated network attached to the virtual machine. It can be one of cloudServicesNetwork,
	// l3Network, l2Network or trunkedNetwork resources.
	AttachedNetworkID *string

	// REQUIRED; The IP allocation mechanism for the virtual machine. Dynamic and Static are only valid for l3Network which may
	// also specify Disabled. Otherwise, Disabled is the only permitted value.
	IPAllocationMethod *VirtualMachineIPAllocationMethod

	// The indicator of whether this is the default gateway. Only one of the attached networks (including the CloudServicesNetwork
	// attachment) for a single machine may be specified as True.
	DefaultGateway *DefaultGateway

	// The IPv4 address of the virtual machine.
	// This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
	// If IPAllocationMethod is: Static - this field must contain a user specified IPv4 address from within the subnet specified
	// in the attached network. Dynamic - this field is read-only, but will be
	// populated with an address from within the subnet specified in the attached network. Disabled - this field will be empty.
	IPv4Address *string

	// The IPv6 address of the virtual machine.
	// This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
	// If IPAllocationMethod is: Static - this field must contain an IPv6 address range from within the range specified in the
	// attached network. Dynamic - this field is read-only, but will be populated with
	// an range from within the subnet specified in the attached network. Disabled - this field will be empty.
	IPv6Address *string

	// The associated network's interface name. If specified, the network attachment name has a maximum length of 15 characters
	// and must be unique to this virtual machine. If the user doesn’t specify this
	// value, the default interface name of the network resource will be used. For a CloudServicesNetwork resource, this name
	// will be ignored.
	NetworkAttachmentName *string

	// READ-ONLY; The MAC address of the interface for the virtual machine that corresponds to this network attachment.
	MacAddress *string
}

// NetworkConfiguration specifies the Kubernetes cluster network related configuration.
type NetworkConfiguration struct {
	// REQUIRED; The resource ID of the associated Cloud Services network.
	CloudServicesNetworkID *string

	// REQUIRED; The resource ID of the Layer 3 network that is used for creation of the Container Networking Interface network.
	CniNetworkID *string

	// The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
	AttachedNetworkConfiguration *AttachedNetworkConfiguration

	// The configuration of the BGP service load balancer for this Kubernetes cluster.
	BgpServiceLoadBalancerConfiguration *BgpServiceLoadBalancerConfiguration

	// The IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in service CIDR.
	DNSServiceIP *string

	// The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs,
	// one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
	PodCidrs []*string

	// The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two
	// CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking.
	ServiceCidrs []*string
}

// NetworkInterface represents properties of the network interface.
type NetworkInterface struct {
	// READ-ONLY; The partial address of Peripheral Component Interconnect (PCI).
	Address *string

	// READ-ONLY; The connection type of the device.
	DeviceConnectionType *DeviceConnectionType

	// READ-ONLY; The model name of the device.
	Model *string

	// READ-ONLY; The physical slot for this device.
	PhysicalSlot *int64

	// READ-ONLY; The number of ports on the device.
	PortCount *int64

	// READ-ONLY; The maximum amount of data in GB that the line card transmits through a port at any given second.
	PortSpeed *int64

	// READ-ONLY; The vendor name of the device.
	Vendor *string
}

// Nic - Type Deprecated. Will be removed in an upcoming version. Nic represents the network interface card details.
type Nic struct {
	// READ-ONLY; The information about the device connected to this NIC.
	LldpNeighbor *LldpNeighbor

	// READ-ONLY; The MAC address associated with this NIC.
	MacAddress *string

	// READ-ONLY; The name of the NIC/interface.
	Name *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time

	// READ-ONLY; Fully qualified ID of the resource against which the original async operation was started.
	ResourceID *string
}

// OsDisk represents configuration of the boot disk.
type OsDisk struct {
	// REQUIRED; The size of the disk in gigabytes. Required if the createOption is Ephemeral.
	DiskSizeGB *int64

	// The strategy for creating the OS disk.
	CreateOption *OsDiskCreateOption

	// The strategy for deleting the OS disk.
	DeleteOption *OsDiskDeleteOption
}

// Rack represents the hardware of the rack and is dependent upon the cluster for lifecycle.
type Rack struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *RackProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RackDefinition represents details regarding the rack.
type RackDefinition struct {
	// REQUIRED; The resource ID of the network rack that matches this rack definition.
	NetworkRackID *string

	// REQUIRED; The resource ID of the sku for the rack being added.
	RackSKUID *string

	// REQUIRED; The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other
	// than a serial number may be provided if desired.
	RackSerialNumber *string

	// The zone name used for this rack when created. Availability zones are used for workload placement.
	AvailabilityZone *string

	// The unordered list of bare metal machine configuration.
	BareMetalMachineConfigurationData []*BareMetalMachineConfigurationData

	// The free-form description of the rack's location.
	RackLocation *string

	// The list of storage appliance configuration data for this rack.
	StorageApplianceConfigurationData []*StorageApplianceConfigurationData
}

// RackList represents a list of racks.
type RackList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of racks.
	Value []*Rack
}

// RackPatchParameters represents the body of the request to patch the rack properties.
type RackPatchParameters struct {
	// The list of the resource properties.
	Properties *RacksPatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// RackProperties represents the properties of the rack.
type RackProperties struct {
	// REQUIRED; The value that will be used for machines in this rack to represent the availability zones that can be referenced
	// by Hybrid AKS Clusters for node arrangement.
	AvailabilityZone *string

	// REQUIRED; The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
	RackLocation *string

	// REQUIRED; The SKU for the rack.
	RackSKUID *string

	// REQUIRED; The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other
	// than a serial number may be provided if desired.
	RackSerialNumber *string

	// READ-ONLY; The resource ID of the cluster the rack is created for. This value is set when the rack is created by the cluster.
	ClusterID *string

	// READ-ONLY; The more detailed status of the rack.
	DetailedStatus *RackDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The provisioning state of the rack resource.
	ProvisioningState *RackProvisioningState
}

// RackSKU - RackSku represents the SKU information of the rack.
type RackSKU struct {
	// REQUIRED; The list of the resource properties.
	Properties *RackSKUProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RackSKUList - RackSkuList represents a list of rack SKUs.
type RackSKUList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of Rack SKUs.
	Value []*RackSKU
}

// RackSKUProperties - RackSkuProperties represents the properties of compute-related hardware for a rack. This supports both
// aggregator and compute racks.
type RackSKUProperties struct {
	// READ-ONLY; The list of machine SKUs and associated rack slot for the compute-dedicated machines in this rack model.
	ComputeMachines []*MachineSKUSlot

	// READ-ONLY; The list of machine SKUs and associated rack slot for the control-plane dedicated machines in this rack model.
	ControllerMachines []*MachineSKUSlot

	// READ-ONLY; The free-form text describing the rack.
	Description *string

	// READ-ONLY; The maximum number of compute racks supported by an aggregator rack. 0 if this is a compute rack or a rack for
	// a single rack cluster(rackType="Single").
	MaxClusterSlots *int64

	// READ-ONLY; The provisioning state of the rack SKU resource.
	ProvisioningState *RackSKUProvisioningState

	// READ-ONLY; The type of the rack.
	RackType *RackSKUType

	// READ-ONLY; The list of appliance SKUs and associated rack slot for the storage appliance(s) in this rack model.
	StorageAppliances []*StorageApplianceSKUSlot

	// READ-ONLY; The list of supported SKUs if the rack is an aggregator.
	SupportedRackSKUIDs []*string
}

// RacksPatchProperties represents the properties of the rack during patching.
type RacksPatchProperties struct {
	// The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
	RackLocation *string

	// The globally unique identifier for the rack.
	RackSerialNumber *string
}

// SSHPublicKey - SshPublicKey represents the public key used to authenticate with a resource through SSH.
type SSHPublicKey struct {
	// REQUIRED; The SSH public key data.
	KeyData *string
}

// ServiceLoadBalancerBgpPeer represents the configuration of the BGP service load balancer for the Kubernetes cluster.
type ServiceLoadBalancerBgpPeer struct {
	// REQUIRED; The name used to identify this BGP peer for association with a BGP advertisement.
	Name *string

	// REQUIRED; The IPv4 or IPv6 address used to connect this BGP session.
	PeerAddress *string

	// REQUIRED; The autonomous system number expected from the remote end of the BGP session.
	PeerAsn *int64

	// The indicator of BFD enablement for this BgpPeer.
	BfdEnabled *BfdEnabled

	// The indicator to enable multi-hop peering support.
	BgpMultiHop *BgpMultiHop

	// The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H.
	HoldTime *string

	// The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H.
	KeepAliveTime *string

	// The autonomous system number used for the local end of the BGP session.
	MyAsn *int64

	// The authentication password for routers enforcing TCP MD5 authenticated sessions.
	Password *string

	// The port used to connect this BGP session.
	PeerPort *int64
}

// ServicePrincipalInformation represents the details of the service principal to be used by the cluster during Arc Appliance
// installation.
type ServicePrincipalInformation struct {
	// REQUIRED; The application ID, also known as client ID, of the service principal.
	ApplicationID *string

	// REQUIRED; The password of the service principal.
	Password *string

	// REQUIRED; The principal ID, also known as the object ID, of the service principal.
	PrincipalID *string

	// REQUIRED; The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
	TenantID *string
}

// StorageAppliance represents on-premises Network Cloud storage appliance.
type StorageAppliance struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *StorageApplianceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StorageApplianceConfigurationData represents configuration for the storage application.
type StorageApplianceConfigurationData struct {
	// REQUIRED; The credentials of the administrative interface on this storage appliance.
	AdminCredentials *AdministrativeCredentials

	// REQUIRED; The slot that storage appliance is in the rack based on the BOM configuration.
	RackSlot *int64

	// REQUIRED; The serial number of the appliance.
	SerialNumber *string

	// The user-provided name for the storage appliance that will be created from this specification.
	StorageApplianceName *string
}

// StorageApplianceEnableRemoteVendorManagementParameters represents the body of the request to enable remote vendor management
// of a storage appliance.
type StorageApplianceEnableRemoteVendorManagementParameters struct {
	// Field Deprecated. This field is not used and will be rejected if provided. The list of IPv4 subnets (in CIDR format), IPv6
	// subnets (in CIDR format), or hostnames that the storage appliance needs
	// accessible in order to turn on the remote vendor management.
	SupportEndpoints []*string
}

// StorageApplianceList represents a list of storage appliances.
type StorageApplianceList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of storage appliances.
	Value []*StorageAppliance
}

// StorageAppliancePatchParameters represents the body of the request to patch storage appliance properties.
type StorageAppliancePatchParameters struct {
	// The list of the resource properties.
	Properties *StorageAppliancePatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// StorageAppliancePatchProperties represents the properties of the storage appliance that can be patched.
type StorageAppliancePatchProperties struct {
	// The serial number for the storage appliance.
	SerialNumber *string
}

// StorageApplianceProperties represents the properties of the storage appliance.
type StorageApplianceProperties struct {
	// REQUIRED; The credentials of the administrative interface on this storage appliance.
	AdministratorCredentials *AdministrativeCredentials

	// REQUIRED; The resource ID of the rack where this storage appliance resides.
	RackID *string

	// REQUIRED; The slot the storage appliance is in the rack based on the BOM configuration.
	RackSlot *int64

	// REQUIRED; The serial number for the storage appliance.
	SerialNumber *string

	// REQUIRED; The SKU for the storage appliance.
	StorageApplianceSKUID *string

	// READ-ONLY; The total capacity of the storage appliance.
	Capacity *int64

	// READ-ONLY; The amount of storage consumed.
	CapacityUsed *int64

	// READ-ONLY; The resource ID of the cluster this storage appliance is associated with.
	ClusterID *string

	// READ-ONLY; The detailed status of the storage appliance.
	DetailedStatus *StorageApplianceDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The endpoint for the management interface of the storage appliance.
	ManagementIPv4Address *string

	// READ-ONLY; The provisioning state of the storage appliance.
	ProvisioningState *StorageApplianceProvisioningState

	// READ-ONLY; The indicator of whether the storage appliance supports remote vendor management.
	RemoteVendorManagementFeature *RemoteVendorManagementFeature

	// READ-ONLY; The indicator of whether the remote vendor management feature is enabled or disabled, or unsupported if it is
	// an unsupported feature.
	RemoteVendorManagementStatus *RemoteVendorManagementStatus
}

// StorageApplianceSKUProperties - StorageApplianceSkuProperties represents the properties of the storage appliance SKU.
type StorageApplianceSKUProperties struct {
	// READ-ONLY; The maximum capacity of the storage appliance.
	CapacityGB *int64

	// READ-ONLY; The model of the storage appliance.
	Model *string
}

// StorageApplianceSKUSlot - StorageApplianceSkuSlot represents the single SKU and rack slot associated with the storage appliance.
type StorageApplianceSKUSlot struct {
	// The list of the resource properties.
	Properties *StorageApplianceSKUProperties

	// READ-ONLY; The position in the rack for the storage appliance.
	RackSlot *int64
}

// StorageProfile represents information about a disk.
type StorageProfile struct {
	// REQUIRED; The disk to use with this virtual machine.
	OSDisk *OsDisk

	// The resource IDs of volumes that are requested to be attached to the virtual machine.
	VolumeAttachments []*string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrunkedNetwork represents a network that utilizes multiple isolation domains and specified VLANs to create a trunked network.
type TrunkedNetwork struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *TrunkedNetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrunkedNetworkAttachmentConfiguration represents the configuration of the attachment of a trunked network.
type TrunkedNetworkAttachmentConfiguration struct {
	// REQUIRED; The resource ID of the network that is being configured for attachment.
	NetworkID *string

	// The indicator of how this network will be utilized by the Kubernetes cluster.
	PluginType *KubernetesPluginType
}

// TrunkedNetworkList represents a list of trunked networks.
type TrunkedNetworkList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of trunked networks.
	Value []*TrunkedNetwork
}

// TrunkedNetworkPatchParameters represents the body of the request to patch the Trunked network.
type TrunkedNetworkPatchParameters struct {
	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// TrunkedNetworkProperties represents properties of the trunked network.
type TrunkedNetworkProperties struct {
	// REQUIRED; The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain
	// and l3IsolationDomain resources.
	IsolationDomainIDs []*string

	// REQUIRED; The list of vlans that are selected from the isolation domains for trunking.
	Vlans []*int64

	// Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network
	// plugin type for Hybrid AKS.
	HybridAksPluginType *HybridAksPluginType

	// The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied
	// in the network attachment configuration of that virtual machine.
	InterfaceName *string

	// READ-ONLY; The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
	AssociatedResourceIDs []*string

	// READ-ONLY; The resource ID of the Network Cloud cluster this trunked network is associated with.
	ClusterID *string

	// READ-ONLY; The more detailed status of the trunked network.
	DetailedStatus *TrunkedNetworkDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated
	// with this trunked network.
	HybridAksClustersAssociatedIDs []*string

	// READ-ONLY; The provisioning state of the trunked network.
	ProvisioningState *TrunkedNetworkProvisioningState

	// READ-ONLY; Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any
	// Hybrid AKS virtual machines, that are currently using this trunked network.
	VirtualMachinesAssociatedIDs []*string
}

// ValidationThreshold indicates allowed machine and node hardware and deployment failures.
type ValidationThreshold struct {
	// REQUIRED; Selection of how the type evaluation is applied to the cluster calculation.
	Grouping *ValidationThresholdGrouping

	// REQUIRED; Selection of how the threshold should be evaluated.
	Type *ValidationThresholdType

	// REQUIRED; The numeric threshold value.
	Value *int64
}

// VirtualMachine represents the on-premises Network Cloud virtual machine.
type VirtualMachine struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *VirtualMachineProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualMachineList represents a list of virtual machines.
type VirtualMachineList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of virtual machines.
	Value []*VirtualMachine
}

// VirtualMachinePatchParameters represents the body of the request to patch the virtual machine.
type VirtualMachinePatchParameters struct {
	// The list of the resource properties.
	Properties *VirtualMachinePatchProperties

	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// VirtualMachinePatchProperties represents the properties of the virtual machine that can be patched.
type VirtualMachinePatchProperties struct {
	// The credentials used to login to the image repository that has access to the specified image.
	VMImageRepositoryCredentials *ImageRepositoryCredentials
}

// VirtualMachinePlacementHint represents a single scheduling hint of the virtual machine.
type VirtualMachinePlacementHint struct {
	// REQUIRED; The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
	HintType *VirtualMachinePlacementHintType

	// REQUIRED; The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node
	// to host the virtual machine.
	ResourceID *string

	// REQUIRED; The indicator of whether the hint is a hard or soft requirement during scheduling.
	SchedulingExecution *VirtualMachineSchedulingExecution

	// REQUIRED; The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in
	// the case of node affinity.
	Scope *VirtualMachinePlacementHintPodAffinityScope
}

// VirtualMachinePowerOffParameters represents the body of the request to power off virtual machine.
type VirtualMachinePowerOffParameters struct {
	// The indicator of whether to skip the graceful OS shutdown and power off the virtual machine immediately.
	SkipShutdown *SkipShutdown
}

// VirtualMachineProperties represents the properties of the virtual machine.
type VirtualMachineProperties struct {
	// REQUIRED; The name of the administrator to which the ssh public keys will be added into the authorized keys.
	AdminUsername *string

	// REQUIRED; The number of CPU cores in the virtual machine.
	CPUCores *int64

	// REQUIRED; The cloud service network that provides platform-level services for the virtual machine.
	CloudServicesNetworkAttachment *NetworkAttachment

	// REQUIRED; The memory size of the virtual machine in GB.
	MemorySizeGB *int64

	// REQUIRED; The storage profile that specifies size and other parameters about the disks related to the virtual machine.
	StorageProfile *StorageProfile

	// REQUIRED; The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used
	// to pull the image.
	VMImage *string

	// Selects the boot method for the virtual machine.
	BootMethod *VirtualMachineBootMethod

	// Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated
	// to run the emulator thread for this virtual machine.
	IsolateEmulatorThread *VirtualMachineIsolateEmulatorThread

	// The list of network attachments to the virtual machine.
	NetworkAttachments []*NetworkAttachment

	// The Base64 encoded cloud-init network data.
	NetworkData *string

	// The scheduling hints for the virtual machine.
	PlacementHints []*VirtualMachinePlacementHint

	// The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init sshauthorizedkeys mechanism
	// for the adminUsername.
	SSHPublicKeys []*SSHPublicKey

	// The Base64 encoded cloud-init user data.
	UserData *string

	// The type of the device model to use.
	VMDeviceModel *VirtualMachineDeviceModelType

	// The credentials used to login to the image repository that has access to the specified image.
	VMImageRepositoryCredentials *ImageRepositoryCredentials

	// Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
	VirtioInterface *VirtualMachineVirtioInterfaceType

	// READ-ONLY; The cluster availability zone containing this virtual machine.
	AvailabilityZone *string

	// READ-ONLY; The resource ID of the bare metal machine the virtual machine has landed to.
	BareMetalMachineID *string

	// READ-ONLY; The resource ID of the cluster the virtual machine is created for.
	ClusterID *string

	// READ-ONLY; The more detailed status of the virtual machine.
	DetailedStatus *VirtualMachineDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The power state of the virtual machine.
	PowerState *VirtualMachinePowerState

	// READ-ONLY; The provisioning state of the virtual machine.
	ProvisioningState *VirtualMachineProvisioningState

	// READ-ONLY; The resource IDs of volumes that are attached to the virtual machine.
	Volumes []*string
}

// Volume represents storage made available for use by resources running on the cluster.
type Volume struct {
	// REQUIRED; The extended location of the cluster associated with the resource.
	ExtendedLocation *ExtendedLocation

	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The list of the resource properties.
	Properties *VolumeProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VolumeList represents a list of volumes.
type VolumeList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of volumes.
	Value []*Volume
}

// VolumePatchParameters represents the body of the request to patch the volume resource.
type VolumePatchParameters struct {
	// The Azure resource tags that will replace the existing ones.
	Tags map[string]*string
}

// VolumeProperties represents properties of the volume resource.
type VolumeProperties struct {
	// REQUIRED; The size of the allocation for this volume in Mebibytes.
	SizeMiB *int64

	// READ-ONLY; The list of resource IDs that attach the volume. It may include virtual machines and Hybrid AKS clusters.
	AttachedTo []*string

	// READ-ONLY; The more detailed status of the volume.
	DetailedStatus *VolumeDetailedStatus

	// READ-ONLY; The descriptive message about the current detailed status.
	DetailedStatusMessage *string

	// READ-ONLY; The provisioning state of the volume.
	ProvisioningState *VolumeProvisioningState

	// READ-ONLY; The unique identifier of the volume.
	SerialNumber *string
}
