//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresqlflexibleservers/v4"
	"net/http"
	"net/url"
	"regexp"
)

// LocationBasedCapabilitiesServer is a fake server for instances of the armpostgresqlflexibleservers.LocationBasedCapabilitiesClient type.
type LocationBasedCapabilitiesServer struct {
	// NewExecutePager is the fake for method LocationBasedCapabilitiesClient.NewExecutePager
	// HTTP status codes to indicate success: http.StatusOK
	NewExecutePager func(locationName string, options *armpostgresqlflexibleservers.LocationBasedCapabilitiesClientExecuteOptions) (resp azfake.PagerResponder[armpostgresqlflexibleservers.LocationBasedCapabilitiesClientExecuteResponse])
}

// NewLocationBasedCapabilitiesServerTransport creates a new instance of LocationBasedCapabilitiesServerTransport with the provided implementation.
// The returned LocationBasedCapabilitiesServerTransport instance is connected to an instance of armpostgresqlflexibleservers.LocationBasedCapabilitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocationBasedCapabilitiesServerTransport(srv *LocationBasedCapabilitiesServer) *LocationBasedCapabilitiesServerTransport {
	return &LocationBasedCapabilitiesServerTransport{
		srv:             srv,
		newExecutePager: newTracker[azfake.PagerResponder[armpostgresqlflexibleservers.LocationBasedCapabilitiesClientExecuteResponse]](),
	}
}

// LocationBasedCapabilitiesServerTransport connects instances of armpostgresqlflexibleservers.LocationBasedCapabilitiesClient to instances of LocationBasedCapabilitiesServer.
// Don't use this type directly, use NewLocationBasedCapabilitiesServerTransport instead.
type LocationBasedCapabilitiesServerTransport struct {
	srv             *LocationBasedCapabilitiesServer
	newExecutePager *tracker[azfake.PagerResponder[armpostgresqlflexibleservers.LocationBasedCapabilitiesClientExecuteResponse]]
}

// Do implements the policy.Transporter interface for LocationBasedCapabilitiesServerTransport.
func (l *LocationBasedCapabilitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocationBasedCapabilitiesClient.NewExecutePager":
		resp, err = l.dispatchNewExecutePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocationBasedCapabilitiesServerTransport) dispatchNewExecutePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewExecutePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewExecutePager not implemented")}
	}
	newExecutePager := l.newExecutePager.get(req)
	if newExecutePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforPostgreSQL/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewExecutePager(locationNameParam, nil)
		newExecutePager = &resp
		l.newExecutePager.add(req, newExecutePager)
		server.PagerResponderInjectNextLinks(newExecutePager, req, func(page *armpostgresqlflexibleservers.LocationBasedCapabilitiesClientExecuteResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newExecutePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newExecutePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newExecutePager) {
		l.newExecutePager.remove(req)
	}
	return resp, nil
}
