//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// APICollectionOffboardingServer is a fake server for instances of the armsecurity.APICollectionOffboardingClient type.
type APICollectionOffboardingServer struct {
	// Delete is the fake for method APICollectionOffboardingClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serviceName string, apiCollectionID string, options *armsecurity.APICollectionOffboardingClientDeleteOptions) (resp azfake.Responder[armsecurity.APICollectionOffboardingClientDeleteResponse], errResp azfake.ErrorResponder)
}

// NewAPICollectionOffboardingServerTransport creates a new instance of APICollectionOffboardingServerTransport with the provided implementation.
// The returned APICollectionOffboardingServerTransport instance is connected to an instance of armsecurity.APICollectionOffboardingClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAPICollectionOffboardingServerTransport(srv *APICollectionOffboardingServer) *APICollectionOffboardingServerTransport {
	return &APICollectionOffboardingServerTransport{srv: srv}
}

// APICollectionOffboardingServerTransport connects instances of armsecurity.APICollectionOffboardingClient to instances of APICollectionOffboardingServer.
// Don't use this type directly, use NewAPICollectionOffboardingServerTransport instead.
type APICollectionOffboardingServerTransport struct {
	srv *APICollectionOffboardingServer
}

// Do implements the policy.Transporter interface for APICollectionOffboardingServerTransport.
func (a *APICollectionOffboardingServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "APICollectionOffboardingClient.Delete":
		resp, err = a.dispatchDelete(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *APICollectionOffboardingServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/apiCollections/(?P<apiCollectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiCollectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiCollectionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, serviceNameParam, apiCollectionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
