//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer is a fake server for instances of the armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient type.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer struct {
	// BeginCreateOrUpdate is the fake for method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, policyName armsql.ManagedShortTermRetentionPolicyName, parameters armsql.ManagedBackupShortTermRetentionPolicy, options *armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, policyName armsql.ManagedShortTermRetentionPolicyName, options *armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetOptions) (resp azfake.Responder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByRestorableDroppedDatabasePager is the fake for method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.NewListByRestorableDroppedDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRestorableDroppedDatabasePager func(resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, options *armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseOptions) (resp azfake.PagerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse])

	// BeginUpdate is the fake for method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, policyName armsql.ManagedShortTermRetentionPolicyName, parameters armsql.ManagedBackupShortTermRetentionPolicy, options *armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport creates a new instance of ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport with the provided implementation.
// The returned ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport instance is connected to an instance of armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport(srv *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer) *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport {
	return &ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport{
		srv:                                     srv,
		beginCreateOrUpdate:                     newTracker[azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse]](),
		newListByRestorableDroppedDatabasePager: newTracker[azfake.PagerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse]](),
		beginUpdate:                             newTracker[azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientUpdateResponse]](),
	}
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport connects instances of armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient to instances of ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer.
// Don't use this type directly, use NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport instead.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport struct {
	srv                                     *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer
	beginCreateOrUpdate                     *tracker[azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse]]
	newListByRestorableDroppedDatabasePager *tracker[azfake.PagerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse]]
	beginUpdate                             *tracker[azfake.PollerResponder[armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport.
func (m *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.NewListByRestorableDroppedDatabasePager":
		resp, err = m.dispatchNewListByRestorableDroppedDatabasePager(req)
	case "ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedDatabases/(?P<restorableDroppedDatabaseId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupShortTermRetentionPolicies/(?P<policyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedBackupShortTermRetentionPolicy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		restorableDroppedDatabaseIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("restorableDroppedDatabaseId")])
		if err != nil {
			return nil, err
		}
		policyNameParam, err := parseWithCast(matches[regex.SubexpIndex("policyName")], func(v string) (armsql.ManagedShortTermRetentionPolicyName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.ManagedShortTermRetentionPolicyName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, restorableDroppedDatabaseIDParam, policyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedDatabases/(?P<restorableDroppedDatabaseId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupShortTermRetentionPolicies/(?P<policyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	restorableDroppedDatabaseIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("restorableDroppedDatabaseId")])
	if err != nil {
		return nil, err
	}
	policyNameParam, err := parseWithCast(matches[regex.SubexpIndex("policyName")], func(v string) (armsql.ManagedShortTermRetentionPolicyName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.ManagedShortTermRetentionPolicyName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, restorableDroppedDatabaseIDParam, policyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedBackupShortTermRetentionPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport) dispatchNewListByRestorableDroppedDatabasePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByRestorableDroppedDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRestorableDroppedDatabasePager not implemented")}
	}
	newListByRestorableDroppedDatabasePager := m.newListByRestorableDroppedDatabasePager.get(req)
	if newListByRestorableDroppedDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedDatabases/(?P<restorableDroppedDatabaseId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupShortTermRetentionPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		restorableDroppedDatabaseIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("restorableDroppedDatabaseId")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByRestorableDroppedDatabasePager(resourceGroupNameParam, managedInstanceNameParam, restorableDroppedDatabaseIDParam, nil)
		newListByRestorableDroppedDatabasePager = &resp
		m.newListByRestorableDroppedDatabasePager.add(req, newListByRestorableDroppedDatabasePager)
		server.PagerResponderInjectNextLinks(newListByRestorableDroppedDatabasePager, req, func(page *armsql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByRestorableDroppedDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByRestorableDroppedDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRestorableDroppedDatabasePager) {
		m.newListByRestorableDroppedDatabasePager.remove(req)
	}
	return resp, nil
}

func (m *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedDatabases/(?P<restorableDroppedDatabaseId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupShortTermRetentionPolicies/(?P<policyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedBackupShortTermRetentionPolicy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		restorableDroppedDatabaseIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("restorableDroppedDatabaseId")])
		if err != nil {
			return nil, err
		}
		policyNameParam, err := parseWithCast(matches[regex.SubexpIndex("policyName")], func(v string) (armsql.ManagedShortTermRetentionPolicyName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.ManagedShortTermRetentionPolicyName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, restorableDroppedDatabaseIDParam, policyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
