// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/css/v1/css_product_common.proto

package csspb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Attributes for CSS Product.
type Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL directly linking to your the Product Detail Page of the CSS.
	CppLink *string `protobuf:"bytes,1,opt,name=cpp_link,json=cppLink,proto3,oneof" json:"cpp_link,omitempty"`
	// URL for the mobile-optimized version of the Product Detail Page of the CSS.
	CppMobileLink *string `protobuf:"bytes,2,opt,name=cpp_mobile_link,json=cppMobileLink,proto3,oneof" json:"cpp_mobile_link,omitempty"`
	// Allows advertisers to override the item URL when the product is shown
	// within the context of Product Ads.
	CppAdsRedirect *string `protobuf:"bytes,42,opt,name=cpp_ads_redirect,json=cppAdsRedirect,proto3,oneof" json:"cpp_ads_redirect,omitempty"`
	// Low Price of the aggregate offer.
	LowPrice *typepb.Price `protobuf:"bytes,3,opt,name=low_price,json=lowPrice,proto3" json:"low_price,omitempty"`
	// High Price of the aggregate offer.
	HighPrice *typepb.Price `protobuf:"bytes,4,opt,name=high_price,json=highPrice,proto3" json:"high_price,omitempty"`
	// The number of aggregate offers.
	NumberOfOffers *int64 `protobuf:"varint,5,opt,name=number_of_offers,json=numberOfOffers,proto3,oneof" json:"number_of_offers,omitempty"`
	// Condition of the headline offer.
	HeadlineOfferCondition *string `protobuf:"bytes,6,opt,name=headline_offer_condition,json=headlineOfferCondition,proto3,oneof" json:"headline_offer_condition,omitempty"`
	// Headline Price of the aggregate offer.
	HeadlineOfferPrice *typepb.Price `protobuf:"bytes,7,opt,name=headline_offer_price,json=headlineOfferPrice,proto3" json:"headline_offer_price,omitempty"`
	// Link to the headline offer.
	HeadlineOfferLink *string `protobuf:"bytes,8,opt,name=headline_offer_link,json=headlineOfferLink,proto3,oneof" json:"headline_offer_link,omitempty"`
	// Mobile Link to the headline offer.
	HeadlineOfferMobileLink *string `protobuf:"bytes,9,opt,name=headline_offer_mobile_link,json=headlineOfferMobileLink,proto3,oneof" json:"headline_offer_mobile_link,omitempty"`
	// Headline Price of the aggregate offer.
	HeadlineOfferShippingPrice *typepb.Price `protobuf:"bytes,41,opt,name=headline_offer_shipping_price,json=headlineOfferShippingPrice,proto3" json:"headline_offer_shipping_price,omitempty"`
	// Title of the item.
	Title *string `protobuf:"bytes,10,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// URL of an image of the item.
	ImageLink *string `protobuf:"bytes,11,opt,name=image_link,json=imageLink,proto3,oneof" json:"image_link,omitempty"`
	// Additional URL of images of the item.
	AdditionalImageLinks []string `protobuf:"bytes,12,rep,name=additional_image_links,json=additionalImageLinks,proto3" json:"additional_image_links,omitempty"`
	// Description of the item.
	Description *string `protobuf:"bytes,13,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Product Related Attributes.[14-36]
	// Brand of the item.
	Brand *string `protobuf:"bytes,14,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Manufacturer Part Number
	// ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
	// item.
	Mpn *string `protobuf:"bytes,15,opt,name=mpn,proto3,oneof" json:"mpn,omitempty"`
	// Global Trade Item Number
	// ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
	// item.
	Gtin *string `protobuf:"bytes,16,opt,name=gtin,proto3,oneof" json:"gtin,omitempty"`
	// Categories of the item (formatted as in [products data
	// specification](https://support.google.com/merchants/answer/6324406)).
	ProductTypes []string `protobuf:"bytes,36,rep,name=product_types,json=productTypes,proto3" json:"product_types,omitempty"`
	// Google's category of the item (see [Google product
	// taxonomy](https://support.google.com/merchants/answer/1705911)). When
	// querying products, this field will contain the user provided value. There
	// is currently no way to get back the auto assigned google product
	// categories through the API.
	GoogleProductCategory *string `protobuf:"bytes,17,opt,name=google_product_category,json=googleProductCategory,proto3,oneof" json:"google_product_category,omitempty"`
	// Set to true if the item is targeted towards adults.
	Adult *bool `protobuf:"varint,18,opt,name=adult,proto3,oneof" json:"adult,omitempty"`
	// The number of identical products in a merchant-defined multipack.
	Multipack *int64 `protobuf:"varint,19,opt,name=multipack,proto3,oneof" json:"multipack,omitempty"`
	// Whether the item is a merchant-defined bundle. A bundle is a custom
	// grouping of different products sold by a merchant for a single price.
	IsBundle *bool `protobuf:"varint,20,opt,name=is_bundle,json=isBundle,proto3,oneof" json:"is_bundle,omitempty"`
	// Target age group of the item.
	AgeGroup *string `protobuf:"bytes,21,opt,name=age_group,json=ageGroup,proto3,oneof" json:"age_group,omitempty"`
	// Color of the item.
	Color *string `protobuf:"bytes,22,opt,name=color,proto3,oneof" json:"color,omitempty"`
	// Target gender of the item.
	Gender *string `protobuf:"bytes,23,opt,name=gender,proto3,oneof" json:"gender,omitempty"`
	// The material of which the item is made.
	Material *string `protobuf:"bytes,24,opt,name=material,proto3,oneof" json:"material,omitempty"`
	// The item's pattern (e.g. polka dots).
	Pattern *string `protobuf:"bytes,25,opt,name=pattern,proto3,oneof" json:"pattern,omitempty"`
	// Size of the item. Only one value is allowed. For variants with different
	// sizes, insert a separate product for each size with the same
	// `itemGroupId` value (see
	// [https://support.google.com/merchants/answer/6324492](size definition)).
	Size *string `protobuf:"bytes,26,opt,name=size,proto3,oneof" json:"size,omitempty"`
	// System in which the size is specified. Recommended for apparel items.
	SizeSystem *string `protobuf:"bytes,27,opt,name=size_system,json=sizeSystem,proto3,oneof" json:"size_system,omitempty"`
	// The cut of the item. It can be used to represent combined size types for
	// apparel items. Maximum two of size types can be provided (see
	// [https://support.google.com/merchants/answer/6324497](size type)).
	SizeTypes []string `protobuf:"bytes,28,rep,name=size_types,json=sizeTypes,proto3" json:"size_types,omitempty"`
	// Shared identifier for all variants of the same product.
	ItemGroupId *string `protobuf:"bytes,29,opt,name=item_group_id,json=itemGroupId,proto3,oneof" json:"item_group_id,omitempty"`
	// Technical specification or additional product details.
	ProductDetails []*ProductDetail `protobuf:"bytes,30,rep,name=product_details,json=productDetails,proto3" json:"product_details,omitempty"`
	// The weight of the product in the units provided. The value must be
	// between 0 (exclusive) and 2000 (inclusive).
	ProductWeight *ProductWeight `protobuf:"bytes,31,opt,name=product_weight,json=productWeight,proto3" json:"product_weight,omitempty"`
	// The length of the product in the units provided. The value must be
	// between 0 (exclusive) and 3000 (inclusive).
	ProductLength *ProductDimension `protobuf:"bytes,32,opt,name=product_length,json=productLength,proto3" json:"product_length,omitempty"`
	// The width of the product in the units provided. The value must be between
	// 0 (exclusive) and 3000 (inclusive).
	ProductWidth *ProductDimension `protobuf:"bytes,33,opt,name=product_width,json=productWidth,proto3" json:"product_width,omitempty"`
	// The height of the product in the units provided. The value must be
	// between
	// 0 (exclusive) and 3000 (inclusive).
	ProductHeight *ProductDimension `protobuf:"bytes,34,opt,name=product_height,json=productHeight,proto3" json:"product_height,omitempty"`
	// Bullet points describing the most relevant highlights of a product.
	ProductHighlights []string `protobuf:"bytes,35,rep,name=product_highlights,json=productHighlights,proto3" json:"product_highlights,omitempty"`
	// A list of certificates claimed by the CSS for the given product.
	Certifications []*Certification `protobuf:"bytes,39,rep,name=certifications,proto3" json:"certifications,omitempty"`
	// Date on which the item should expire, as specified upon insertion, in
	// [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
	// expiration date in Google Shopping is exposed in `productstatuses` as
	// [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
	// and might be earlier if `expirationDate` is too far in the future.
	// Note: It may take 2+ days from the expiration date for the item to
	// actually get deleted.
	ExpirationDate *timestamppb.Timestamp `protobuf:"bytes,40,opt,name=expiration_date,json=expirationDate,proto3" json:"expiration_date,omitempty"`
	// The list of destinations to include for this target (corresponds to
	// checked check boxes in Merchant Center). Default destinations are always
	// included unless provided in `excludedDestinations`.
	IncludedDestinations []string `protobuf:"bytes,43,rep,name=included_destinations,json=includedDestinations,proto3" json:"included_destinations,omitempty"`
	// The list of destinations to exclude for this target (corresponds to
	// unchecked check boxes in Merchant Center).
	ExcludedDestinations []string `protobuf:"bytes,44,rep,name=excluded_destinations,json=excludedDestinations,proto3" json:"excluded_destinations,omitempty"`
	// Publication of this item will be temporarily paused.
	Pause *string `protobuf:"bytes,45,opt,name=pause,proto3,oneof" json:"pause,omitempty"`
	// Custom label 0 for custom grouping of items in a Shopping campaign.
	CustomLabel_0 *string `protobuf:"bytes,46,opt,name=custom_label_0,json=customLabel0,proto3,oneof" json:"custom_label_0,omitempty"`
	// Custom label 1 for custom grouping of items in a Shopping campaign.
	CustomLabel_1 *string `protobuf:"bytes,47,opt,name=custom_label_1,json=customLabel1,proto3,oneof" json:"custom_label_1,omitempty"`
	// Custom label 2 for custom grouping of items in a Shopping campaign.
	CustomLabel_2 *string `protobuf:"bytes,48,opt,name=custom_label_2,json=customLabel2,proto3,oneof" json:"custom_label_2,omitempty"`
	// Custom label 3 for custom grouping of items in a Shopping campaign.
	CustomLabel_3 *string `protobuf:"bytes,49,opt,name=custom_label_3,json=customLabel3,proto3,oneof" json:"custom_label_3,omitempty"`
	// Custom label 4 for custom grouping of items in a Shopping campaign.
	CustomLabel_4 *string `protobuf:"bytes,50,opt,name=custom_label_4,json=customLabel4,proto3,oneof" json:"custom_label_4,omitempty"`
}

func (x *Attributes) Reset() {
	*x = Attributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attributes) ProtoMessage() {}

func (x *Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attributes.ProtoReflect.Descriptor instead.
func (*Attributes) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{0}
}

func (x *Attributes) GetCppLink() string {
	if x != nil && x.CppLink != nil {
		return *x.CppLink
	}
	return ""
}

func (x *Attributes) GetCppMobileLink() string {
	if x != nil && x.CppMobileLink != nil {
		return *x.CppMobileLink
	}
	return ""
}

func (x *Attributes) GetCppAdsRedirect() string {
	if x != nil && x.CppAdsRedirect != nil {
		return *x.CppAdsRedirect
	}
	return ""
}

func (x *Attributes) GetLowPrice() *typepb.Price {
	if x != nil {
		return x.LowPrice
	}
	return nil
}

func (x *Attributes) GetHighPrice() *typepb.Price {
	if x != nil {
		return x.HighPrice
	}
	return nil
}

func (x *Attributes) GetNumberOfOffers() int64 {
	if x != nil && x.NumberOfOffers != nil {
		return *x.NumberOfOffers
	}
	return 0
}

func (x *Attributes) GetHeadlineOfferCondition() string {
	if x != nil && x.HeadlineOfferCondition != nil {
		return *x.HeadlineOfferCondition
	}
	return ""
}

func (x *Attributes) GetHeadlineOfferPrice() *typepb.Price {
	if x != nil {
		return x.HeadlineOfferPrice
	}
	return nil
}

func (x *Attributes) GetHeadlineOfferLink() string {
	if x != nil && x.HeadlineOfferLink != nil {
		return *x.HeadlineOfferLink
	}
	return ""
}

func (x *Attributes) GetHeadlineOfferMobileLink() string {
	if x != nil && x.HeadlineOfferMobileLink != nil {
		return *x.HeadlineOfferMobileLink
	}
	return ""
}

func (x *Attributes) GetHeadlineOfferShippingPrice() *typepb.Price {
	if x != nil {
		return x.HeadlineOfferShippingPrice
	}
	return nil
}

func (x *Attributes) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *Attributes) GetImageLink() string {
	if x != nil && x.ImageLink != nil {
		return *x.ImageLink
	}
	return ""
}

func (x *Attributes) GetAdditionalImageLinks() []string {
	if x != nil {
		return x.AdditionalImageLinks
	}
	return nil
}

func (x *Attributes) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Attributes) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *Attributes) GetMpn() string {
	if x != nil && x.Mpn != nil {
		return *x.Mpn
	}
	return ""
}

func (x *Attributes) GetGtin() string {
	if x != nil && x.Gtin != nil {
		return *x.Gtin
	}
	return ""
}

func (x *Attributes) GetProductTypes() []string {
	if x != nil {
		return x.ProductTypes
	}
	return nil
}

func (x *Attributes) GetGoogleProductCategory() string {
	if x != nil && x.GoogleProductCategory != nil {
		return *x.GoogleProductCategory
	}
	return ""
}

func (x *Attributes) GetAdult() bool {
	if x != nil && x.Adult != nil {
		return *x.Adult
	}
	return false
}

func (x *Attributes) GetMultipack() int64 {
	if x != nil && x.Multipack != nil {
		return *x.Multipack
	}
	return 0
}

func (x *Attributes) GetIsBundle() bool {
	if x != nil && x.IsBundle != nil {
		return *x.IsBundle
	}
	return false
}

func (x *Attributes) GetAgeGroup() string {
	if x != nil && x.AgeGroup != nil {
		return *x.AgeGroup
	}
	return ""
}

func (x *Attributes) GetColor() string {
	if x != nil && x.Color != nil {
		return *x.Color
	}
	return ""
}

func (x *Attributes) GetGender() string {
	if x != nil && x.Gender != nil {
		return *x.Gender
	}
	return ""
}

func (x *Attributes) GetMaterial() string {
	if x != nil && x.Material != nil {
		return *x.Material
	}
	return ""
}

func (x *Attributes) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *Attributes) GetSize() string {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return ""
}

func (x *Attributes) GetSizeSystem() string {
	if x != nil && x.SizeSystem != nil {
		return *x.SizeSystem
	}
	return ""
}

func (x *Attributes) GetSizeTypes() []string {
	if x != nil {
		return x.SizeTypes
	}
	return nil
}

func (x *Attributes) GetItemGroupId() string {
	if x != nil && x.ItemGroupId != nil {
		return *x.ItemGroupId
	}
	return ""
}

func (x *Attributes) GetProductDetails() []*ProductDetail {
	if x != nil {
		return x.ProductDetails
	}
	return nil
}

func (x *Attributes) GetProductWeight() *ProductWeight {
	if x != nil {
		return x.ProductWeight
	}
	return nil
}

func (x *Attributes) GetProductLength() *ProductDimension {
	if x != nil {
		return x.ProductLength
	}
	return nil
}

func (x *Attributes) GetProductWidth() *ProductDimension {
	if x != nil {
		return x.ProductWidth
	}
	return nil
}

func (x *Attributes) GetProductHeight() *ProductDimension {
	if x != nil {
		return x.ProductHeight
	}
	return nil
}

func (x *Attributes) GetProductHighlights() []string {
	if x != nil {
		return x.ProductHighlights
	}
	return nil
}

func (x *Attributes) GetCertifications() []*Certification {
	if x != nil {
		return x.Certifications
	}
	return nil
}

func (x *Attributes) GetExpirationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationDate
	}
	return nil
}

func (x *Attributes) GetIncludedDestinations() []string {
	if x != nil {
		return x.IncludedDestinations
	}
	return nil
}

func (x *Attributes) GetExcludedDestinations() []string {
	if x != nil {
		return x.ExcludedDestinations
	}
	return nil
}

func (x *Attributes) GetPause() string {
	if x != nil && x.Pause != nil {
		return *x.Pause
	}
	return ""
}

func (x *Attributes) GetCustomLabel_0() string {
	if x != nil && x.CustomLabel_0 != nil {
		return *x.CustomLabel_0
	}
	return ""
}

func (x *Attributes) GetCustomLabel_1() string {
	if x != nil && x.CustomLabel_1 != nil {
		return *x.CustomLabel_1
	}
	return ""
}

func (x *Attributes) GetCustomLabel_2() string {
	if x != nil && x.CustomLabel_2 != nil {
		return *x.CustomLabel_2
	}
	return ""
}

func (x *Attributes) GetCustomLabel_3() string {
	if x != nil && x.CustomLabel_3 != nil {
		return *x.CustomLabel_3
	}
	return ""
}

func (x *Attributes) GetCustomLabel_4() string {
	if x != nil && x.CustomLabel_4 != nil {
		return *x.CustomLabel_4
	}
	return ""
}

// The certification for the product.
type Certification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the certification.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the certification body.
	Authority string `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	// A unique code to identify the certification.
	Code string `protobuf:"bytes,3,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Certification) Reset() {
	*x = Certification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certification) ProtoMessage() {}

func (x *Certification) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certification.ProtoReflect.Descriptor instead.
func (*Certification) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{1}
}

func (x *Certification) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Certification) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *Certification) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// The product details.
type ProductDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The section header used to group a set of product details.
	SectionName string `protobuf:"bytes,1,opt,name=section_name,json=sectionName,proto3" json:"section_name,omitempty"`
	// The name of the product detail.
	AttributeName string `protobuf:"bytes,2,opt,name=attribute_name,json=attributeName,proto3" json:"attribute_name,omitempty"`
	// The value of the product detail.
	AttributeValue string `protobuf:"bytes,3,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
}

func (x *ProductDetail) Reset() {
	*x = ProductDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductDetail) ProtoMessage() {}

func (x *ProductDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductDetail.ProtoReflect.Descriptor instead.
func (*ProductDetail) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{2}
}

func (x *ProductDetail) GetSectionName() string {
	if x != nil {
		return x.SectionName
	}
	return ""
}

func (x *ProductDetail) GetAttributeName() string {
	if x != nil {
		return x.AttributeName
	}
	return ""
}

func (x *ProductDetail) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

// The dimension of the product.
type ProductDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dimension value represented as a number. The value can have a
	// maximum precision of four decimal places.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The dimension units.
	// Acceptable values are:
	//   - "`in`"
	//   - "`cm`"
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ProductDimension) Reset() {
	*x = ProductDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductDimension) ProtoMessage() {}

func (x *ProductDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductDimension.ProtoReflect.Descriptor instead.
func (*ProductDimension) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{3}
}

func (x *ProductDimension) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ProductDimension) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The weight of the product.
type ProductWeight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The weight represented as a number. The weight can have a maximum
	// precision of four decimal places.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The weight unit.
	// Acceptable values are:
	//   - "`g`"
	//   - "`kg`"
	//   - "`oz`"
	//   - "`lb`"
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ProductWeight) Reset() {
	*x = ProductWeight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductWeight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductWeight) ProtoMessage() {}

func (x *ProductWeight) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductWeight.ProtoReflect.Descriptor instead.
func (*ProductWeight) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{4}
}

func (x *ProductWeight) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ProductWeight) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The status of the Css Product, data validation issues, that is,
// information about the Css Product computed asynchronously.
type CssProductStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intended destinations for the product.
	DestinationStatuses []*CssProductStatus_DestinationStatus `protobuf:"bytes,3,rep,name=destination_statuses,json=destinationStatuses,proto3" json:"destination_statuses,omitempty"`
	// A list of all issues associated with the product.
	ItemLevelIssues []*CssProductStatus_ItemLevelIssue `protobuf:"bytes,4,rep,name=item_level_issues,json=itemLevelIssues,proto3" json:"item_level_issues,omitempty"`
	// Date on which the item has been created, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	CreationDate *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Date on which the item has been last updated, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	LastUpdateDate *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_update_date,json=lastUpdateDate,proto3" json:"last_update_date,omitempty"`
	// Date on which the item expires in Google Shopping, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	GoogleExpirationDate *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=google_expiration_date,json=googleExpirationDate,proto3" json:"google_expiration_date,omitempty"`
}

func (x *CssProductStatus) Reset() {
	*x = CssProductStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CssProductStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CssProductStatus) ProtoMessage() {}

func (x *CssProductStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CssProductStatus.ProtoReflect.Descriptor instead.
func (*CssProductStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{5}
}

func (x *CssProductStatus) GetDestinationStatuses() []*CssProductStatus_DestinationStatus {
	if x != nil {
		return x.DestinationStatuses
	}
	return nil
}

func (x *CssProductStatus) GetItemLevelIssues() []*CssProductStatus_ItemLevelIssue {
	if x != nil {
		return x.ItemLevelIssues
	}
	return nil
}

func (x *CssProductStatus) GetCreationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationDate
	}
	return nil
}

func (x *CssProductStatus) GetLastUpdateDate() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateDate
	}
	return nil
}

func (x *CssProductStatus) GetGoogleExpirationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.GoogleExpirationDate
	}
	return nil
}

// The destination status of the product status.
type CssProductStatus_DestinationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the destination
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the aggregate offer is
	// approved.
	ApprovedCountries []string `protobuf:"bytes,2,rep,name=approved_countries,json=approvedCountries,proto3" json:"approved_countries,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the aggregate offer is
	// pending approval.
	PendingCountries []string `protobuf:"bytes,3,rep,name=pending_countries,json=pendingCountries,proto3" json:"pending_countries,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the aggregate offer is
	// disapproved.
	DisapprovedCountries []string `protobuf:"bytes,4,rep,name=disapproved_countries,json=disapprovedCountries,proto3" json:"disapproved_countries,omitempty"`
}

func (x *CssProductStatus_DestinationStatus) Reset() {
	*x = CssProductStatus_DestinationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CssProductStatus_DestinationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CssProductStatus_DestinationStatus) ProtoMessage() {}

func (x *CssProductStatus_DestinationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CssProductStatus_DestinationStatus.ProtoReflect.Descriptor instead.
func (*CssProductStatus_DestinationStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{5, 0}
}

func (x *CssProductStatus_DestinationStatus) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *CssProductStatus_DestinationStatus) GetApprovedCountries() []string {
	if x != nil {
		return x.ApprovedCountries
	}
	return nil
}

func (x *CssProductStatus_DestinationStatus) GetPendingCountries() []string {
	if x != nil {
		return x.PendingCountries
	}
	return nil
}

func (x *CssProductStatus_DestinationStatus) GetDisapprovedCountries() []string {
	if x != nil {
		return x.DisapprovedCountries
	}
	return nil
}

// The ItemLevelIssue of the product status.
type CssProductStatus_ItemLevelIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The error code of the issue.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// How this issue affects serving of the aggregate offer.
	Servability string `protobuf:"bytes,2,opt,name=servability,proto3" json:"servability,omitempty"`
	// Whether the issue can be resolved by the merchant.
	Resolution string `protobuf:"bytes,3,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// The attribute's name, if the issue is caused by a single attribute.
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// The destination the issue applies to.
	Destination string `protobuf:"bytes,5,opt,name=destination,proto3" json:"destination,omitempty"`
	// A short issue description in English.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// A detailed issue description in English.
	Detail string `protobuf:"bytes,7,opt,name=detail,proto3" json:"detail,omitempty"`
	// The URL of a web page to help with resolving this issue.
	Documentation string `protobuf:"bytes,8,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where issue applies to the
	// aggregate offer.
	ApplicableCountries []string `protobuf:"bytes,9,rep,name=applicable_countries,json=applicableCountries,proto3" json:"applicable_countries,omitempty"`
}

func (x *CssProductStatus_ItemLevelIssue) Reset() {
	*x = CssProductStatus_ItemLevelIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CssProductStatus_ItemLevelIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CssProductStatus_ItemLevelIssue) ProtoMessage() {}

func (x *CssProductStatus_ItemLevelIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_product_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CssProductStatus_ItemLevelIssue.ProtoReflect.Descriptor instead.
func (*CssProductStatus_ItemLevelIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP(), []int{5, 1}
}

func (x *CssProductStatus_ItemLevelIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetServability() string {
	if x != nil {
		return x.Servability
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetResolution() string {
	if x != nil {
		return x.Resolution
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *CssProductStatus_ItemLevelIssue) GetApplicableCountries() []string {
	if x != nil {
		return x.ApplicableCountries
	}
	return nil
}

var File_google_shopping_css_v1_css_product_common_proto protoreflect.FileDescriptor

var file_google_shopping_css_v1_css_product_common_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x15,
	0x0a, 0x0a, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x08,
	0x63, 0x70, 0x70, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x07, 0x63, 0x70, 0x70, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f,
	0x63, 0x70, 0x70, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0d, 0x63, 0x70, 0x70, 0x4d, 0x6f, 0x62, 0x69,
	0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10, 0x63, 0x70, 0x70,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x2a, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0e, 0x63, 0x70, 0x70, 0x41, 0x64, 0x73, 0x52, 0x65, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x09, 0x6c, 0x6f, 0x77, 0x5f,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x08, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x52, 0x09, 0x68, 0x69, 0x67, 0x68, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x2d,
	0x0a, 0x10, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x4f, 0x66, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a,
	0x18, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x04, 0x52, 0x16, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x14,
	0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x12, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x68,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x11, 0x68, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01,
	0x12, 0x40, 0x0a, 0x1a, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x17, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x88,
	0x01, 0x01, 0x12, 0x5e, 0x0a, 0x1d, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x1a, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x07, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a,
	0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x08, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01,
	0x01, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x19,
	0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a, 0x52,
	0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x70, 0x6e,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x03, 0x6d, 0x70, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x17, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c,
	0x52, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x24, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x0d, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x61,
	0x64, 0x75, 0x6c, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0e, 0x52, 0x05, 0x61, 0x64,
	0x75, 0x6c, 0x74, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x61, 0x63, 0x6b, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x48, 0x0f, 0x52, 0x09, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x70, 0x61, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x73, 0x5f,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x48, 0x10, 0x52, 0x08,
	0x69, 0x73, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x61,
	0x67, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x48, 0x11,
	0x52, 0x08, 0x61, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x12, 0x52, 0x05,
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x67, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x48, 0x13, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x48, 0x14, 0x52, 0x08, 0x6d, 0x61, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x48, 0x15, 0x52, 0x07, 0x70, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x1a, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x16, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x24,
	0x0a, 0x0b, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x17, 0x52, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0d, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x18, 0x52, 0x0b, 0x69, 0x74,
	0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x1e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x1f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x20, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x4d, 0x0a, 0x0d, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x21, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x22, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x18, 0x23, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x27, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x28, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x33,
	0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x2b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x2c, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x75, 0x73,
	0x65, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x19, 0x52, 0x05, 0x70, 0x61, 0x75, 0x73, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x5f, 0x30, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1a, 0x52, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x30, 0x88, 0x01, 0x01, 0x12, 0x29,
	0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x31,
	0x18, 0x2f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1b, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x32, 0x18, 0x30, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x1c, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x32, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x33, 0x18, 0x31, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1d, 0x52, 0x0c,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x33, 0x88, 0x01, 0x01, 0x12,
	0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x34, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1e, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x34, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x63,
	0x70, 0x70, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x70, 0x70, 0x5f,
	0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x13, 0x0a, 0x11, 0x5f,
	0x63, 0x70, 0x70, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x68,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x06, 0x0a, 0x04,
	0x5f, 0x6d, 0x70, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x67, 0x74, 0x69, 0x6e, 0x42, 0x1a, 0x0a,
	0x18, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x61, 0x64,
	0x75, 0x6c, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61, 0x63,
	0x6b, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x69, 0x73, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x67, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x42,
	0x0a, 0x0a, 0x08, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x30, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x31, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x32, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x33, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x34, 0x22,
	0x55, 0x0a, 0x0d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x46, 0x0a, 0x10, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x6e,
	0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x22, 0x43, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0xc4, 0x07, 0x0a, 0x10, 0x43, 0x73, 0x73,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x6d, 0x0a,
	0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x63, 0x0a, 0x11,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x16, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x1a, 0xc6, 0x01, 0x0a, 0x11, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x33,
	0x0a, 0x15, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x64,
	0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x1a, 0xb9, 0x02, 0x0a, 0x0e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x0a,
	0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x14,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x42,
	0xb7, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x15,
	0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x63, 0x73, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x73, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x73,
	0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x43, 0x73, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x3a, 0x3a, 0x43, 0x73, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_shopping_css_v1_css_product_common_proto_rawDescOnce sync.Once
	file_google_shopping_css_v1_css_product_common_proto_rawDescData = file_google_shopping_css_v1_css_product_common_proto_rawDesc
)

func file_google_shopping_css_v1_css_product_common_proto_rawDescGZIP() []byte {
	file_google_shopping_css_v1_css_product_common_proto_rawDescOnce.Do(func() {
		file_google_shopping_css_v1_css_product_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_css_v1_css_product_common_proto_rawDescData)
	})
	return file_google_shopping_css_v1_css_product_common_proto_rawDescData
}

var file_google_shopping_css_v1_css_product_common_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_shopping_css_v1_css_product_common_proto_goTypes = []interface{}{
	(*Attributes)(nil),                         // 0: google.shopping.css.v1.Attributes
	(*Certification)(nil),                      // 1: google.shopping.css.v1.Certification
	(*ProductDetail)(nil),                      // 2: google.shopping.css.v1.ProductDetail
	(*ProductDimension)(nil),                   // 3: google.shopping.css.v1.ProductDimension
	(*ProductWeight)(nil),                      // 4: google.shopping.css.v1.ProductWeight
	(*CssProductStatus)(nil),                   // 5: google.shopping.css.v1.CssProductStatus
	(*CssProductStatus_DestinationStatus)(nil), // 6: google.shopping.css.v1.CssProductStatus.DestinationStatus
	(*CssProductStatus_ItemLevelIssue)(nil),    // 7: google.shopping.css.v1.CssProductStatus.ItemLevelIssue
	(*typepb.Price)(nil),                       // 8: google.shopping.type.Price
	(*timestamppb.Timestamp)(nil),              // 9: google.protobuf.Timestamp
}
var file_google_shopping_css_v1_css_product_common_proto_depIdxs = []int32{
	8,  // 0: google.shopping.css.v1.Attributes.low_price:type_name -> google.shopping.type.Price
	8,  // 1: google.shopping.css.v1.Attributes.high_price:type_name -> google.shopping.type.Price
	8,  // 2: google.shopping.css.v1.Attributes.headline_offer_price:type_name -> google.shopping.type.Price
	8,  // 3: google.shopping.css.v1.Attributes.headline_offer_shipping_price:type_name -> google.shopping.type.Price
	2,  // 4: google.shopping.css.v1.Attributes.product_details:type_name -> google.shopping.css.v1.ProductDetail
	4,  // 5: google.shopping.css.v1.Attributes.product_weight:type_name -> google.shopping.css.v1.ProductWeight
	3,  // 6: google.shopping.css.v1.Attributes.product_length:type_name -> google.shopping.css.v1.ProductDimension
	3,  // 7: google.shopping.css.v1.Attributes.product_width:type_name -> google.shopping.css.v1.ProductDimension
	3,  // 8: google.shopping.css.v1.Attributes.product_height:type_name -> google.shopping.css.v1.ProductDimension
	1,  // 9: google.shopping.css.v1.Attributes.certifications:type_name -> google.shopping.css.v1.Certification
	9,  // 10: google.shopping.css.v1.Attributes.expiration_date:type_name -> google.protobuf.Timestamp
	6,  // 11: google.shopping.css.v1.CssProductStatus.destination_statuses:type_name -> google.shopping.css.v1.CssProductStatus.DestinationStatus
	7,  // 12: google.shopping.css.v1.CssProductStatus.item_level_issues:type_name -> google.shopping.css.v1.CssProductStatus.ItemLevelIssue
	9,  // 13: google.shopping.css.v1.CssProductStatus.creation_date:type_name -> google.protobuf.Timestamp
	9,  // 14: google.shopping.css.v1.CssProductStatus.last_update_date:type_name -> google.protobuf.Timestamp
	9,  // 15: google.shopping.css.v1.CssProductStatus.google_expiration_date:type_name -> google.protobuf.Timestamp
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_shopping_css_v1_css_product_common_proto_init() }
func file_google_shopping_css_v1_css_product_common_proto_init() {
	if File_google_shopping_css_v1_css_product_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductWeight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CssProductStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CssProductStatus_DestinationStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_product_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CssProductStatus_ItemLevelIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_css_v1_css_product_common_proto_msgTypes[0].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_css_v1_css_product_common_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_css_v1_css_product_common_proto_goTypes,
		DependencyIndexes: file_google_shopping_css_v1_css_product_common_proto_depIdxs,
		MessageInfos:      file_google_shopping_css_v1_css_product_common_proto_msgTypes,
	}.Build()
	File_google_shopping_css_v1_css_product_common_proto = out.File
	file_google_shopping_css_v1_css_product_common_proto_rawDesc = nil
	file_google_shopping_css_v1_css_product_common_proto_goTypes = nil
	file_google_shopping_css_v1_css_product_common_proto_depIdxs = nil
}
