#!/bin/bash
# Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
# HYPRE Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

# Generate code by for all implementations by invoking an awk program
#
# The script takes a prototype info file (generated by 'gen_proto_info.sh') and
# an output file prefix, then generates files prefix.c and prefix.h containing
# function implementations and prototypes for each line of prototype info.
#
# The last argument specifies the implementation to generate and takes values:
#   fixed, functions, pre
#
# Usage:   <this-script> <proto-info> <prefix> <type>
# Example: <this-script> mup.fixed.ext.proto mup_fixed_ext "fixed"

scriptdir=`dirname $0`

PFILE=$1
OUTC="$2.c"
OUTH="$2.h"
GEN=$3

echo "" > $OUTC
echo "" > $OUTH

awk -v gen=$GEN -v outc="$OUTC" -v outh="$OUTH" -f $scriptdir/gen_code.awk $PFILE

