
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_krylov.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABGetPrecondMatrix_flt( solver, precond_matrix_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABGetPrecondMatrix_dbl( solver, precond_matrix_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABGetPrecondMatrix_long_dbl( solver, precond_matrix_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetPrecondMatrix_flt( solver, precond_matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetPrecondMatrix_dbl( solver, precond_matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetPrecondMatrix_long_dbl( solver, precond_matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BiCGSTABSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BiCGSTABSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BiCGSTABSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precondT, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetPrecond_flt( solver, precond, precondT, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetPrecond_dbl( solver, precond, precondT, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetPrecond_long_dbl( solver, precond, precondT, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CGNRSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CGNRSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CGNRSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetCGS_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cgs )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetCGS_flt( solver, cgs );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetCGS_dbl( solver, cgs );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetCGS_long_dbl( solver, cgs );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetConverged_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *converged )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetConverged_flt( solver, converged );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetConverged_dbl( solver, converged );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetConverged_long_dbl( solver, converged );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetConvergenceFactorTol_flt( solver, (hypre_float *)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetConvergenceFactorTol_dbl( solver, (hypre_double *)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetConvergenceFactorTol_long_dbl( solver, (hypre_long_double *)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetLogging_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetLogging_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetLogging_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetUnroll_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *unroll )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESGetUnroll_flt( solver, unroll );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESGetUnroll_dbl( solver, unroll );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESGetUnroll_long_dbl( solver, unroll );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetCGS_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cgs )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetCGS_flt( solver, cgs );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetCGS_dbl( solver, cgs );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetCGS_long_dbl( solver, cgs );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetModifyPC_flt( solver, modify_pc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetModifyPC_dbl( solver, modify_pc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetModifyPC_long_dbl( solver, modify_pc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetUnroll_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int unroll )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetUnroll_flt( solver, unroll );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetUnroll_dbl( solver, unroll );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetUnroll_long_dbl( solver, unroll );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_COGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_COGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_COGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetConverged_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *converged )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetConverged_flt( solver, converged );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetConverged_dbl( solver, converged );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetConverged_long_dbl( solver, converged );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetConvergenceFactorTol_flt( solver, (hypre_float *)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetConvergenceFactorTol_dbl( solver, (hypre_double *)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetConvergenceFactorTol_long_dbl( solver, (hypre_long_double *)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetLogging_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetLogging_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetLogging_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESGetTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESGetTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESGetTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetModifyPC_flt( solver, modify_pc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetModifyPC_dbl( solver, modify_pc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetModifyPC_long_dbl( solver, modify_pc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FlexGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FlexGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FlexGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetAbsoluteTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetAbsoluteTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetAbsoluteTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetConverged_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *converged )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetConverged_flt( solver, converged );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetConverged_dbl( solver, converged );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetConverged_long_dbl( solver, converged );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetConvergenceFactorTol_flt( solver, (hypre_float *)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetConvergenceFactorTol_dbl( solver, (hypre_double *)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetConvergenceFactorTol_long_dbl( solver, (hypre_long_double *)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetLogging_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetLogging_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetLogging_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetPrecondMatrix_flt( solver, precond_matrix_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetPrecondMatrix_dbl( solver, precond_matrix_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetPrecondMatrix_long_dbl( solver, precond_matrix_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Vector *xref )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetRefSolution_flt( solver, xref );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetRefSolution_dbl( solver, xref );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetRefSolution_long_dbl( solver, xref );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetSkipRealResidualCheck_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *skip_real_r_check )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetSkipRealResidualCheck_flt( solver, skip_real_r_check );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetSkipRealResidualCheck_dbl( solver, skip_real_r_check );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetSkipRealResidualCheck_long_dbl( solver, skip_real_r_check );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESGetTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESGetTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESGetTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetPrecondMatrix_flt( solver, precond_matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetPrecondMatrix_dbl( solver, precond_matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetPrecondMatrix_long_dbl( solver, precond_matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Vector xref )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetRefSolution_flt( solver, xref );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetRefSolution_dbl( solver, xref );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetRefSolution_long_dbl( solver, xref );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetSkipRealResidualCheck_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int skip_real_r_check )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetSkipRealResidualCheck_flt( solver, skip_real_r_check );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetSkipRealResidualCheck_dbl( solver, skip_real_r_check );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetSkipRealResidualCheck_long_dbl( solver, skip_real_r_check );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetAugDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetAugDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetAugDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetAugDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetConverged_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *converged )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetConverged_flt( solver, converged );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetConverged_dbl( solver, converged );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetConverged_long_dbl( solver, converged );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetConvergenceFactorTol_flt( solver, (hypre_float *)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetConvergenceFactorTol_dbl( solver, (hypre_double *)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetConvergenceFactorTol_long_dbl( solver, (hypre_long_double *)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetLogging_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetLogging_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetLogging_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESGetTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESGetTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESGetTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetAugDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int aug_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetAugDim_flt( solver, aug_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetAugDim_dbl( solver, aug_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetAugDim_long_dbl( solver, aug_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetAbsoluteTolFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *abstolf )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetAbsoluteTolFactor_flt( solver, (hypre_float *)abstolf );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetAbsoluteTolFactor_dbl( solver, (hypre_double *)abstolf );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetAbsoluteTolFactor_long_dbl( solver, (hypre_long_double *)abstolf );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetConverged_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *converged )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetConverged_flt( solver, converged );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetConverged_dbl( solver, converged );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetConverged_long_dbl( solver, converged );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetConvergenceFactorTol_flt( solver, (hypre_float *)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetConvergenceFactorTol_dbl( solver, (hypre_double *)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetConvergenceFactorTol_long_dbl( solver, (hypre_long_double *)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetFinalRelativeResidualNorm_flt( solver, (hypre_float *)norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetFinalRelativeResidualNorm_dbl( solver, (hypre_double *)norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetFinalRelativeResidualNorm_long_dbl( solver, (hypre_long_double *)norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetFlex_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *flex )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetFlex_flt( solver, flex );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetFlex_dbl( solver, flex );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetFlex_long_dbl( solver, flex );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetPrecondMatrix_flt( solver, precond_matrix_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetPrecondMatrix_dbl( solver, precond_matrix_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetPrecondMatrix_long_dbl( solver, precond_matrix_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetResidualTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rtol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetResidualTol_flt( solver, (hypre_float *)rtol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetResidualTol_dbl( solver, (hypre_double *)rtol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetResidualTol_long_dbl( solver, (hypre_long_double *)rtol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetSkipBreak_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *skip_break )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetSkipBreak_flt( solver, skip_break );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetSkipBreak_dbl( solver, skip_break );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetSkipBreak_long_dbl( solver, skip_break );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetTol_flt( solver, (hypre_float *)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetTol_dbl( solver, (hypre_double *)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetTol_long_dbl( solver, (hypre_long_double *)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGGetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGGetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGGetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetAbsoluteTol_flt( solver, (hypre_float)a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetAbsoluteTol_dbl( solver, (hypre_double)a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetAbsoluteTol_long_dbl( solver, (hypre_long_double)a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetAbsoluteTolFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double abstolf )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetAbsoluteTolFactor_flt( solver, (hypre_float)abstolf );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetAbsoluteTolFactor_dbl( solver, (hypre_double)abstolf );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetAbsoluteTolFactor_long_dbl( solver, (hypre_long_double)abstolf );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetConvergenceFactorTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetConvergenceFactorTol_flt( solver, (hypre_float)cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetConvergenceFactorTol_dbl( solver, (hypre_double)cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetConvergenceFactorTol_long_dbl( solver, (hypre_long_double)cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetFlex_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int flex )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetFlex_flt( solver, flex );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetFlex_dbl( solver, flex );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetFlex_long_dbl( solver, flex );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrecondMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetPrecondMatrix_flt( solver, precond_matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetPrecondMatrix_dbl( solver, precond_matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetPrecondMatrix_long_dbl( solver, precond_matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPreconditioner_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver precond )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetPreconditioner_flt( solver, precond );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetPreconditioner_dbl( solver, precond );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetPreconditioner_long_dbl( solver, precond );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetRecomputeResidual_flt( solver, recompute_residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetRecomputeResidual_dbl( solver, recompute_residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetRecomputeResidual_long_dbl( solver, recompute_residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual_p )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetRecomputeResidualP_flt( solver, recompute_residual_p );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetRecomputeResidualP_dbl( solver, recompute_residual_p );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetRecomputeResidualP_long_dbl( solver, recompute_residual_p );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetResidualTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double rtol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetResidualTol_flt( solver, (hypre_float)rtol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetResidualTol_dbl( solver, (hypre_double)rtol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetResidualTol_long_dbl( solver, (hypre_long_double)rtol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetSkipBreak_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int skip_break )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetSkipBreak_flt( solver, skip_break );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetSkipBreak_dbl( solver, skip_break );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetSkipBreak_long_dbl( solver, skip_break );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetTol_flt( solver, (hypre_float)tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetTol_dbl( solver, (hypre_double)tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetTol_long_dbl( solver, (hypre_long_double)tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PCGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PCGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PCGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

