/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Sequence.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_SequencePurificationDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


class SequencePurificationDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT

  private:
  Ui::SequencePurificationDlg m_ui;

  bool m_firstRound;
  libXpertMassCore::Sequence *mpa_origSequence;
  QList<int> m_errorList;
  QTextDocument m_leftTextDocument;
  QTextDocument m_rightTextDocument;

  public:
  SequencePurificationDlg(SequenceEditorWnd *editorWnd,
                          /* no libXpertMassCore::Polymer **/
                          /* no libXpertMassCore::PolChemDef **/
                          const QString &settings_file_path,
                          const QString &application_name,
                          const QString &description,
                          libXpertMassCore::Sequence *sequence,
                          QList<int> *errorList);

  ~SequencePurificationDlg();

  bool initialize();

  void setupDocuments();

  void doTest(QTextDocument &);
  void setOrigText();
  bool findContinuum(QList<int> &list, int, int &);

  public slots:
  void purify();
  void test();
  void removeTagged();
  void reset();
};


} // namespace MassXpert
} // namespace MsXpS
