function getRandomWithinPercent(value, percent)
{
  // Calculate the % range
  const range = value * percent;

  // Calculate min and max bounds
  const min = value - range;
  const max = value + range;

  // Generate random number within the range
  return Math.random() * (max - min) + min;
}

function computeMz(mass, charge)
{
  let mz = 1;

  if (charge == 0)
  {
    mz = mass;
  }
  else
  {
    mz = mass / charge;
  }
  return mz
}

var seq_ed_wnd = progWnd.openSequence("/home/rusconi/devel/massxpert3/development/data/polSeqs/chicken-telokin.mxp");

polymer = seq_ed_wnd.getPolymer();
polymer.setLeftEndModifByName("Acetylation");

// Get the calculation options that we'll have to set.
calc_options = polymer.getCalcOptions();

// We know the protein is always acetylated, whatever the translation start site.

calc_options.setPolymerEntities(libXpertMassCore.Enums.ChemicalEntity.LEFT_END_MODIF | libXpertMassCore.Enums.ChemicalEntity.FORCE_LEFT_END_MODIF);
seq_ed_wnd.setCalcOptions(calc_options);

let phosphoserine_index = 12;
polymer.modifyMonomer(phosphoserine_index, "Phosphorylation", /*override*/ false);

cleavage_dlg = seq_ed_wnd.cleave()
cleavage_dlg.configureCleavage("CyanogenBromide",
  0 /*partials*/ ,
  1 /*start_ionize_level*/ ,
  1 /*stop_ionize_level*/ ,
  false /*should_embed_sequence*/ );

cleavage_dlg.setStackOligomers(true);

mass_peak_shaper_config_dlg = cleavage_dlg.configureMassPeakShaper();
mass_peak_shaper_config_dlg.setParameters(1000 /*reference_peak_mz*/,
  150 /*point_count*/ ,
  libXpertMassCore.Enums.MassPeakShapeType.GAUSSIAN,
  40000 /*resolution*/ ,
  0 /*fwhm*/ ,
  6 /*bin_size_divisor*/ ,
  false /*should_create_bins*/ );

// Craft a dictionary with all the start_index : stop_index of all the
// telokin species present in the mixture. We know the three start
// codons and the fact that the C-terminal sequence never has all the
// six C-terminal Glu residues.

// We also need to account for the 3 initiation start codons
// for the N-terminal peptide
// MAMISGMSGRK ASGSSPTSPINA
// 0         10           22
// let nterm_indices_list = [1, 2, 7];

let pep_indices_dict = {
  1: [150, 151, 152, 153, 154, 155],
  2: [150, 151, 152, 153, 154, 155],
  7: [150, 151, 152, 153, 154, 155]
};

intensity = 1e6;
let random_intensity = 0;

// We want to append the newly calculated oligomers to the previous ones.
cleavage_dlg.setStackOligomers(true);

// Without Phosphorylation
calc_options.setMonomerEntities(libXpertMassCore.Enums.ChemicalEntity.NONE);
seq_ed_wnd.setCalcOptions(calc_options);

for (let start_index in pep_indices_dict)
{
  print(start_index + "is:" + pep_indices_dict[start_index])

  for (let end_index of pep_indices_dict[start_index])
  {
    range_as_string = `[${start_index}-${end_index}]`;
    print(range_as_string)

    seq_ed_wnd.setIndexRanges(range_as_string, libXpertMassCore.Enums.LocationType.INDEX);
    calc_options.setIndexRange(start_index, end_index);
    // In that same article we saw that the peptide can be phosphorylated or not.

    cleavage_dlg.cleave();
  }
}

// With Phosphorylation on Ser12
calc_options.setMonomerEntities(libXpertMassCore.Enums.ChemicalEntity.MODIF);
seq_ed_wnd.setCalcOptions(calc_options);

for (let start_index in pep_indices_dict)
{
  print(start_index + "is:" + pep_indices_dict[start_index])

  for (let end_index of pep_indices_dict[start_index])
  {
    range_as_string = `[${start_index}-${end_index}]`;
    print(range_as_string)

    seq_ed_wnd.setIndexRanges(range_as_string, libXpertMassCore.Enums.LocationType.INDEX);
    calc_options.setIndexRange(start_index, end_index);
    // In that same article we saw that the peptide can be phosphorylated or not.

    cleavage_dlg.cleave();
  }
}

cleavage_dlg.selectAllTableViewRows();
mass_peak_shaper_config_widget = mass_peak_shaper_config_dlg.getConfigWidget();
mass_peak_shaper_config_widget.checkParameters();
cleavage_dlg.synthesizeMassSpectra();
