# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ImprintFilter(PolyDataAlgorithm):
    r"""
    ImprintFilter - Imprint the contact surface of one object onto
    another surface
    
    Superclass: PolyDataAlgorithm
    
    This filter imprints the contact surface of one PolyData mesh onto
    a second, input PolyData mesh. There are two inputs to the filter:
    the target, which is the surface to be imprinted, and the imprint,
    which is the object imprinting the target.
    
    A high level overview of the algorithm is as follows. 1) The target
    cells are segregated into two subsets: those that may intersect the
    imprint surface (the candidate cells determined by bounding box
    checks), and those that do not. 2) The non-candidates are sent to the
    output, the candidate intersection cells are further proceesed -
    eventually they will be triangulated as a result of contact with the
    imprint, with the result of the triangulation appended to the output.
    3) The imprint points are projected onto the candidate cells,
    determining a classification (on a target point, on a target edge,
    interior to a target cell, outside the target).  4) The non-outside
    imprint points are associated with one or more target cells.
    5) The imprint edges are intersected with the target cell edges,
       producing additional points associated with the the candidate
       cells, as well as "fragments" or portions of edges associated with
    the candidate target cells. 6) On a per-candidate-target-cell basis,
       the points and edge fragments associated with that cell are used
       to triangulate the cell.
    7) Finally, the triangulated target cells are appended to the output.
    
    Several options exist toSpecify whether to produce an output cell
    data array that indicates whether the output cells are in the
    imprinted area. If enabled, this output CharArray will have a
    value=1 for cells that are in the imprinted area. Otherwise, the
    value=0 is indicating the cell is not in contact with the imprinted
    area. The name of this cell data array is "imprinted_cells".
    
    Some notes:
    -- The algorithm assumes that the input target and imprint cells are
       convex.
    -- If performing a PROJECTED_IMPRINT, the output is the imprint mesh
       with the point coordinates modified by projecting the imprint
       points onto the target. If the profection of an imprint point onto
    the target is unsuccessful, the imprint point coordinates are not
       modified.
    -- If performing a MERGED_IMPRINT, the number of output points is
       (numtarget_pts + numimprint_pts + numedge_int_pts).
    -- Not all of the output points may be used, for example if an
       imprint point is coincident (within the tolerance) of a target
       point, the target point replaces the imprint point.
    -- Candidate cells which may reside within the bounding box of the
       imprint but may not actually intersect the imprint will be
       appended to the output without triangulation.
    -- Candidate cells that are intersected will be triangulated: i.e.,
       triangles will be produced and appended to the output.
    -- Triangulation requires combining the points and edge fragments
       associated with each target candidate cell, as well as the
       candidate cell's defining points and edges, to produce the final
       triangulation.
    -- Portions of the algorithm are SMP threaded. For example, steps #1
       and #2 (candidate segregation); point projection step #3; cell
       triangulation step #6. Future implementations may further
       parallelize the algorithm.
    -- The algorithm produces an output cell data array that indicates
       which output cells are in the imprinted area. This CharArray
       has a value=0 for cells that were originally target cells; a
       value=2 for output cells that are in the imprinted region; and a
       value=1 for cells that are in the transition region (between
       target and imprinted cells). The name of this cell data array is
       "imprinted_cells".
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImprintFilter, obj, update, **traits)
    
    boundary_edge_insertion = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether to insert just the boundary edges of the imprint
        mesh (i.e., do not insert the interior edges). (Boundary edges
        are mesh edges used by exactly one cell.) If inserting boundary
        edges, the imprint operation is similar to a cookie cutter
        operation. By default, boundary edge insertion is off.
        """
    )

    def _boundary_edge_insertion_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryEdgeInsertion,
                        self.boundary_edge_insertion_)

    triangulate_output = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether the output should be triangulated. By default
        (i.e., triangulate_output_off) the imprint cells, if not triangles
        nor intersect target cell boundaries, will not be triangulated.
        (Cells in the transition region are always triangulated because
        they are typically concave.)
        """
    )

    def _triangulate_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTriangulateOutput,
                        self.triangulate_output_)

    debug_output_type = tvtk_base.RevPrefixMap({'no_debug_output': 0, 'triangulation_input': 1, 'triangulation_output': 2}, default_value='no_debug_output', desc=\
        r"""
        The following methods support debugging. By default,
        NO_DEBUG_OUTPUT is produced and the second output of this filter
        is empty. If TRIANGULATION_INPUT is set, then the input points
        and edges contained by the target debug_cell_id are output to the
        second output to this filter.  If TRIANGULATION_OUTPUT is set,
        then the output triangulation for the specified target cellId is
        placed in a second output to this filter.
        """
    )

    def _debug_output_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDebugOutputType,
                        self.debug_output_type_)

    merge_tolerance_type = tvtk_base.RevPrefixMap({'min_edge': 2, 'absolute': 0, 'relative_to_projection': 1}, default_value='min_edge', desc=\
        r"""
        Specify a tolerance which is used to determine whether two points
        are considered coincident to one another. This is important when
        performing intersections and projections to reduce numerical
        issues.
        """
    )

    def _merge_tolerance_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergeToleranceType,
                        self.merge_tolerance_type_)

    output_type = tvtk_base.RevPrefixMap({'merged_imprint': 5, 'imprinted_cells': 1, 'imprinted_region': 3, 'projected_imprint': 2, 'target_cells': 0}, default_value='merged_imprint', desc=\
        r"""
        Control what is output by the filter. This can be useful for
        debugging or to extract portions of the data. The choices are:
        TARGET_CELLS - output the target cells in contact (relative to
        the tolerance) of the imprint mesh; IMPRINTED_CELLS - output the
        target's imprinted cells after intersection and triangulation
        with the imprint mesh; PROJECTED_IMPRINT - project the imprint
        mesh onto the target mesh, modififying the imprint mesh point
        coordinates to lie on the target mesh; IMPRINTED_REGION - extract
        just the area of contact between the target and imprint; and
        MERGED_IMPRINT - merge the target and imprint mesh after the
        imprint operation. By default, MERGED_IMPRINT is produced.
        """
    )

    def _output_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputType,
                        self.output_type_)

    debug_cell_id = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        The following methods support debugging. By default,
        NO_DEBUG_OUTPUT is produced and the second output of this filter
        is empty. If TRIANGULATION_INPUT is set, then the input points
        and edges contained by the target debug_cell_id are output to the
        second output to this filter.  If TRIANGULATION_OUTPUT is set,
        then the output triangulation for the specified target cellId is
        placed in a second output to this filter.
        """
    )

    def _debug_cell_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDebugCellId,
                        self.debug_cell_id)

    def _get_imprint_connection(self):
        return wrap_vtk(self._vtk_obj.GetImprintConnection())
    def _set_imprint_connection(self, arg):
        old_val = self._get_imprint_connection()
        self._wrap_call(self._vtk_obj.SetImprintConnection,
                        deref_vtk(arg))
        self.trait_property_changed('imprint_connection', old_val, arg)
    imprint_connection = traits.Property(_get_imprint_connection, _set_imprint_connection, desc=\
        r"""
        
        """
    )

    merge_tolerance = traits.Trait(0.025, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _merge_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergeTolerance,
                        self.merge_tolerance)

    def _get_target_connection(self):
        return wrap_vtk(self._vtk_obj.GetTargetConnection())
    def _set_target_connection(self, arg):
        old_val = self._get_target_connection()
        self._wrap_call(self._vtk_obj.SetTargetConnection,
                        deref_vtk(arg))
        self.trait_property_changed('target_connection', old_val, arg)
    target_connection = traits.Property(_get_target_connection, _set_target_connection, desc=\
        r"""
        
        """
    )

    tolerance = traits.Trait(0.001, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a projection tolerance which controls how close the
        imprint surface must be to the target to successfully imprint the
        surface. This is an absolute value.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_debug_output(self):
        return wrap_vtk(self._vtk_obj.GetDebugOutput())
    debug_output = traits.Property(_get_debug_output, desc=\
        r"""
        Get the output data (in the second output, if the debug_output !=
        NO_DEBUG_OUTPUT).
        """
    )

    def _get_imprint(self):
        return wrap_vtk(self._vtk_obj.GetImprint())
    imprint = traits.Property(_get_imprint, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_target(self):
        return wrap_vtk(self._vtk_obj.GetTarget())
    target = traits.Property(_get_target, desc=\
        r"""
        
        """
    )

    def set_imprint_data(self, *args):
        """
        set_imprint_data(self, imprint:DataObject) -> None
        C++: void set_imprint_data(DataObject *imprint)
        Specify the a second PolyData input which defines the surface
        mesh with which to imprint the target (i.e., the first input).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetImprintData, *my_args)
        return ret

    def set_target_data(self, *args):
        """
        set_target_data(self, target:DataObject) -> None
        C++: void set_target_data(DataObject *target)
        Specify the first PolyData input which defines the surface
        mesh to imprint (i.e., the taregt). The imprint surface is
        provided by the second input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTargetData, *my_args)
        return ret

    _updateable_traits_ = \
    (('boundary_edge_insertion', 'GetBoundaryEdgeInsertion'),
    ('triangulate_output', 'GetTriangulateOutput'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('debug_output_type',
    'GetDebugOutputType'), ('merge_tolerance_type',
    'GetMergeToleranceType'), ('output_type', 'GetOutputType'),
    ('debug_cell_id', 'GetDebugCellId'), ('merge_tolerance',
    'GetMergeTolerance'), ('tolerance', 'GetTolerance'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'boundary_edge_insertion', 'debug',
    'global_warning_display', 'release_data_flag', 'triangulate_output',
    'debug_output_type', 'merge_tolerance_type', 'output_type',
    'debug_cell_id', 'merge_tolerance', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImprintFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImprintFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['boundary_edge_insertion', 'triangulate_output'],
            ['debug_output_type', 'merge_tolerance_type', 'output_type'],
            ['debug_cell_id', 'merge_tolerance', 'tolerance']),
            title='Edit ImprintFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImprintFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

