# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLInstanceCulling(Object):
    r"""
    OpenGLInstanceCulling - Frustum culling and LOD management.
    
    Superclass: Object
    
    This class is used to cull instances based on their transformation
    matrix. It was designed to improve performances when there is large
    number of instances in OpenGLGlyph3DMapper.
    
    Each instance is tested on the GPU through vertex shader to know if
    it is inside of the frustum view. If it is, the distance to the
    camera is computed to select and send to the geometry shader the
    corresponding LOD index. The geometry shader register the instance to
    the corresponding vertex stream and therefore the corresponding
    transform feedback buffer in video memory.
    
    @warning   GL_ARB_gpu_shader5 extension is required.
    
    {.cpp}
    
    Newculling; IdType nbInstances = 1000000;
    
    // buffer of size 16*nbInstances containing transform matrices.
    OpenGLBufferObject* bufferMatrix = ...;
    
    // buffer of size 4*nbInstances containing color buffer to pass
    through. OpenGLBufferObject* bufferColor = ...;
    
    // Initialize LODs culling->init_lod(polydata); // LOD0 : full
    geometry culling->add_lod(2.0, 0.5); // LOD1 : after 2.0, 50%
    triangles culling->add_lod(5.0, 0.99); // LOD2 : after 5.0, 1%
    triangles
    
    // Build shader and binds culling->build_culling_shaders(ren, actor,
    nbInstances); culling->run_culling_shaders(nbInstances, bufferMatrix,
    bufferColor);
    
    // Get number of instances in LOD 0 int nbinst_in_lod0 =
    culling->get_lod(0).number_of_instances;
    
    // Get VBO and IBO of LOD 1 OpenGLBufferObject* VBO1 =
    culling->get_lod(1).position_vbo; OpenGLBufferObject* IBO1 =
    culling->get_lod(1).IBO;
    
    // Get instances buffer of LOD 2 // buffer is interleaved [
    transformMatrix0 color0 transformMatrix1 color1 ... ]
    OpenGLBufferObject* buffer2 = culling->get_lod_buffer(2);
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLInstanceCulling, obj, update, **traits)
    
    color_lod = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Overload color with unique color per LOD.
        """
    )

    def _color_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorLOD,
                        self.color_lod)

    def _get_helper(self):
        return wrap_vtk(self._vtk_obj.GetHelper())
    helper = traits.Property(_get_helper, desc=\
        r"""
        Get helper structure.
        """
    )

    def get_lod_buffer(self, *args):
        """
        get_lod_buffer(self, index:int) -> OpenGLBufferObject
        C++: OpenGLBufferObject *get_lod_buffer(IdType index)
        Get the transform feedback buffer generated by the culling
        program.
        """
        ret = self._wrap_call(self._vtk_obj.GetLODBuffer, *args)
        return wrap_vtk(ret)

    def _get_number_of_lod(self):
        return self._vtk_obj.GetNumberOfLOD()
    number_of_lod = traits.Property(_get_number_of_lod, desc=\
        r"""
        Get number of LOD currently declared.
        """
    )

    def add_lod(self, *args):
        """
        add_lod(self, distance:float, targetReduction:float) -> None
        C++: void add_lod(float distance, float targetReduction)
        Add a level of detail. distance is the distance after which LOD
        is enabled targetReduction is the reduction factor applied on
        polydata (vtkdecimate_pro is used)
        
        @sa DecimatePro::SetTargetReduction
        """
        ret = self._wrap_call(self._vtk_obj.AddLOD, *args)
        return ret

    def build_culling_shaders(self, *args):
        """
        build_culling_shaders(self, cache:OpenGLShaderCache,
            numInstances:int, withNormals:bool) -> None
        C++: void build_culling_shaders(OpenGLShaderCache *cache,
            IdType numInstances, bool withNormals)
        Build culling shader program (if not created yet) and binds it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildCullingShaders, *my_args)
        return ret

    def init_lod(self, *args):
        """
        init_lod(self, pd:PolyData) -> None
        C++: void init_lod(PolyData *pd)
        Initialize LOD with a polydata
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitLOD, *my_args)
        return ret

    def run_culling_shaders(self, *args):
        """
        run_culling_shaders(self, numInstances:int,
            matrixBuffer:OpenGLBufferObject,
            colorBuffer:OpenGLBufferObject,
            normalBuffer:OpenGLBufferObject) -> None
        C++: void run_culling_shaders(IdType numInstances,
            OpenGLBufferObject *matrixBuffer,
            OpenGLBufferObject *colorBuffer,
            OpenGLBufferObject *normalBuffer)
        Run the culling program and generate LOD buffers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RunCullingShaders, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('color_lod', 'GetColorLOD'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'color_lod'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLInstanceCulling, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['color_lod']),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

