# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ThreeDLinearGridPlaneCutter(DataObjectAlgorithm):
    r"""
    ThreeDLinearGridPlaneCutter - fast plane cutting of
    UnstructuredGrid containing 3D linear cells
    
    Superclass: DataObjectAlgorithm
    
    ThreeDLinearGridPlaneCutter is a specialized filter that cuts an input
    UnstructuredGrid consisting of 3D linear cells: tetrahedra,
    hexahedra, voxels, pyramids, and/or wedges. (The cells are linear in
    the sense that each cell edge is a straight line.)  The filter is
    designed for high-speed, specialized operation. All other cell types
    are skipped and produce no output.
    
    To use this filter you must specify an input unstructured grid or
    CompositeDataSet (containing unstructured grids) and a plane to
    cut with.
    
    The filter performance varies depending on optional output
    information. Basically if point merging is required (when
    point_merging is set) a sorting process is required to eliminate
    duplicate output points in the cut surface. Otherwise when point
    merging is not required, a fast path process produces independent
    triangles representing the cut surface.
    
    This algorithm is fast because it is threaded, and may perform
    operations (in a preprocessing step) to accelerate the plane cutting.
    
    Because this filter may build an initial data structure during a
    preprocessing step, the first execution of the filter may take longer
    than subsequent operations. Typically the first execution is still
    faster than Cutter (especially with threading enabled), but for
    certain types of data this may not be true. However if you are using
    the filter to cut a dataset multiple times (as in an exploratory or
    interactive workflow) this filter works well.
    
    @warning
    When the input is of type CompositeDataSet the filter will process
    the unstructured grid(s) contained in the composite data set. As a
    result the output of this filter is then a MultiBlockDataSet
    containing multiple PolyData. When a UnstructuredGrid is
    provided as input the output is a single PolyData.
    
    @warning
    Input cells that are not of 3D linear type (tetrahedron, hexahedron,
    wedge, pyramid, and voxel) are simply skipped and not processed.
    
    @warning
    The filter is templated on types of input and output points, and
    input scalar type. To reduce object file bloat, only real points
    (float,double) are processed.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    Cutter FlyingEdgesPlaneCutter PlaneCutter Plane
    SphereTree Contour3DLinearGrid
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtk3DLinearGridPlaneCutter, obj, update, **traits)
    
    compute_normals = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the computation of normals. The normal generated is
        simply the cut plane normal. The normal, if generated, is defined
        by cell data associated with the output polygons. By default
        computing of normals is off.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    interpolate_attributes = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to interpolate input attributes onto the cut
        plane. By default this option is on.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    merge_points = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether to merge coincident points. Merging can take
        extra time and produces fewer output points, creating a
        "watertight" output surface. On the other hand, merging reduced
        output data size and may be just as fast especially for smaller
        data. By default this is off.
        """
    )

    def _merge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePoints,
                        self.merge_points_)

    sequential_processing = tvtk_base.false_bool_trait(desc=\
        r"""
        Force sequential processing (i.e. single thread) of the
        contouring process. By default, sequential processing is off.
        Note this flag only applies if the class has been compiled with
        VTK_SMP_IMPLEMENTATION_TYPE set to something other than
        Sequential. (If set to Sequential, then the filter always runs in
        serial mode.) This flag is typically used for benchmarking
        purposes.
        """
    )

    def _sequential_processing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSequentialProcessing,
                        self.sequential_processing_)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        r"""
        Inform the user as to whether large ids were used during filter
        execution. This flag only has meaning after the filter has
        executed. Large ids are used when the id of the larges cell or
        point is greater than signed 32-bit precision. (Smaller ids
        reduce memory usage and speed computation. Note that large_ids are
        only available on 64-bit architectures.)
        """
    )

    def _get_number_of_threads_used(self):
        return self._vtk_obj.GetNumberOfThreadsUsed()
    number_of_threads_used = traits.Property(_get_number_of_threads_used, desc=\
        r"""
        Return the number of threads actually used during execution. This
        is valid only after algorithm execution.
        """
    )

    def can_fully_process_data_object(self, *args):
        """
        can_fully_process_data_object(object:DataObject) -> bool
        C++: static bool can_fully_process_data_object(DataObject *object)
        Returns true if the data object passed in is fully supported by
        this filter, i.e., all cell types are linear. For composite
        datasets, this means all dataset leaves have only linear cell
        types that can be processed by this filter.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanFullyProcessDataObject, *my_args)
        return ret

    _updateable_traits_ = \
    (('compute_normals', 'GetComputeNormals'), ('interpolate_attributes',
    'GetInterpolateAttributes'), ('merge_points', 'GetMergePoints'),
    ('sequential_processing', 'GetSequentialProcessing'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normals', 'debug',
    'global_warning_display', 'interpolate_attributes', 'merge_points',
    'release_data_flag', 'sequential_processing',
    'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ThreeDLinearGridPlaneCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ThreeDLinearGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normals', 'interpolate_attributes', 'merge_points',
            'sequential_processing'], [], ['output_points_precision']),
            title='Edit ThreeDLinearGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ThreeDLinearGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

