--TEST--
bcpow() function with large numbers
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$exponents = ["252", "-112"];
$baseNumbers = array_merge($exponents, [
    "14.14",
    "-16.60",
    "0.15",
    "-0.01",
    "15151324141414.412312232141241",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "-132132245132134.1515123765412",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
]);

run_bcmath_tests($baseNumbers, $exponents, "**", bcpow(...));

?>
--EXPECT--
Number "252" (scale 0)
252 ** 252                            = 142212010733424647125806541813713973266552845448041013743767421605354690415544328196152173390963803494710443230142152775687771944805429044982729796870857181947776572826160793933424942988750037827638341986183789792079484880609013515717131451507203060282065264043070502125106179548342207047711204933650239424460841202157152719662980652213693426926863084348529493037513389175805577626219903234384208039735661457745854089305800218117427842428649306815115886661640301037762482527923343983853507875264930793965916131347421096416232894153340276842687468868552274843085150094307684610419227652811804917758213226496
252 ** -112                           = 0

Number "-112" (scale 0)
-112 ** 252                            = 2528958559509291693508169626548016243760525615786379976651267082288161074806837567146354242426675448089179587223689918667106749284121965637887934532709154725528081671334320643858146400820666287506930741579829377389324701928200642059190071982670723834096616484481264403390509754202256821825886418273918096647296731861068941003342202311747852949747419032091731983573265045376333262301085406296848909763397511959941544798830761308589095475080050282796818166220650002245272286955283850226653729461037771414650027776147456
-112 ** -112                           = 0

Number "14.14" (scale 0)
14.14 ** 252                            = 81893830287657387446140079713887806093576884288543703328783802176508922753380870094003376900318176725198165627317176488631295332728458521626072637389422651709754634844150191850264235770478926203337416116264674564206565124289082609409927041547210316199545928823591027686585730497632744792533
14.14 ** -112                           = 0

Number "-16.60" (scale 0)
-16.60 ** 252                            = 29325011162031531635050775473043742335712717807162139294189975794596377719994688259393390430325862997866008694776131070878139493075620575422701181905723221059535177378476880731856824922247604302185770818227621273103971150596854313288134126369153196254990016237048145067458027194360617116808917107675683822643
-16.60 ** -112                           = 0

Number "0.15" (scale 0)
0.15 ** 252                            = 0
0.15 ** -112                           = 189574092538418764958341193234367215745086742520818271114560854632390900314942322598922704092

Number "-0.01" (scale 0)
-0.01 ** 252                            = 0
-0.01 ** -112                           = 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

Number "15151324141414.412312232141241" (scale 0)
15151324141414.412312232141241 ** 252                            = 2975421749795666718292864311407249970705086081437807395789379168718267809761515926216519710525556923711393180871882349125480337759668727402072958238900666362552341750552695988372017271582392491705356316948514737089205360282499880482512926893561832567935188520485154057479922893292233844872682027689029924296957873832086320362860520134654280058518517337570653996385278714198685752823835453817905306636319703719003676343516921560023010996505106467350842109482615346014981820723775172695392986401597801626150692206539756529644889137926049906575290564959396735953680592250779460130816876807757766338263686270020029393453575181327870591265373834140347848891333472452106266668645850397235968389042220027274496640159090815418483309643657324273121448493101717217140617069517287371864653153681358830190414615833078002577453411141597016583358385430394744450538495805740402488576124870572258200605831119008100984519684993455060646872766261382240383564392178883974453450433114215183488267147681395487265404247208352661495181304031822061114406175030677886104508679211172804603630316447723815907701460914622481206853022006681302191940743481903991732602477879503644713688600025822484351386994709104484371310424352144611218737196401824457866949669228902625541115988570606278592188602331451576075786613348336629409301707863923798082511203519536680273830467529869070112013346223720130183581189201489843066803035998524636580843999168622007134798723860720169157200004627398709928941733609441557160972211113022692009799237864185615460855228045985383589616750868474559577038584404446390706055987175018852877810774653462856565006598191028334508282011970034047209214176244147503985386832987247129380772291221015035166871079932982021644848487302418889155646720341011763574205760582552545432674974794783974025401318074084939141860755094923101801284442989344181743012614781021983935394731085008059924819771193595363859258571474767439534580638568746666210621240873673676940762489862112336626521441471577301366647762037305798100798711822457474507172500970023127288841824797039587587687760406935930088932018738492033507792817250533066953710174207685876451854460620309225706829752706450285622677922594957647037672524232255747269667789144401086986842640538153043741101238245322300993710394384754508967946211337487952324876892016919924636143376046118565299301806000686710931777881411145696867371682466218379864851343043041312758162391699150775018231599537746501756924961427444527995061269251565547747098676254156910141573235165420989417824245466381006116578002121746837672733849938657667872006918460874232266046864354612969306512425002050502769904919642157609172541701550215596501139800180259552618049103708500764672848369198536220300039766241517053637402993685274740246644140211865650547971680391614831119804648079596819224703795536455681460692071824945358084847698465553826334065350185771802401947633785300181386909348829848309501929340612695571623266869616638304357843374880496058625355636022120527400443841025788264209843812042625792300865583082505414465908017500188208987693716855836263772885824776988984333362684311002647195832946927199653846403980218407171091513992332604667414925751436017212580993860794349764631915036822374405575551253454423848395310883501116565831195963321659796880685759075194666868292856205113353111159407896940446955956749209
15151324141414.412312232141241 ** -112                           = 0

Number "141241241241241248267654747412" (scale 0)
141241241241241248267654747412 ** 252                            = 61702737614252266948752156824258824995959599972302320510716529982037298313739133760034183411877915226877565852198668440669791795617272708708492070599904800132098399232978789534072748261835151242629120913793827710449864804330737116696282852494151262231643262037509694372134135894276508967194766869889867303622326767458055285775054658565704105389065774707528077134226867060689181155582362175947504766959470020293226474023546968232460082444503912720021117368360386834444296061143129153351909427031876573177512880122064185569107842900553293550154759961105705458193916741180207197209621223094253214396769871913256823886396746414009606236401337641975159583111263046921277256870910247139612445619959067659323246784229705879779504519921968053141823090638689328500711053428918278999419825533334808914479125124304786443895285883492931266287931531729858829237461074566895486671242348082833878884776228517928133923449282430038745609287058924814413730985957861336607098992582653851368483642246306509531450226330989261394231526444743678146424987980458014955926233473826334115019067286145968725016152043997048698852555649504111446712360855837865476980303396801134199935075659852802884819197423764473479086847306010829721607657507579637914756242599185804487547475812412827298700399642854781876339506969947557967510353980827513717983184885292080872213577420468280210432294624241752834053309219199045973319521987975932929891565623163042217388611918307622483024452293173783579391106196420370018442330967765451700900306909737464257886906607274005552053888483483054020641145694539605337937744331035605313696665428737416632101002639001569789365490404722602805032116136122275148638414611401101532057194278420768914301864998398142593349158088898737725867540737097890425196584907775942120540985239557579236871185430362654320129291837576497911030976672546705634824923076862019595021475580215199988383732424366096745105419692283398918642003304826916218038854944067948189983518814346644870415937764601253868517196737959263980145504426078052198314663327843039356842201353163719488533902336353096176525901730253653712920740921897375508115858541406566947578335604123685577167716291169069652779908723297589735946583152466623845488142430700731769152222928283344575334939855201356733293357748709762620500872007205341239109409378799478441798933979724812650664098561233648811173269759247319678281986289749980800969619374582248288309266623507972587507556836064440726974305255199923316929818005467224051058298675312384426804897772240949920506431569837490498738453686746046335084609377713999742753257733912005654985684955512755879419270408315204048723476100838206401604215791253443838837275686487522888505399721610616356437415942085415265887671279570399360491649770978544857086906535678225672378863908117400571273280456942553369722415886814734827811782754510807365782422375263311630528352008474205547181623751728827140229718189606400373948548748620058632906237446487461463924934038124060220073591275626363882021308939573471462771350670733259367229333311304626874470724822013347119651171746131956616787517406892676075170382597409056665459502450515715507008118773500106516262784295667877075894103798253576492873141052750983781150748301119099230755964674235471935040610571173788486284126167436426267511157335062848567544617136701036212286420938449059910123857126789600929537328019086612659111870130906758076250376040429753144954758559356615713330390937898173091733151870035205661876454153260289142884914806807421852435737887997788694746400471112311576221296382603532103910277379683106908049352464276556594523117986718023572377990452537890518505167077689962380643979739773271443338742938727262511258728095020188473504370112836853749915575721872419520821790251159556333443030459056638192775423075084514851738672355958336265015380193591541922572518272773045049968850063625505732261611074622474965936400258314638193512375533757871806804692087708082031597721541387274042872955965737015089791668860525425793056778509470752578481376934088995106166553613693981904966686690212955481430046830913629928245843069361759411764297658217897316455217217021684202563946301505904193890271187899540947054172542875489231623713315378660419455411924354406330626224728228155305799300626640774404377831301051311563284401393151464407836422401342988060834178957138740247616789909739231830346449366019203847401064438442628508720077238078363655382024999197911442576806729689998326498342414751123237684542163876848231535744093508827210033685403359485309410368756619655335647815457456271662771356876949346139750604173629577681834134842499790368833444683342223857503185849902689436294823704067138925427306607192910954091698318729347145907800382668086667899534178563329442767437901814888337083677115243233418029978664046416826126543919629091736900005600339085979551469129407326751494940405612077593337217212627875249494414287211237336394051868492049328715249941706898117243520077930496903083255415280985218820687648161267600024140589397356281610905118704267436760893073994318473316685154852928135755455009702456043054322286620596648587752781151951829993681040341917550141278881598811594525627199147969934315163608714206891254146576331437603057409575204473025499304932390635935053481842967808825955521225903532223710955029023291335271704387554010604494359260592752707638749226503894251533287510138743058143563627083333323467953930288323174099691963642626244047994212921019096440748326461891434713107878328347627128553535347757109535162399519267201671099780388509076162219198648438104874056150803718036255353941654576267453857313032960105282442901730781706849116468293203141632905459414497264691251443801343872064950763335362229179456002525747120895247485013820030787875667079177283909056955331506973886798132875485898886780825156590108516771255757929317588856294114876639328139025640209294004084324019087271465180464949662380290646689899281765951368313154956095080011378907737551290670716282657109905603462006701850544998109045986412695185702298097876768249839078776688511467326239283983098509833719622936353377241972069901941714532498768716115868591570677576564417673178096539225866975241748028970361222145947727863536827216898514621847057819434576609230609611433988111992050578257972824282582096472184583048169498234433362074234852397751092471572561447915858864173251918950055149910352613561842701231235991010567523708933526326914146617809092162785366466356881319331412699810698600005749537204138000103625418561709921211393425978474528008482773381566071958815629154952129819071276958851406185526598276525973924382616619638927391896061767984462316342879485215181167142278283860974122393376129042592163052368958562549536015824310093694746026464275365131184771894447337638915074864139725976487382152380756354201968249702096723240570755670245536167613452904133125178947690742699517259032210148920215799181139024035965215646290857562866703810691715946409991609804815076179410873897787742683601227701850554553822077038999133518015046632371381193916753753001215985430108776610861216333105848176092629616183087158890392572221891278673318821093507423533826286478376277706846738214944276585022159559546442701466991751438781940501472267762449963577519763912275982471063234586863118222911568589623962096407513817772511232500343850038909537966015828523715127021508912585417674924982540682182384350779611171081429430780526138025312256
141241241241241248267654747412 ** -112                           = 0

Number "-149143276547656984948124912" (scale 0)
-149143276547656984948124912 ** 252                            = 55992175588333605542254063511278186461754574279839591709604310477562564689608443402403312222078711893971235561416950804719506082702379684733623971919408777114548100892216614108951324353246556535017960316014312222959702094808816331434094822650280427440063882576116695336500221646817757077369708529723823620336810350659576930581023887896886330503478109619863448515840946841190553234682382107049366084010115954164628751537372573754962628376851714140066914283347218349289869214926741444216767437164014398845666639858144658260377876458100579298055950974326675298651898083944350131609483093051504290661822668587661388602474880915186436725755772988399461893678236514411268113165984474267116617738961793643422894941375678592236663229748980138556108251262049269924802865828570213870281755635578142765872996532114681632125265545602095618091845037482357075517681870091778157619627960547482657474217943178159685376848804852485477702194998676631497601923456769896045663194900447061246337026655179495322126687564510781039271062988745945476519142221837023581656486042843501094480484668735886050383956287988798135101996785626705798462084512791858856000486173266205660052015961534265640905209313211125294627662693933297211009401491531951462889268507817897027972228709128736864008707571464724272762871838758126048184870005667275664845553774616604225572310912906152876060860153081105424979281592600839984125772468965874379832364640972866833334251698542584896314049237205644695553901317638647614318787708386467733615459065054365995897250270550067664267902152593317177099901109073008588486059511534052232495744462484660835773139005865467174339411663680328459135341612957853618227176487790111649236830978394018719354265785673205669861260376582410982507319458447629229410566850388275381698880420276787659514779189425772384786376987076804655929761620083736939837925917040082332479217674557289518688000706235667753826358380348450542285250406537012741099810396394118895119698580737840025778922487867828224721621696636134003638036732306141123387999132026332818408631403997196873195235009010958949928160436198665838441080496516462280678580659979676597569859757823014996017746962217866836145864024569035599176373962484096890443265839324221819146344682358316417403925617439797384999832590030653638024893217809739723987689363496190587792737138664106310356621671611551929705606372447129233289185995118668079125240237102990263869918086723137110005986280396651777574801894806896216800028637569274623115952691705831786855142876372495042729622496416156065929528185678346792948178219730451297126977072400452744745442561264775799188074289500187819445634298783592673376925950468898124384645088176602526214362158710249480242291627057463890117803354864730141461123747252541155347156400786777580958799766203254109472380735138017589461079608897268030232306639370404014163374433657561727131953203599087127600881156801848610207055453714038310061358219048264213893904654160135134848687217172657051056772433684382081263303256605397966956854911368891641655435481304103776752873688058287104569168817065852794438626208265013522214226436602866008965183348172506623891029487173951745639310845051694186685631363145511797791938639666555812388418639006943045236047084104158886785565539716175502784568418794921820159931670582549209945162053950333817714412469166667825536844480057325499652926508866184039633216003293080890783177150560019167662732664450429084752291624787970859408952386737598480289325786960288529818745254001900176106836194717861463240979411026596588950731407070101543407905496821261729510687348937796821412471929466014397692973783859204087752392409288320366943382998932124935828714903875879810782071015247527108459417616171666066601727254393827585882211498062627962114450203721750315845815155021697506333572413625746275557635360793506459802530913864986879539619322648374208957842152789346087113544250046274926635250206832991054325050621508788782189089586427470337274776955856080752508329602238857381659447673739378703749938045217491297442880220072951767019308302182120866450686427636523729778183001298464279351451928526859912935358200922256687852217293342222770676364112675875706669220947500716778555631580892140965700894865432467415441058797916958701058613262784771287521375767679654675090202761215911050514394041232506701642838754586624728822744306994328186360720405674825737265107963504397795466141078520379635918101893732280384966090817776697492519589958581600274196260931284807107964025197355095278741484748256594018281189059520971488155232871826436474292672923671151932746647309516440171397028945399089869838594185867352632608780487775648305026266036688377754295386304268591067685420141876930761382919961712554949830460502589375485003677323126912620975565484588745962938195716999584478642921595627905781087037922126946614604204487324577624535390564298909897280520685096190766392954666547140142042912418332011086985860840135170509805299821832401396881784927340948572834668444512971438394035995512132253672305434131965163273499166432580879149169510915828895700480265882084820049681597304529404116243028731782666223146293276746325246389991906529999778889818267030526761479627741075225237850144113075710406764114186915812713229218993793341952820039777430468508433933966568805816476723519852998663547981299673789287916637548338855826997859936126186385134251146763787920958572343543991163814387927189271315975774832941216796979710625756748626599205479744652593376548351502299670239068557344870045319781398252470403969497344298988472389766532157945149006071078612248352124554889096445319251898085100982701259010029952682041054540095054811702903956018540222632923457127530247486958765495736895235378687056667532898872772226646337210525647648255272837299826798955752834895854767176324936924389475920748073831818096942140696117576092974900312853119224158903042363552736819426608351322112183508012056364946319635528219546604362373666786411115604890681450553292576529326479658711947191604698823116618052429048783309728106697011619648892228467141759801681403110446555051361286503728164299660143689758025052636205563319986489358179027312653555993846959468256374852368137107311301180752627493394581971715347510238354749743466448707369816187860965509171840845607662996123030730513040791692384884335938330381280366200730869537716461479253093292207520004802508144089109220447459994338712030132586927643258314767215456297941961060686384969263988976767300178026850202211882886115891867194452898699949334970606719473728841882215132953439233323551171404920756819606555668846000416712701888993858314625083201880134723672826428864990888175557418214752256
-149143276547656984948124912 ** -112                           = 0

Number "-132132245132134.1515123765412" (scale 0)
-132132245132134.1515123765412 ** 252                            = 3120478727852745944038201629388077518619819959072778583628662888334880902703519914956089883839049682560676318469032398877418258855834502244373291879606411026505240673439178203360337045239911911401143426214698971271446651876647780290878775496277056268500023561875074401483645577685406485543728816046104697722586058947707076996271324455741296959565524792629154208973708365548001942744414873486576135834495119053638656800810039027025111460331113258212007994067919145384836907081609212431099297641564986044622031456724633662129385296885404614299495960919762385823257644295402159220952463360942737103080118148157378054224237643480822424971993488886224977914497478451840908909543741696948530676782472589176085509233818251158281114742053469197512119057322174380982258491102193374311292374479260658074669161655748423441627187461082149885494689147360706871450098031935056173199096293719222350434764175998710688281702890509097348360359424470253307347729933523000107901985428772530720331531602039527737982138204747133438804098370520558033130528360187686745723186175166911233242211471504301640494824606523094514433764325212802493051981781145617974800929022725476602466144772127930440805434165616744472255347819425748816302231931654549386733679017858450849437143025476899823162000718594064313231515875922351213500222461590573572602190403067267602652736825180691112504152614488461179376450513626420818955027469144025952675277586101528625525962975039500773275778271940118869825449096270757603664530201369396099033029284457100867407697277568670150540402862276543512075434177386868941061854045298572535075420109196042754099960063991947561825511501510308275562634049421237378673160125072162000008236844954128527856723821733254208508907735993281091035579467181540332944219703979021157597903396359158593344664084014589368086779575978259251720029980655644790465254951448194710584230098489732637703819106720935376496517841788507273903175469897103859611331100545364249483088831520541660951382659294376726172983396374439867149870807521191671805902233698315119009713542754446376327365814873898054136563782777104472609469109963308092044568027239290595186247761999234668032081218755268222207063445264559530223287160963458677689875951320832784965806613254975793162543596534222371458668498571166837299325731596777670132830001546839544284346351393964824730839639301046179558652696082308824070477223869283054978658326855126932082754121256920575641227926598676719724725719222484148625020220494108342394030408253089899891700400203336918661663751523788622735773864833731552284954237137952497719069892440806380625733323869952845631051069940707365414990621967523332677411935527536814983008403556834213618522880787952621206983027073172116156651218377851746340174808375254284001435816118302249193303397466776845851743890519082821148416722135170698614740907867435963618925044956902958148324272894672030283819168758463855285701991252475351862754820487744045764868396684777846686070069982217881227849496760269225414231083805733290534151123406915650028121222263850640283860639197520959825152626458400452325975452613482437167476356009654121926543290145079478070360029730020980795208355698196814222112480898983202043419519375263651949181097645574205178523255626929768121920234439313474099206104455976950857197860880977258241730976397804678973733516947554105951667082135434125689463359251547871548911802646544683845207784833032667495833535290224433943754770189766271196987201022608066882057869125850499995301677418321251261832661046278653566452890787168741868239138468494682699662284065061316757322733605
-132132245132134.1515123765412 ** -112                           = 0

Number "0.1322135476547459213732911312" (scale 0)
0.1322135476547459213732911312 ** 252                            = 0
0.1322135476547459213732911312 ** -112                           = 261271852670585926399109608993686784219014928770917821092988518427507780528448900476275115673665845

Number "-0.123912932193769965476541321" (scale 0)
-0.123912932193769965476541321 ** 252                            = 0
-0.123912932193769965476541321 ** -112                           = 372337687215014577843846097845819604950292238064034167723169672020440891758727112526694844172394015451

Number "252" (scale 10)
252 ** 252                            = 142212010733424647125806541813713973266552845448041013743767421605354690415544328196152173390963803494710443230142152775687771944805429044982729796870857181947776572826160793933424942988750037827638341986183789792079484880609013515717131451507203060282065264043070502125106179548342207047711204933650239424460841202157152719662980652213693426926863084348529493037513389175805577626219903234384208039735661457745854089305800218117427842428649306815115886661640301037762482527923343983853507875264930793965916131347421096416232894153340276842687468868552274843085150094307684610419227652811804917758213226496.0000000000
252 ** -112                           = 0.0000000000

Number "-112" (scale 10)
-112 ** 252                            = 2528958559509291693508169626548016243760525615786379976651267082288161074806837567146354242426675448089179587223689918667106749284121965637887934532709154725528081671334320643858146400820666287506930741579829377389324701928200642059190071982670723834096616484481264403390509754202256821825886418273918096647296731861068941003342202311747852949747419032091731983573265045376333262301085406296848909763397511959941544798830761308589095475080050282796818166220650002245272286955283850226653729461037771414650027776147456.0000000000
-112 ** -112                           = 0.0000000000

Number "14.14" (scale 10)
14.14 ** 252                            = 81893830287657387446140079713887806093576884288543703328783802176508922753380870094003376900318176725198165627317176488631295332728458521626072637389422651709754634844150191850264235770478926203337416116264674564206565124289082609409927041547210316199545928823591027686585730497632744792533.0727815413
14.14 ** -112                           = 0.0000000000

Number "-16.60" (scale 10)
-16.60 ** 252                            = 29325011162031531635050775473043742335712717807162139294189975794596377719994688259393390430325862997866008694776131070878139493075620575422701181905723221059535177378476880731856824922247604302185770818227621273103971150596854313288134126369153196254990016237048145067458027194360617116808917107675683822643.7551838996
-16.60 ** -112                           = 0.0000000000

Number "0.15" (scale 10)
0.15 ** 252                            = 0.0000000000
0.15 ** -112                           = 189574092538418764958341193234367215745086742520818271114560854632390900314942322598922704092.1046205530

Number "-0.01" (scale 10)
-0.01 ** 252                            = 0.0000000000
-0.01 ** -112                           = 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0000000000

Number "15151324141414.412312232141241" (scale 10)
15151324141414.412312232141241 ** 252                            = 2975421749795666718292864311407249970705086081437807395789379168718267809761515926216519710525556923711393180871882349125480337759668727402072958238900666362552341750552695988372017271582392491705356316948514737089205360282499880482512926893561832567935188520485154057479922893292233844872682027689029924296957873832086320362860520134654280058518517337570653996385278714198685752823835453817905306636319703719003676343516921560023010996505106467350842109482615346014981820723775172695392986401597801626150692206539756529644889137926049906575290564959396735953680592250779460130816876807757766338263686270020029393453575181327870591265373834140347848891333472452106266668645850397235968389042220027274496640159090815418483309643657324273121448493101717217140617069517287371864653153681358830190414615833078002577453411141597016583358385430394744450538495805740402488576124870572258200605831119008100984519684993455060646872766261382240383564392178883974453450433114215183488267147681395487265404247208352661495181304031822061114406175030677886104508679211172804603630316447723815907701460914622481206853022006681302191940743481903991732602477879503644713688600025822484351386994709104484371310424352144611218737196401824457866949669228902625541115988570606278592188602331451576075786613348336629409301707863923798082511203519536680273830467529869070112013346223720130183581189201489843066803035998524636580843999168622007134798723860720169157200004627398709928941733609441557160972211113022692009799237864185615460855228045985383589616750868474559577038584404446390706055987175018852877810774653462856565006598191028334508282011970034047209214176244147503985386832987247129380772291221015035166871079932982021644848487302418889155646720341011763574205760582552545432674974794783974025401318074084939141860755094923101801284442989344181743012614781021983935394731085008059924819771193595363859258571474767439534580638568746666210621240873673676940762489862112336626521441471577301366647762037305798100798711822457474507172500970023127288841824797039587587687760406935930088932018738492033507792817250533066953710174207685876451854460620309225706829752706450285622677922594957647037672524232255747269667789144401086986842640538153043741101238245322300993710394384754508967946211337487952324876892016919924636143376046118565299301806000686710931777881411145696867371682466218379864851343043041312758162391699150775018231599537746501756924961427444527995061269251565547747098676254156910141573235165420989417824245466381006116578002121746837672733849938657667872006918460874232266046864354612969306512425002050502769904919642157609172541701550215596501139800180259552618049103708500764672848369198536220300039766241517053637402993685274740246644140211865650547971680391614831119804648079596819224703795536455681460692071824945358084847698465553826334065350185771802401947633785300181386909348829848309501929340612695571623266869616638304357843374880496058625355636022120527400443841025788264209843812042625792300865583082505414465908017500188208987693716855836263772885824776988984333362684311002647195832946927199653846403980218407171091513992332604667414925751436017212580993860794349764631915036822374405575551253454423848395310883501116565831195963321659796880685759075194666868292856205113353111159407896940446955956749209.1357309004
15151324141414.412312232141241 ** -112                           = 0.0000000000

Number "141241241241241248267654747412" (scale 10)
141241241241241248267654747412 ** 252                            = 61702737614252266948752156824258824995959599972302320510716529982037298313739133760034183411877915226877565852198668440669791795617272708708492070599904800132098399232978789534072748261835151242629120913793827710449864804330737116696282852494151262231643262037509694372134135894276508967194766869889867303622326767458055285775054658565704105389065774707528077134226867060689181155582362175947504766959470020293226474023546968232460082444503912720021117368360386834444296061143129153351909427031876573177512880122064185569107842900553293550154759961105705458193916741180207197209621223094253214396769871913256823886396746414009606236401337641975159583111263046921277256870910247139612445619959067659323246784229705879779504519921968053141823090638689328500711053428918278999419825533334808914479125124304786443895285883492931266287931531729858829237461074566895486671242348082833878884776228517928133923449282430038745609287058924814413730985957861336607098992582653851368483642246306509531450226330989261394231526444743678146424987980458014955926233473826334115019067286145968725016152043997048698852555649504111446712360855837865476980303396801134199935075659852802884819197423764473479086847306010829721607657507579637914756242599185804487547475812412827298700399642854781876339506969947557967510353980827513717983184885292080872213577420468280210432294624241752834053309219199045973319521987975932929891565623163042217388611918307622483024452293173783579391106196420370018442330967765451700900306909737464257886906607274005552053888483483054020641145694539605337937744331035605313696665428737416632101002639001569789365490404722602805032116136122275148638414611401101532057194278420768914301864998398142593349158088898737725867540737097890425196584907775942120540985239557579236871185430362654320129291837576497911030976672546705634824923076862019595021475580215199988383732424366096745105419692283398918642003304826916218038854944067948189983518814346644870415937764601253868517196737959263980145504426078052198314663327843039356842201353163719488533902336353096176525901730253653712920740921897375508115858541406566947578335604123685577167716291169069652779908723297589735946583152466623845488142430700731769152222928283344575334939855201356733293357748709762620500872007205341239109409378799478441798933979724812650664098561233648811173269759247319678281986289749980800969619374582248288309266623507972587507556836064440726974305255199923316929818005467224051058298675312384426804897772240949920506431569837490498738453686746046335084609377713999742753257733912005654985684955512755879419270408315204048723476100838206401604215791253443838837275686487522888505399721610616356437415942085415265887671279570399360491649770978544857086906535678225672378863908117400571273280456942553369722415886814734827811782754510807365782422375263311630528352008474205547181623751728827140229718189606400373948548748620058632906237446487461463924934038124060220073591275626363882021308939573471462771350670733259367229333311304626874470724822013347119651171746131956616787517406892676075170382597409056665459502450515715507008118773500106516262784295667877075894103798253576492873141052750983781150748301119099230755964674235471935040610571173788486284126167436426267511157335062848567544617136701036212286420938449059910123857126789600929537328019086612659111870130906758076250376040429753144954758559356615713330390937898173091733151870035205661876454153260289142884914806807421852435737887997788694746400471112311576221296382603532103910277379683106908049352464276556594523117986718023572377990452537890518505167077689962380643979739773271443338742938727262511258728095020188473504370112836853749915575721872419520821790251159556333443030459056638192775423075084514851738672355958336265015380193591541922572518272773045049968850063625505732261611074622474965936400258314638193512375533757871806804692087708082031597721541387274042872955965737015089791668860525425793056778509470752578481376934088995106166553613693981904966686690212955481430046830913629928245843069361759411764297658217897316455217217021684202563946301505904193890271187899540947054172542875489231623713315378660419455411924354406330626224728228155305799300626640774404377831301051311563284401393151464407836422401342988060834178957138740247616789909739231830346449366019203847401064438442628508720077238078363655382024999197911442576806729689998326498342414751123237684542163876848231535744093508827210033685403359485309410368756619655335647815457456271662771356876949346139750604173629577681834134842499790368833444683342223857503185849902689436294823704067138925427306607192910954091698318729347145907800382668086667899534178563329442767437901814888337083677115243233418029978664046416826126543919629091736900005600339085979551469129407326751494940405612077593337217212627875249494414287211237336394051868492049328715249941706898117243520077930496903083255415280985218820687648161267600024140589397356281610905118704267436760893073994318473316685154852928135755455009702456043054322286620596648587752781151951829993681040341917550141278881598811594525627199147969934315163608714206891254146576331437603057409575204473025499304932390635935053481842967808825955521225903532223710955029023291335271704387554010604494359260592752707638749226503894251533287510138743058143563627083333323467953930288323174099691963642626244047994212921019096440748326461891434713107878328347627128553535347757109535162399519267201671099780388509076162219198648438104874056150803718036255353941654576267453857313032960105282442901730781706849116468293203141632905459414497264691251443801343872064950763335362229179456002525747120895247485013820030787875667079177283909056955331506973886798132875485898886780825156590108516771255757929317588856294114876639328139025640209294004084324019087271465180464949662380290646689899281765951368313154956095080011378907737551290670716282657109905603462006701850544998109045986412695185702298097876768249839078776688511467326239283983098509833719622936353377241972069901941714532498768716115868591570677576564417673178096539225866975241748028970361222145947727863536827216898514621847057819434576609230609611433988111992050578257972824282582096472184583048169498234433362074234852397751092471572561447915858864173251918950055149910352613561842701231235991010567523708933526326914146617809092162785366466356881319331412699810698600005749537204138000103625418561709921211393425978474528008482773381566071958815629154952129819071276958851406185526598276525973924382616619638927391896061767984462316342879485215181167142278283860974122393376129042592163052368958562549536015824310093694746026464275365131184771894447337638915074864139725976487382152380756354201968249702096723240570755670245536167613452904133125178947690742699517259032210148920215799181139024035965215646290857562866703810691715946409991609804815076179410873897787742683601227701850554553822077038999133518015046632371381193916753753001215985430108776610861216333105848176092629616183087158890392572221891278673318821093507423533826286478376277706846738214944276585022159559546442701466991751438781940501472267762449963577519763912275982471063234586863118222911568589623962096407513817772511232500343850038909537966015828523715127021508912585417674924982540682182384350779611171081429430780526138025312256.0000000000
141241241241241248267654747412 ** -112                           = 0.0000000000

Number "-149143276547656984948124912" (scale 10)
-149143276547656984948124912 ** 252                            = 55992175588333605542254063511278186461754574279839591709604310477562564689608443402403312222078711893971235561416950804719506082702379684733623971919408777114548100892216614108951324353246556535017960316014312222959702094808816331434094822650280427440063882576116695336500221646817757077369708529723823620336810350659576930581023887896886330503478109619863448515840946841190553234682382107049366084010115954164628751537372573754962628376851714140066914283347218349289869214926741444216767437164014398845666639858144658260377876458100579298055950974326675298651898083944350131609483093051504290661822668587661388602474880915186436725755772988399461893678236514411268113165984474267116617738961793643422894941375678592236663229748980138556108251262049269924802865828570213870281755635578142765872996532114681632125265545602095618091845037482357075517681870091778157619627960547482657474217943178159685376848804852485477702194998676631497601923456769896045663194900447061246337026655179495322126687564510781039271062988745945476519142221837023581656486042843501094480484668735886050383956287988798135101996785626705798462084512791858856000486173266205660052015961534265640905209313211125294627662693933297211009401491531951462889268507817897027972228709128736864008707571464724272762871838758126048184870005667275664845553774616604225572310912906152876060860153081105424979281592600839984125772468965874379832364640972866833334251698542584896314049237205644695553901317638647614318787708386467733615459065054365995897250270550067664267902152593317177099901109073008588486059511534052232495744462484660835773139005865467174339411663680328459135341612957853618227176487790111649236830978394018719354265785673205669861260376582410982507319458447629229410566850388275381698880420276787659514779189425772384786376987076804655929761620083736939837925917040082332479217674557289518688000706235667753826358380348450542285250406537012741099810396394118895119698580737840025778922487867828224721621696636134003638036732306141123387999132026332818408631403997196873195235009010958949928160436198665838441080496516462280678580659979676597569859757823014996017746962217866836145864024569035599176373962484096890443265839324221819146344682358316417403925617439797384999832590030653638024893217809739723987689363496190587792737138664106310356621671611551929705606372447129233289185995118668079125240237102990263869918086723137110005986280396651777574801894806896216800028637569274623115952691705831786855142876372495042729622496416156065929528185678346792948178219730451297126977072400452744745442561264775799188074289500187819445634298783592673376925950468898124384645088176602526214362158710249480242291627057463890117803354864730141461123747252541155347156400786777580958799766203254109472380735138017589461079608897268030232306639370404014163374433657561727131953203599087127600881156801848610207055453714038310061358219048264213893904654160135134848687217172657051056772433684382081263303256605397966956854911368891641655435481304103776752873688058287104569168817065852794438626208265013522214226436602866008965183348172506623891029487173951745639310845051694186685631363145511797791938639666555812388418639006943045236047084104158886785565539716175502784568418794921820159931670582549209945162053950333817714412469166667825536844480057325499652926508866184039633216003293080890783177150560019167662732664450429084752291624787970859408952386737598480289325786960288529818745254001900176106836194717861463240979411026596588950731407070101543407905496821261729510687348937796821412471929466014397692973783859204087752392409288320366943382998932124935828714903875879810782071015247527108459417616171666066601727254393827585882211498062627962114450203721750315845815155021697506333572413625746275557635360793506459802530913864986879539619322648374208957842152789346087113544250046274926635250206832991054325050621508788782189089586427470337274776955856080752508329602238857381659447673739378703749938045217491297442880220072951767019308302182120866450686427636523729778183001298464279351451928526859912935358200922256687852217293342222770676364112675875706669220947500716778555631580892140965700894865432467415441058797916958701058613262784771287521375767679654675090202761215911050514394041232506701642838754586624728822744306994328186360720405674825737265107963504397795466141078520379635918101893732280384966090817776697492519589958581600274196260931284807107964025197355095278741484748256594018281189059520971488155232871826436474292672923671151932746647309516440171397028945399089869838594185867352632608780487775648305026266036688377754295386304268591067685420141876930761382919961712554949830460502589375485003677323126912620975565484588745962938195716999584478642921595627905781087037922126946614604204487324577624535390564298909897280520685096190766392954666547140142042912418332011086985860840135170509805299821832401396881784927340948572834668444512971438394035995512132253672305434131965163273499166432580879149169510915828895700480265882084820049681597304529404116243028731782666223146293276746325246389991906529999778889818267030526761479627741075225237850144113075710406764114186915812713229218993793341952820039777430468508433933966568805816476723519852998663547981299673789287916637548338855826997859936126186385134251146763787920958572343543991163814387927189271315975774832941216796979710625756748626599205479744652593376548351502299670239068557344870045319781398252470403969497344298988472389766532157945149006071078612248352124554889096445319251898085100982701259010029952682041054540095054811702903956018540222632923457127530247486958765495736895235378687056667532898872772226646337210525647648255272837299826798955752834895854767176324936924389475920748073831818096942140696117576092974900312853119224158903042363552736819426608351322112183508012056364946319635528219546604362373666786411115604890681450553292576529326479658711947191604698823116618052429048783309728106697011619648892228467141759801681403110446555051361286503728164299660143689758025052636205563319986489358179027312653555993846959468256374852368137107311301180752627493394581971715347510238354749743466448707369816187860965509171840845607662996123030730513040791692384884335938330381280366200730869537716461479253093292207520004802508144089109220447459994338712030132586927643258314767215456297941961060686384969263988976767300178026850202211882886115891867194452898699949334970606719473728841882215132953439233323551171404920756819606555668846000416712701888993858314625083201880134723672826428864990888175557418214752256.0000000000
-149143276547656984948124912 ** -112                           = 0.0000000000

Number "-132132245132134.1515123765412" (scale 10)
-132132245132134.1515123765412 ** 252                            = 3120478727852745944038201629388077518619819959072778583628662888334880902703519914956089883839049682560676318469032398877418258855834502244373291879606411026505240673439178203360337045239911911401143426214698971271446651876647780290878775496277056268500023561875074401483645577685406485543728816046104697722586058947707076996271324455741296959565524792629154208973708365548001942744414873486576135834495119053638656800810039027025111460331113258212007994067919145384836907081609212431099297641564986044622031456724633662129385296885404614299495960919762385823257644295402159220952463360942737103080118148157378054224237643480822424971993488886224977914497478451840908909543741696948530676782472589176085509233818251158281114742053469197512119057322174380982258491102193374311292374479260658074669161655748423441627187461082149885494689147360706871450098031935056173199096293719222350434764175998710688281702890509097348360359424470253307347729933523000107901985428772530720331531602039527737982138204747133438804098370520558033130528360187686745723186175166911233242211471504301640494824606523094514433764325212802493051981781145617974800929022725476602466144772127930440805434165616744472255347819425748816302231931654549386733679017858450849437143025476899823162000718594064313231515875922351213500222461590573572602190403067267602652736825180691112504152614488461179376450513626420818955027469144025952675277586101528625525962975039500773275778271940118869825449096270757603664530201369396099033029284457100867407697277568670150540402862276543512075434177386868941061854045298572535075420109196042754099960063991947561825511501510308275562634049421237378673160125072162000008236844954128527856723821733254208508907735993281091035579467181540332944219703979021157597903396359158593344664084014589368086779575978259251720029980655644790465254951448194710584230098489732637703819106720935376496517841788507273903175469897103859611331100545364249483088831520541660951382659294376726172983396374439867149870807521191671805902233698315119009713542754446376327365814873898054136563782777104472609469109963308092044568027239290595186247761999234668032081218755268222207063445264559530223287160963458677689875951320832784965806613254975793162543596534222371458668498571166837299325731596777670132830001546839544284346351393964824730839639301046179558652696082308824070477223869283054978658326855126932082754121256920575641227926598676719724725719222484148625020220494108342394030408253089899891700400203336918661663751523788622735773864833731552284954237137952497719069892440806380625733323869952845631051069940707365414990621967523332677411935527536814983008403556834213618522880787952621206983027073172116156651218377851746340174808375254284001435816118302249193303397466776845851743890519082821148416722135170698614740907867435963618925044956902958148324272894672030283819168758463855285701991252475351862754820487744045764868396684777846686070069982217881227849496760269225414231083805733290534151123406915650028121222263850640283860639197520959825152626458400452325975452613482437167476356009654121926543290145079478070360029730020980795208355698196814222112480898983202043419519375263651949181097645574205178523255626929768121920234439313474099206104455976950857197860880977258241730976397804678973733516947554105951667082135434125689463359251547871548911802646544683845207784833032667495833535290224433943754770189766271196987201022608066882057869125850499995301677418321251261832661046278653566452890787168741868239138468494682699662284065061316757322733605.4563495790
-132132245132134.1515123765412 ** -112                           = 0.0000000000

Number "0.1322135476547459213732911312" (scale 10)
0.1322135476547459213732911312 ** 252                            = 0.0000000000
0.1322135476547459213732911312 ** -112                           = 261271852670585926399109608993686784219014928770917821092988518427507780528448900476275115673665845.0719674616

Number "-0.123912932193769965476541321" (scale 10)
-0.123912932193769965476541321 ** 252                            = 0.0000000000
-0.123912932193769965476541321 ** -112                           = 372337687215014577843846097845819604950292238064034167723169672020440891758727112526694844172394015451.7302535898
