--TEST--
Bug #77243 (Weekdays are calculated incorrectly for negative years)
--SKIPIF--
<?php if (PHP_INT_SIZE != 8) die("skip 64-bit only"); ?>
--FILE--
<?php
date_default_timezone_set('UTC');

$startingPoints = [
	-62167046400 - (((101 * 365) + 25) * 86400),
	-62167046400 - (((100 * 365) + 25) * 86400),
	-62167046400 - ((( 99 * 365) + 25) * 86400),
];

foreach ($startingPoints as $startingPoint)
{
	for ($i = -7; $i < 7; $i++ )
	{
		echo date('Y-m-d o-W-N', $startingPoint + ($i * 86400)), "\n";
	}
	echo "\n\n";
}
?>
--EXPECT--
-0102-12-26 -102-52-1
-0102-12-27 -102-52-2
-0102-12-28 -102-52-3
-0102-12-29 -102-52-4
-0102-12-30 -102-52-5
-0102-12-31 -102-52-6
-0101-01-01 -102-52-7
-0101-01-02 -101-01-1
-0101-01-03 -101-01-2
-0101-01-04 -101-01-3
-0101-01-05 -101-01-4
-0101-01-06 -101-01-5
-0101-01-07 -101-01-6
-0101-01-08 -101-01-7


-0101-12-26 -101-52-2
-0101-12-27 -101-52-3
-0101-12-28 -101-52-4
-0101-12-29 -101-52-5
-0101-12-30 -101-52-6
-0101-12-31 -101-52-7
-0100-01-01 -100-01-1
-0100-01-02 -100-01-2
-0100-01-03 -100-01-3
-0100-01-04 -100-01-4
-0100-01-05 -100-01-5
-0100-01-06 -100-01-6
-0100-01-07 -100-01-7
-0100-01-08 -100-02-1


-0100-12-26 -100-52-3
-0100-12-27 -100-52-4
-0100-12-28 -100-52-5
-0100-12-29 -100-52-6
-0100-12-30 -100-52-7
-0100-12-31 -99-01-1
-0099-01-01 -99-01-2
-0099-01-02 -99-01-3
-0099-01-03 -99-01-4
-0099-01-04 -99-01-5
-0099-01-05 -99-01-6
-0099-01-06 -99-01-7
-0099-01-07 -99-02-1
-0099-01-08 -99-02-2
