% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_cor.R
\name{stat_cor}
\alias{stat_cor}
\title{Add Correlation Coefficients with P-values to a Scatter Plot}
\usage{
stat_cor(
  mapping = NULL,
  data = NULL,
  method = "pearson",
  alternative = "two.sided",
  cor.coef.name = c("R", "rho", "tau"),
  label.sep = ", ",
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  output.type = "expression",
  digits = 2,
  r.digits = digits,
  p.digits = digits,
  r.accuracy = NULL,
  p.accuracy = NULL,
  geom = "text",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{method}{a character string indicating which correlation coefficient (or
covariance) is to be computed. One of "pearson" (default), "kendall", or
"spearman".}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less". You can specify
just the initial letter.}

\item{cor.coef.name}{character. Can be one of \code{"R"} (pearson coef),
\code{"rho"} (spearman coef) and \code{"tau"} (kendall coef). Uppercase and
lowercase are allowed.}

\item{label.sep}{a character string to separate the terms. Default is ", ", to
separate the correlation coefficient and the p.value.}

\item{label.x.npc, label.y.npc}{can be \code{numeric} or \code{character}
 vector of the same length as the number of groups and/or panels. If too
 short they will be recycled. \itemize{ \item If \code{numeric}, value should
 be between 0 and 1. Coordinates to be used for positioning the label,
 expressed in "normalized parent coordinates". \item If \code{character},
 allowed values include: i) one of c('right', 'left', 'center', 'centre',
 'middle') for x-axis; ii) and one of c( 'bottom', 'top', 'center', 'centre',
 'middle') for y-axis.}

 If too short they will be recycled.}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the label. If too short they will be recycled.}

\item{output.type}{character One of "expression", "latex", "tex" or "text".}

\item{digits, r.digits, p.digits}{integer indicating the number of decimal
places (round) or significant digits (signif) to be used for the correlation
coefficient and the p-value, respectively..}

\item{r.accuracy}{a real value specifying the number of decimal places of
precision for the correlation coefficient. Default is NULL. Use (e.g.) 0.01
to show 2 decimal places of precision. If specified, then \code{r.digits} is
ignored.}

\item{p.accuracy}{a real value specifying the number of decimal places of
precision for the p-value. Default is NULL. Use (e.g.) 0.0001 to show 4
decimal places of precision. If specified, then \code{p.digits} is ignored.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If FALSE (the default), removes missing values with a warning. If
TRUE silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE} (the default for most ggpubr functions), 
overrides the default aesthetics, rather than combining with them. This is 
most useful for helper functions that define both data and aesthetics and 
shouldn't inherit behaviour from the default plot specification. Set to 
\code{TRUE} to inherit aesthetics from the parent ggplot layer.}

\item{...}{other arguments to pass to \code{\link[ggplot2]{geom_text}} or
\code{\link[ggplot2:geom_text]{geom_label}}.}
}
\description{
Add correlation coefficients with p-values to a scatter plot. Can
 be also used to add `R2`.
}
\section{Computed variables}{
 \describe{ \item{r}{correlation coefficient}
 \item{rr}{correlation coefficient squared} \item{r.label}{formatted label
 for the correlation coefficient} \item{rr.label}{formatted label for the
 squared correlation coefficient} \item{p.label}{label for the p-value}
 \item{label}{default labeldisplayed by \code{stat_cor()}} }
}

\examples{
# Load data
data("mtcars")
df <- mtcars
df$cyl <- as.factor(df$cyl)

# Scatter plot with correlation coefficient
#:::::::::::::::::::::::::::::::::::::::::::::::::
sp <- ggscatter(df, x = "wt", y = "mpg",
   add = "reg.line",  # Add regressin line
   add.params = list(color = "blue", fill = "lightgray"), # Customize reg. line
   conf.int = TRUE # Add confidence interval
   )
# Add correlation coefficient
sp + stat_cor(method = "pearson", label.x = 3, label.y = 30)

# Specify the number of decimal places of precision for p and r
# Using 3 decimal places for the p-value and
# 2 decimal places for the correlation coefficient (r)
sp + stat_cor(p.accuracy = 0.001, r.accuracy = 0.01)

# Show only the r.label but not the p.label
sp + stat_cor(aes(label = after_stat(r.label)), label.x = 3)

# Use R2 instead of R
ggscatter(df, x = "wt", y = "mpg", add = "reg.line") +
 stat_cor(
   aes(label = paste(after_stat(rr.label), after_stat(p.label), sep = "~`,`~")),
  label.x = 3
)

# Color by groups and facet
#::::::::::::::::::::::::::::::::::::::::::::::::::::
sp <- ggscatter(df, x = "wt", y = "mpg",
   color = "cyl", palette = "jco",
   add = "reg.line", conf.int = TRUE)
sp + stat_cor(aes(color = cyl), label.x = 3)

}
\seealso{
\code{\link{ggscatter}}
}
