% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_pbmcapply.R
\name{handler_pbmcapply}
\alias{handler_pbmcapply}
\title{Progression Handler: Progress Reported via 'pbmcapply' Progress Bars (Text) in the Terminal}
\usage{
handler_pbmcapply(
  char = "=",
  substyle = 3L,
  style = "ETA",
  file = stderr(),
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{char}{(character) The symbols to form the progress bar for
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.}

\item{substyle}{(integer) The progress-bar substyle according to
\code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}.}

\item{style}{(character) The progress-bar style according to}

\item{file}{(connection) A \link[base:connections]{base::connection} to where output should be sent.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}
and \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{pbmcapply} package.
}

\section{Appearance}{

Below are a few examples on how to use and customize this progress handler.
In all cases, we use \code{handlers(global = TRUE)}.
Since \code{style = "txt"} corresponds to using \code{\link[=handler_txtprogressbar]{handler_txtprogressbar()}}
with \code{style = substyle}, the main usage of this handler is with
\code{style = "ETA"} (default) for which \code{substyle} is ignored.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers("pbmcapply")
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_pbmcapply-default.svg}}
}

\examples{
if (requireNamespace("pbmcapply", quietly = TRUE)) {

  handlers("pbmcapply")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
