% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fov.R, R/seurat.R
\name{GetTissueCoordinates}
\alias{GetTissueCoordinates}
\alias{GetTissueCoordinates.FOV}
\alias{GetTissueCoordinates.Seurat}
\title{Get tissue coordinates}
\usage{
GetTissueCoordinates(object, ...)

\method{GetTissueCoordinates}{FOV}(object, which = NULL, ...)

\method{GetTissueCoordinates}{Seurat}(object, image = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{which}{Name of segmentation boundary or molecule set to retrieve coordinates for;
if NULL, will retrieve coordinates for the default boundary}

\item{image}{Name of \code{SpatialImage} object to get coordinates for; if
\code{NULL}, will retrieve coordinates for the default image}
}
\value{
A data frame with tissue coordinates
}
\description{
Retrieve tissue coordinates from spatial objects.
}
\details{
Spatial classes may have specific implementations; 
refer to those documentation pages for more details.
}
\examples{
\dontrun{
GetTissueCoordinates(object, which = "centroids")
}
}
\concept{data-access}
