% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui-legacy.R
\name{ui-questions}
\alias{ui-questions}
\alias{ui_yeah}
\alias{ui_nope}
\title{User interface - Questions}
\usage{
ui_yeah(
  x,
  yes = c("Yes", "Definitely", "For sure", "Yup", "Yeah", "I agree", "Absolutely"),
  no = c("No way", "Not now", "Negative", "No", "Nope", "Absolutely not"),
  n_yes = 1,
  n_no = 2,
  shuffle = TRUE,
  .envir = parent.frame()
)

ui_nope(
  x,
  yes = c("Yes", "Definitely", "For sure", "Yup", "Yeah", "I agree", "Absolutely"),
  no = c("No way", "Not now", "Negative", "No", "Nope", "Absolutely not"),
  n_yes = 1,
  n_no = 2,
  shuffle = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{x}{A character vector.

For block styles, conditions, and questions, each element of the
vector becomes a line, and the result is processed by \code{\link[glue:glue]{glue::glue()}}.
For inline styles, each element of the vector becomes an entry in a
comma separated list.}

\item{yes}{A character vector of "yes" strings, which are randomly sampled to
populate the menu.}

\item{no}{A character vector of "no" strings, which are randomly sampled to
populate the menu.}

\item{n_yes}{An integer. The number of "yes" strings to include.}

\item{n_no}{An integer. The number of "no" strings to include.}

\item{shuffle}{A logical. Should the order of the menu options be randomly
shuffled?}

\item{.envir}{Used to ensure that \code{\link[glue:glue]{glue::glue()}} gets the correct
environment. For expert use only.}
}
\value{
A logical. \code{ui_yeah()} returns \code{TRUE} when the user selects a "yes"
option and \code{FALSE} otherwise, i.e. when user selects a "no" option or
refuses to make a selection (cancels). \code{ui_nope()} is the logical opposite
of \code{ui_yeah()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{ui_yeah()} and \code{ui_nope()} are technically superseded, but, unlike the rest
of the legacy \code{\link[=ui-legacy-functions]{ui_*()}} functions, there's not yet a
drop-in replacement available in the \href{https://cli.r-lib.org/}{cli package}.
\code{ui_yeah()} and \code{ui_nope()} are no longer used internally in usethis.
}
\examples{
\dontrun{
ui_yeah("Do you like R?")
ui_nope("Have you tried turning it off and on again?", n_yes = 1, n_no = 1)
ui_yeah("Are you sure its plugged in?", yes = "Yes", no = "No", shuffle = FALSE)
}
}
\keyword{internal}
