/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

use super::{configuration, Error};
use crate::apis::ResponseContent;

#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdPutBody {
    ApplicationJson(crate::models::PrivateKey),
    MultipartFormData(String),
}

impl KeysKeyIdPutBody {
    pub fn content_type(&self) -> &'static str {
        match self {
            Self::ApplicationJson(_) => "application/json",
            Self::MultipartFormData(_) => "multipart/form-data",
        }
    }
    pub fn is_json(&self) -> bool {
        match self {
            Self::ApplicationJson(_) => true,
            Self::MultipartFormData(_) => false,
        }
    }
    pub fn get_string(&self) -> String {
        match self {
            Self::ApplicationJson(_) => "".to_string(),
            Self::MultipartFormData(s) => s.clone(),
        }
    }
}

#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysPostBody {
    ApplicationJson(crate::models::PrivateKey),
    MultipartFormData(String),
}

impl KeysPostBody {
    pub fn content_type(&self) -> &'static str {
        match self {
            Self::ApplicationJson(_) => "application/json",
            Self::MultipartFormData(_) => "multipart/form-data",
        }
    }
    pub fn is_json(&self) -> bool {
        match self {
            Self::ApplicationJson(_) => true,
            Self::MultipartFormData(_) => false,
        }
    }
    pub fn get_string(&self) -> String {
        match self {
            Self::ApplicationJson(_) => "".to_string(),
            Self::MultipartFormData(s) => s.clone(),
        }
    }
}

/// struct for typed errors of method [`config_backup_passphrase_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigBackupPassphrasePutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigBackupPassphrasePutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_logging_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigLoggingGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigLoggingGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_logging_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigLoggingPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigLoggingPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_network_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigNetworkGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigNetworkGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_network_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigNetworkPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigNetworkPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_time_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTimeGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTimeGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_time_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTimePutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTimePutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_tls_cert_pem_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTlsCertPemGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    Status415(),
    UnknownValue(serde_json::Value),
}

impl ConfigTlsCertPemGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            415 => Ok(Self::Status415()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_tls_cert_pem_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTlsCertPemPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTlsCertPemPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_tls_csr_pem_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTlsCsrPemPostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTlsCsrPemPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_tls_generate_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTlsGeneratePostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTlsGeneratePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_tls_public_pem_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigTlsPublicPemGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigTlsPublicPemGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_unattended_boot_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigUnattendedBootGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigUnattendedBootGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_unattended_boot_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigUnattendedBootPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigUnattendedBootPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`config_unlock_passphrase_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ConfigUnlockPassphrasePutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ConfigUnlockPassphrasePutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`health_alive_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum HealthAliveGetError {
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl HealthAliveGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`health_ready_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum HealthReadyGetError {
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl HealthReadyGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`health_state_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum HealthStateGetError {
    Status406(),
    UnknownValue(serde_json::Value),
}

impl HealthStateGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            406 => Ok(Self::Status406()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`info_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InfoGetError {
    Status406(),
    UnknownValue(serde_json::Value),
}

impl InfoGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            406 => Ok(Self::Status406()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_generate_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysGeneratePostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysGeneratePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_cert_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdCertDeleteError {
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdCertDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_cert_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdCertGetError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdCertGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_cert_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdCertPutError {
    Status401(),
    Status403(),
    Status406(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdCertPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_csr_pem_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdCsrPemPostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdCsrPemPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_decrypt_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdDecryptPostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdDecryptPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdDeleteError {
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_encrypt_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdEncryptPostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdEncryptPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdGetError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_move_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdMovePostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdMovePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_public_pem_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdPublicPemGetError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdPublicPemGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_restrictions_tags_tag_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdRestrictionsTagsTagDeleteError {
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdRestrictionsTagsTagDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_restrictions_tags_tag_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdRestrictionsTagsTagPutError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdRestrictionsTagsTagPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_id_sign_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyIdSignPostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyIdSignPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_key_prefix_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysKeyPrefixGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysKeyPrefixGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`keys_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum KeysPostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl KeysPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`lock_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LockPostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl LockPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`metrics_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MetricsGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl MetricsGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`namespaces_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum NamespacesGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl NamespacesGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`namespaces_namespace_id_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum NamespacesNamespaceIdDeleteError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl NamespacesNamespaceIdDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`namespaces_namespace_id_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum NamespacesNamespaceIdPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl NamespacesNamespaceIdPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`provision_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ProvisionPostError {
    Status400(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl ProvisionPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`random_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RandomPostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl RandomPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_backup_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemBackupPostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemBackupPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_cancel_update_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemCancelUpdatePostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemCancelUpdatePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_commit_update_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemCommitUpdatePostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemCommitUpdatePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_factory_reset_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemFactoryResetPostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemFactoryResetPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_info_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemInfoGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemInfoGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_reboot_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemRebootPostError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemRebootPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_restore_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemRestorePostError {
    Status400(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemRestorePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_shutdown_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemShutdownPostError {
    Status401(),
    Status403(),
    Status406(),
    UnknownValue(serde_json::Value),
}

impl SystemShutdownPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`system_update_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SystemUpdatePostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl SystemUpdatePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`unlock_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UnlockPostError {
    Status400(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UnlockPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersGetError {
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersPostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdDeleteError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdGetError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_passphrase_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdPassphrasePostError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdPassphrasePostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdPostError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdPostError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdPutError {
    Status400(),
    Status401(),
    Status403(),
    Status406(),
    Status409(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            406 => Ok(Self::Status406()),
            409 => Ok(Self::Status409()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_tags_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdTagsGetError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdTagsGetError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_tags_tag_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdTagsTagDeleteError {
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdTagsTagDeleteError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// struct for typed errors of method [`users_user_id_tags_tag_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UsersUserIdTagsTagPutError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status406(),
    Status412(),
    UnknownValue(serde_json::Value),
}

impl UsersUserIdTagsTagPutError {
    fn new(status: u16, data: &[u8]) -> Result<Self, serde_json::Error> {
        // to do: support payloads once added to API spec
        match status {
            400 => Ok(Self::Status400()),
            401 => Ok(Self::Status401()),
            403 => Ok(Self::Status403()),
            404 => Ok(Self::Status404()),
            406 => Ok(Self::Status406()),
            412 => Ok(Self::Status412()),
            _ => {
                if data.is_empty() {
                    Ok(Self::UnknownValue(serde_json::Value::Null))
                } else {
                    serde_json::from_slice(data).map(Self::UnknownValue)
                }
            }
        }
    }
}

/// Update the backup passphrase. If the backup passphrase is not set yet, use \"\" as currentPassphrase.  *WARNING:* Like the unlock passphrase, this configuration can't be reset by an admin user without knowing the current value, so if the backup passphrase is lost, neither can it be reset to a new value nor can the created backups be restored.
pub fn config_backup_passphrase_put(
    configuration: &configuration::Configuration,
    backup_passphrase_config: crate::models::BackupPassphraseConfig,
) -> Result<ResponseContent<()>, Error<ConfigBackupPassphrasePutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/config/backup-passphrase",
        local_var_configuration.base_path
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(backup_passphrase_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigBackupPassphrasePutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get logging configuration. Protocol is always syslog over UDP. Configurable are IP adress and port, log level.
pub fn config_logging_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::LoggingConfig>, Error<ConfigLoggingGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/logging", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigLoggingGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Configure log level and destination.
pub fn config_logging_put(
    configuration: &configuration::Configuration,
    logging_config: crate::models::LoggingConfig,
) -> Result<ResponseContent<()>, Error<ConfigLoggingPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/logging", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(logging_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigLoggingPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get network configuration. IP address, netmask, router.
pub fn config_network_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::NetworkConfig>, Error<ConfigNetworkGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/network", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigNetworkGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Configure network.
pub fn config_network_put(
    configuration: &configuration::Configuration,
    network_config: crate::models::NetworkConfig,
) -> Result<ResponseContent<()>, Error<ConfigNetworkPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/network", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(network_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigNetworkPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get system time.
pub fn config_time_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::TimeConfig>, Error<ConfigTimeGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/time", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTimeGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Configure system time.
pub fn config_time_put(
    configuration: &configuration::Configuration,
    time_config: crate::models::TimeConfig,
) -> Result<ResponseContent<()>, Error<ConfigTimePutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/time", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(time_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTimePutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get certificate for NetHSMs https API.
pub fn config_tls_cert_pem_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<String>, Error<ConfigTlsCertPemGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/tls/cert.pem", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/x-pem-file";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::string(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTlsCertPemGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Set certificate for NetHSMs https API e.g. to replace self-signed intital certificate.
pub fn config_tls_cert_pem_put(
    configuration: &configuration::Configuration,
    body: &str,
) -> Result<ResponseContent<()>, Error<ConfigTlsCertPemPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/tls/cert.pem", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/x-pem-file");
    let local_var_result = local_var_req_builder.send(body);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTlsCertPemPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get NetHSM certificate signing request e.g. to replace self-signed intital certificate.
pub fn config_tls_csr_pem_post(
    configuration: &configuration::Configuration,
    distinguished_name: crate::models::DistinguishedName,
) -> Result<ResponseContent<String>, Error<ConfigTlsCsrPemPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/tls/csr.pem", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/x-pem-file";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(distinguished_name);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::string(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTlsCsrPemPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Generate a new pair of public and private key for NetHSM's https API.
pub fn config_tls_generate_post(
    configuration: &configuration::Configuration,
    tls_key_generate_request_data: crate::models::TlsKeyGenerateRequestData,
) -> Result<ResponseContent<()>, Error<ConfigTlsGeneratePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/config/tls/generate", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(tls_key_generate_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTlsGeneratePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get public key for NetHSMs https API.
pub fn config_tls_public_pem_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<String>, Error<ConfigTlsPublicPemGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/config/tls/public.pem",
        local_var_configuration.base_path
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/x-pem-file";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::string(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigTlsPublicPemGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Read unattended boot configuration: is it on or off?
pub fn config_unattended_boot_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::UnattendedBootConfig>, Error<ConfigUnattendedBootGetError>>
{
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/config/unattended-boot",
        local_var_configuration.base_path
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigUnattendedBootGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Configure unattended boot: switch it on or off (flip the switch).
pub fn config_unattended_boot_put(
    configuration: &configuration::Configuration,
    unattended_boot_config: crate::models::UnattendedBootConfig,
) -> Result<ResponseContent<()>, Error<ConfigUnattendedBootPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/config/unattended-boot",
        local_var_configuration.base_path
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(unattended_boot_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigUnattendedBootPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Update the unlock passphrase.  *WARNING:* The unlock passphrase can't be reset by an admin user without knowing the current value, so if the unlock passphrase is lost, neither can it be reset to a new value nor can the NetHSM be unlocked.
pub fn config_unlock_passphrase_put(
    configuration: &configuration::Configuration,
    unlock_passphrase_config: crate::models::UnlockPassphraseConfig,
) -> Result<ResponseContent<()>, Error<ConfigUnlockPassphrasePutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/config/unlock-passphrase",
        local_var_configuration.base_path
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(unlock_passphrase_config);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ConfigUnlockPassphrasePutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve whether NetHSM is fully started but not ready to take traffic. This corresponds to the state *Locked* or *Unprovisioned*.
pub fn health_alive_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<HealthAliveGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/health/alive", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            HealthAliveGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve whether NetHSM is in state *Operational* and thus ready to take traffic.
pub fn health_ready_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<HealthReadyGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/health/ready", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            HealthReadyGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve the state of NetHSM.
pub fn health_state_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::HealthStateData>, Error<HealthStateGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/health/state", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            HealthStateGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Information about the vendor and product.
pub fn info_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::InfoData>, Error<InfoGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/info", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            InfoGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Generate a pair of public and private key and store it in NetHSM. KeyID is optional as a parameter and will be generated by NetHSM if not present. The key is stored in the caller's namespace.
pub fn keys_generate_post(
    configuration: &configuration::Configuration,
    key_generate_request_data: crate::models::KeyGenerateRequestData,
) -> Result<ResponseContent<crate::models::CreateResourceId>, Error<KeysGeneratePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/keys/generate", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(key_generate_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysGeneratePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get a list of the identifiers of all keys that are currently stored in NetHSM. If the caller is in a namespace, only keys in that namespace are returned. Separate requests need to be made to request the individual key data. To fetch only a subset of keys, consider using `/keys/pfx*`.
pub fn keys_get(
    configuration: &configuration::Configuration,
    filter: Option<&str>,
) -> Result<ResponseContent<Vec<crate::models::KeyItem>>, Error<KeysGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/keys", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(local_var_str) = filter {
        local_var_req_builder =
            local_var_req_builder.query_pairs([("filter", local_var_str.to_string().as_str())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete the certificate.
pub fn keys_key_id_cert_delete(
    configuration: &configuration::Configuration,
    key_id: &str,
) -> Result<ResponseContent<()>, Error<KeysKeyIdCertDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/cert",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdCertDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve a stored certificate in the exact format it was stored.
pub fn keys_key_id_cert_get(
    configuration: &configuration::Configuration,
    key_id: &str,
) -> Result<ResponseContent<std::vec::Vec<u8>>, Error<KeysKeyIdCertGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/cert",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/octet-stream";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::bytes(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdCertGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Store a certificate. Maximum size 1MB. The Content-Type must be application/octet-stream.
pub fn keys_key_id_cert_put(
    configuration: &configuration::Configuration,
    key_id: &str,
    body: std::vec::Vec<u8>,
) -> Result<ResponseContent<()>, Error<KeysKeyIdCertPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/cert",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder =
        local_var_req_builder.header("content-type", "application/octet-stream");
    let local_var_result = local_var_req_builder.send(body);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdCertPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve a certificate signing request in PEM format.
pub fn keys_key_id_csr_pem_post(
    configuration: &configuration::Configuration,
    key_id: &str,
    distinguished_name: crate::models::DistinguishedName,
) -> Result<ResponseContent<String>, Error<KeysKeyIdCsrPemPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/csr.pem",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/x-pem-file";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(distinguished_name);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::string(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdCsrPemPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Decrypt an encrypted message with the secret key.
pub fn keys_key_id_decrypt_post(
    configuration: &configuration::Configuration,
    key_id: &str,
    decrypt_request_data: crate::models::DecryptRequestData,
) -> Result<ResponseContent<crate::models::DecryptData>, Error<KeysKeyIdDecryptPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/decrypt",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(decrypt_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdDecryptPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete a pair of public and private key.
pub fn keys_key_id_delete(
    configuration: &configuration::Configuration,
    key_id: &str,
) -> Result<ResponseContent<()>, Error<KeysKeyIdDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Encrypt a message with the secret key.
pub fn keys_key_id_encrypt_post(
    configuration: &configuration::Configuration,
    key_id: &str,
    encrypt_request_data: crate::models::EncryptRequestData,
) -> Result<ResponseContent<crate::models::EncryptData>, Error<KeysKeyIdEncryptPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/encrypt",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(encrypt_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdEncryptPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve a single public key.
pub fn keys_key_id_get(
    configuration: &configuration::Configuration,
    key_id: &str,
) -> Result<ResponseContent<crate::models::PublicKey>, Error<KeysKeyIdGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Move a key by changing its identifier. The key content remains unchanged, but it will be accessible under the new identifier. The old identifier becomes invalid after successful move.
pub fn keys_key_id_move_post(
    configuration: &configuration::Configuration,
    key_id: &str,
    move_key_request: crate::models::MoveKeyRequest,
) -> Result<ResponseContent<crate::models::CreateResourceId>, Error<KeysKeyIdMovePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/move",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(move_key_request);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdMovePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve public key in PEM format.
pub fn keys_key_id_public_pem_get(
    configuration: &configuration::Configuration,
    key_id: &str,
) -> Result<ResponseContent<String>, Error<KeysKeyIdPublicPemGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/public.pem",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/x-pem-file";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::string(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdPublicPemGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Import a private key into NetHSM and store it under the *KeyID* path. The public key will be automatically derived. The parameters of the key can be passed as a PEM file or a JSON object. The key is stored in the caller's namespace.
pub fn keys_key_id_put(
    configuration: &configuration::Configuration,
    key_id: &str,
    body: KeysKeyIdPutBody,
) -> Result<ResponseContent<()>, Error<KeysKeyIdPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let body_json = body.is_json();
    local_var_req_builder = local_var_req_builder.header("content-type", body.content_type());

    let local_var_result = if body_json {
        local_var_req_builder.send_json(body)
    } else {
        local_var_req_builder.send(body.get_string().as_str())
    };

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete a tag from the authorized set
pub fn keys_key_id_restrictions_tags_tag_delete(
    configuration: &configuration::Configuration,
    tag: &str,
    key_id: &str,
) -> Result<ResponseContent<()>, Error<KeysKeyIdRestrictionsTagsTagDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/restrictions/tags/{Tag}",
        local_var_configuration.base_path,
        Tag = crate::apis::urlencode(tag),
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdRestrictionsTagsTagDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Add a tag to the authorized set
pub fn keys_key_id_restrictions_tags_tag_put(
    configuration: &configuration::Configuration,
    tag: &str,
    key_id: &str,
) -> Result<ResponseContent<()>, Error<KeysKeyIdRestrictionsTagsTagPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/restrictions/tags/{Tag}",
        local_var_configuration.base_path,
        Tag = crate::apis::urlencode(tag),
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdRestrictionsTagsTagPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Sign a message with the secret key.
pub fn keys_key_id_sign_post(
    configuration: &configuration::Configuration,
    key_id: &str,
    sign_request_data: crate::models::SignRequestData,
) -> Result<ResponseContent<crate::models::SignData>, Error<KeysKeyIdSignPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyID}/sign",
        local_var_configuration.base_path,
        KeyID = crate::apis::urlencode(key_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(sign_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyIdSignPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get a list of the identifiers of all keys that have a KeyID that starts with KeyPrefix. If the caller is in a namespace, only keys in that namespace are returned. Separate requests need to be made to request the individual key data.
pub fn keys_key_prefix_get(
    configuration: &configuration::Configuration,
    key_prefix: &str,
    filter: Option<&str>,
) -> Result<ResponseContent<Vec<crate::models::KeyItem>>, Error<KeysKeyPrefixGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/keys/{KeyPrefix}*",
        local_var_configuration.base_path,
        KeyPrefix = crate::apis::urlencode(key_prefix)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(local_var_str) = filter {
        local_var_req_builder =
            local_var_req_builder.query_pairs([("filter", local_var_str.to_string().as_str())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysKeyPrefixGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Import a private key into NetHSM and let NetHSM generate a KeyID. The public key will be automatically derived. The parameters of the key can be passed as a PEM file or a JSON object. The key is stored in the caller's namespace.
pub fn keys_post(
    configuration: &configuration::Configuration,
    body: KeysPostBody,
) -> Result<ResponseContent<crate::models::CreateResourceId>, Error<KeysPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/keys", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let body_json = body.is_json();
    local_var_req_builder = local_var_req_builder.header("content-type", body.content_type());

    let local_var_result = if body_json {
        local_var_req_builder.send_json(body)
    } else {
        local_var_req_builder.send(body.get_string().as_str())
    };

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            KeysPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Brings an *Operational* NetHSM into *Locked* state.
pub fn lock_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<LockPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/lock", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            LockPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get metrics. Precondition: NetHSM is *Operational* and a **R-Metrics** can be authenticated.
pub fn metrics_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<serde_json::Value>, Error<MetricsGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/metrics", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            MetricsGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get a list of all created namespaces. Note that users may be assigned namespaces not present in this list, as long as the namespace has not been created.
pub fn namespaces_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<Vec<crate::models::NamespaceItem>>, Error<NamespacesGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/namespaces", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            NamespacesGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete a namespace. **WARNING: all keys from that namespace are deleted.**
pub fn namespaces_namespace_id_delete(
    configuration: &configuration::Configuration,
    namespace_id: &str,
) -> Result<ResponseContent<()>, Error<NamespacesNamespaceIdDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/namespaces/{NamespaceID}",
        local_var_configuration.base_path,
        NamespaceID = crate::apis::urlencode(namespace_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            NamespacesNamespaceIdDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Create a namespace on keyfender. All users in that namespace can now be used, and all user management power is delegated to admins in that namespace.
pub fn namespaces_namespace_id_put(
    configuration: &configuration::Configuration,
    namespace_id: &str,
) -> Result<ResponseContent<()>, Error<NamespacesNamespaceIdPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/namespaces/{NamespaceID}",
        local_var_configuration.base_path,
        NamespaceID = crate::apis::urlencode(namespace_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            NamespacesNamespaceIdPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Initial provisioning, only available in *Unprovisioned* state.  *WARNING:* The unlock passphrase can't be reset by an admin user without knowing the current value, so if the unlock passphrase is lost, neither can it be reset to a new value nor can the NetHSM be unlocked.
pub fn provision_post(
    configuration: &configuration::Configuration,
    provision_request_data: crate::models::ProvisionRequestData,
) -> Result<ResponseContent<()>, Error<ProvisionPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/provision", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(provision_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            ProvisionPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Retrieve cryptographically strong random bytes from NetHSM. Precondition: NetHSM is *Operational* and a **R-Operator** can be authenticated.
pub fn random_post(
    configuration: &configuration::Configuration,
    random_request_data: crate::models::RandomRequestData,
) -> Result<ResponseContent<crate::models::RandomData>, Error<RandomPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/random", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(random_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            RandomPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Back up the key store to a backup file.
pub fn system_backup_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<std::vec::Vec<u8>>, Error<SystemBackupPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/backup", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/octet-stream";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::bytes(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemBackupPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Cancel update of NetHSM software.
pub fn system_cancel_update_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<SystemCancelUpdatePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/cancel-update", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemCancelUpdatePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Commit update of NetHSM software.
pub fn system_commit_update_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<SystemCommitUpdatePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/commit-update", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemCommitUpdatePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Reset NetHSM to factory settings.
pub fn system_factory_reset_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<SystemFactoryResetPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/factory-reset", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemFactoryResetPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get detailed system information, including firmware, system, and hardware version.
pub fn system_info_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<crate::models::SystemInfo>, Error<SystemInfoGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/info", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemInfoGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Reboot NetHSM.
pub fn system_reboot_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<SystemRebootPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/reboot", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemRebootPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Restore the key store and user store from a backup file. If NetHSM is *Unprovisioned*, then the configuration is restored.
pub fn system_restore_post(
    configuration: &configuration::Configuration,
    arguments: Option<crate::models::RestoreRequestArguments>,
    backup_file: Option<std::vec::Vec<u8>>,
) -> Result<ResponseContent<()>, Error<SystemRestorePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/restore", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let mut local_var_multipart = ::multipart::client::lazy::Multipart::new();

    if let Some(backup_file) = backup_file {
        local_var_multipart.add_stream(
            "backup_file",
            ::std::io::Cursor::new(backup_file),
            None::<&str>,
            None,
        );
    }
    if let Some(arguments) = arguments {
        let arguments = ::serde_json::to_vec(&arguments)?;
        local_var_multipart.add_stream(
            "arguments",
            ::std::io::Cursor::new(arguments),
            None::<&str>,
            None,
        );
    }

    let mut local_var_multipart = local_var_multipart.prepare()?;
    local_var_req_builder = local_var_req_builder.header(
        "content-type",
        &format!(
            "multipart/form-data; boundary={}",
            local_var_multipart.boundary()
        ),
    );
    let local_var_result =
        local_var_req_builder.send(ureq::SendBody::from_reader(&mut local_var_multipart));

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemRestorePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Shut down NetHSM.  Authentication behavior varies by NetHSM state: - **Operational**: Requires Administrator authentication - **Locked** or **Unprovisioned**: No authentication required
pub fn system_shutdown_post(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<()>, Error<SystemShutdownPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/shutdown", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemShutdownPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Update NetHSM software.
pub fn system_update_post(
    configuration: &configuration::Configuration,
    body: std::vec::Vec<u8>,
) -> Result<ResponseContent<crate::models::SystemUpdateData>, Error<SystemUpdatePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/system/update", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder =
        local_var_req_builder.header("content-type", "application/octet-stream");
    let local_var_result = local_var_req_builder.send(body);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            SystemUpdatePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Brings a *Locked* NetHSM into *Operational* state.
pub fn unlock_post(
    configuration: &configuration::Configuration,
    unlock_request_data: crate::models::UnlockRequestData,
) -> Result<ResponseContent<()>, Error<UnlockPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/unlock", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(unlock_request_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UnlockPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get a list of all user ids that have accounts on NetHSM. If the caller is in a namespace, return only users in that namespace.
pub fn users_get(
    configuration: &configuration::Configuration,
) -> Result<ResponseContent<Vec<crate::models::UserItem>>, Error<UsersGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/users", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Create a new user on NetHSM, inheriting the caller's namespace. The user-ID is generated by NetHSM.
pub fn users_post(
    configuration: &configuration::Configuration,
    user_post_data: crate::models::UserPostData,
) -> Result<ResponseContent<crate::models::CreateResourceId>, Error<UsersPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/users", local_var_configuration.base_path);
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(user_post_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete a user from keyfender.
pub fn users_user_id_delete(
    configuration: &configuration::Configuration,
    user_id: &str,
) -> Result<ResponseContent<()>, Error<UsersUserIdDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get user info: name and role.
pub fn users_user_id_get(
    configuration: &configuration::Configuration,
    user_id: &str,
) -> Result<ResponseContent<crate::models::UserData>, Error<UsersUserIdGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Update the passphrase.
pub fn users_user_id_passphrase_post(
    configuration: &configuration::Configuration,
    user_id: &str,
    user_passphrase_post_data: crate::models::UserPassphrasePostData,
) -> Result<ResponseContent<()>, Error<UsersUserIdPassphrasePostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}/passphrase",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(user_passphrase_post_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdPassphrasePostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Create a new user on NetHSM, in the namespace specified as a prefix in the path with the format 'namespace~'. For example, a POST request on \"https://nethsm.local/v1/users/namespace1~\" will generate a user-ID and create that user in \"namespace1\". The namespace prefix *must* be present: for creating users without a namespace, use a POST on \"/v1/users\".
pub fn users_user_id_post(
    configuration: &configuration::Configuration,
    user_id: &str,
    user_post_data: crate::models::UserPostData,
) -> Result<ResponseContent<crate::models::CreateResourceId>, Error<UsersUserIdPostError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, POST, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(user_post_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdPostError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Create a user on keyfender. The new user must either be in the same namespace as the caller, or be in a namespace not created yet if the caller has no namespace.
pub fn users_user_id_put(
    configuration: &configuration::Configuration,
    user_id: &str,
    user_post_data: crate::models::UserPostData,
) -> Result<ResponseContent<()>, Error<UsersUserIdPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    local_var_req_builder = local_var_req_builder.header("content-type", "application/json");
    let local_var_result = local_var_req_builder.send_json(user_post_data);

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Get the list of tags set to an Operator user.
pub fn users_user_id_tags_get(
    configuration: &configuration::Configuration,
    user_id: &str,
) -> Result<ResponseContent<Vec<String>>, Error<UsersUserIdTagsGetError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}/tags",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, GET, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };
    let accept_str = "application/json";
    local_var_req_builder = local_var_req_builder.header("accept", accept_str);

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::deserialized(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdTagsGetError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Delete a tag from the Operator user
pub fn users_user_id_tags_tag_delete(
    configuration: &configuration::Configuration,
    user_id: &str,
    tag: &str,
) -> Result<ResponseContent<()>, Error<UsersUserIdTagsTagDeleteError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}/tags/{Tag}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id),
        Tag = crate::apis::urlencode(tag)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, DELETE, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdTagsTagDeleteError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}

/// Add a tag to the Operator user.
pub fn users_user_id_tags_tag_put(
    configuration: &configuration::Configuration,
    user_id: &str,
    tag: &str,
) -> Result<ResponseContent<()>, Error<UsersUserIdTagsTagPutError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!(
        "{}/users/{UserID}/tags/{Tag}",
        local_var_configuration.base_path,
        UserID = crate::apis::urlencode(user_id),
        Tag = crate::apis::urlencode(tag)
    );
    let mut local_var_req_builder =
        create_request!(local_var_client, PUT, local_var_uri_str.as_str());
    local_var_req_builder = local_var_req_builder
        .config()
        .http_status_as_error(false)
        .build();

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header("user-agent", local_var_user_agent);
    }
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        let value = super::basic_auth(local_var_auth_conf);

        local_var_req_builder = local_var_req_builder.header("authorization", &value);
    };

    let local_var_result = local_var_req_builder.send_empty();

    let local_var_resp = local_var_result?;

    let local_var_status = local_var_resp.status().as_u16();
    if local_var_status < 400 {
        ResponseContent::unit(local_var_resp)
    } else {
        ResponseContent::new(local_var_resp, |data| {
            UsersUserIdTagsTagPutError::new(local_var_status, data).map_err(From::from)
        })
        .and_then(|content| Err(Error::ResponseError(content)))
    }
}
