/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "keyboard-plugin.h"
#include "clib-syslog.h"

PluginInterface * KeyboardPlugin::mInstance=nullptr;

KeyboardPlugin::KeyboardPlugin()
{
    USD_LOG(LOG_DEBUG,"KeyboardPlugin initializing!");

    if (UsdBaseClass::isXcb()) {
        KeyboardManager = KeyboardManager::KeyboardManagerNew();
    } else {
        //wayland
        KeyboardManager = KeyboardWaylandManager::KeyboardWaylandManagerNew();
    }
}

KeyboardPlugin::~KeyboardPlugin()
{
    USD_LOG(LOG_DEBUG,"Keyboard plugin free");
    if (KeyboardManager){
        delete KeyboardManager;
        KeyboardManager = nullptr;
    }
}

void KeyboardPlugin::activate()
{
    bool res;
    USD_LOG (LOG_DEBUG, "Activating %s plugin compilation time:[%s] [%s]",MODULE_NAME,__DATE__,__TIME__);
    if (KeyboardManager) {
        res = KeyboardManager->Start();
    }

    if(!res){
        USD_LOG(LOG_ERR,"Unable to start Keyboard Manager!")
    }

}

PluginInterface * KeyboardPlugin::getInstance()
{
    if(nullptr == mInstance){
        mInstance = new KeyboardPlugin();
    }
    return  mInstance;
}

void KeyboardPlugin::deactivate()
{
    USD_LOG(LOG_DEBUG,"Deactivating Keyboard Plugin");
    if (KeyboardManager) {
        KeyboardManager->Stop();
    }
}

PluginInterface *createSettingsPlugin()
{
    return KeyboardPlugin::getInstance();
}


